/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.lzy.template.word.common.TagParser;
import pers.lzy.template.word.pojo.WordCell;
import pers.lzy.template.word.pojo.WordTable;
import pers.lzy.template.word.pojo.poi.TextWordCell;
import pers.lzy.template.word.pojo.poi.WordParagraph;
import pers.lzy.template.word.pojo.poi.WordRun;

public class WordUtil {
    private static final Logger log = LoggerFactory.getLogger(WordUtil.class);

    public static void setRunValue(XWPFRun run, Object value) {
        if (value == null) {
            run.setText(null, 0);
            return;
        }
        run.setText(value.toString(), 0);
    }

    public static void cleanParagraphContent(XWPFParagraph paragraph) {
        for (XWPFRun run : paragraph.getRuns()) {
            run.setText(null, 0);
        }
    }

    public static void insertRunAndCopyStyle(XWPFParagraph paragraph, int sourceRunIndex, int insertRunIndex, String insertValue) {
        List runs = paragraph.getRuns();
        XWPFRun sourceRun = (XWPFRun)runs.get(sourceRunIndex);
        XWPFRun insertRun = paragraph.insertNewRun(insertRunIndex);
        WordUtil.setRunValue(insertRun, insertValue);
        WordUtil.copyRunStyle(sourceRun, insertRun);
    }

    private static void copyRunStyle(XWPFRun sourceRun, XWPFRun targetRun) {
        targetRun.setVerticalAlignment(sourceRun.getVerticalAlignment().toString());
        targetRun.setBold(sourceRun.isBold());
        targetRun.setCapitalized(sourceRun.isCapitalized());
        targetRun.setCharacterSpacing(sourceRun.getCharacterSpacing());
        targetRun.setColor(sourceRun.getColor());
        targetRun.setDoubleStrikethrough(sourceRun.isDoubleStrikeThrough());
        targetRun.setEmbossed(sourceRun.isEmbossed());
        targetRun.setEmphasisMark(sourceRun.getEmphasisMark().toString());
        targetRun.setFontFamily(sourceRun.getFontFamily());
        if (sourceRun.getFontSize() != -1) {
            targetRun.setFontSize(sourceRun.getFontSize());
        }
        targetRun.setImprinted(sourceRun.isImprinted());
        targetRun.setItalic(sourceRun.isItalic());
        targetRun.setKerning(sourceRun.getKerning());
        targetRun.setLang(sourceRun.getLang());
        targetRun.setShadow(sourceRun.isShadowed());
        targetRun.setSmallCaps(sourceRun.isSmallCaps());
        targetRun.setStrikeThrough(sourceRun.isStrikeThrough());
        targetRun.setStyle(sourceRun.getStyle());
        targetRun.setTextHighlightColor(sourceRun.getTextHightlightColor().toString());
        targetRun.setVanish(sourceRun.isVanish());
        targetRun.setUnderlineThemeColor(sourceRun.getUnderlineThemeColor().toString());
        targetRun.setUnderlineColor(sourceRun.getUnderlineColor());
        targetRun.setTextScale(sourceRun.getTextScale());
    }

    public static void mergeRunText(XWPFParagraph paragraph) {
        String text = paragraph.getText();
        List runs = paragraph.getRuns();
        int index = 0;
        for (XWPFRun run : runs) {
            if (index == 0) {
                run.setText(null, 0);
                run.setText(text, 0);
            } else {
                run.setText(null, 0);
            }
            ++index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(XWPFDocument xwpfDocument, File localModuleFile) {
        FileOutputStream excelFileOutPutStream = null;
        try {
            excelFileOutPutStream = new FileOutputStream(localModuleFile);
            xwpfDocument.write((OutputStream)excelFileOutPutStream);
            excelFileOutPutStream.flush();
        }
        catch (Exception e) {
            log.error("export error ", (Throwable)e);
        }
        finally {
            if (excelFileOutPutStream != null) {
                try {
                    excelFileOutPutStream.close();
                }
                catch (Exception e) {
                    log.error("export error ", (Throwable)e);
                }
            }
        }
    }

    public static void addRows(XWPFTable table, int sourceRowIndex, int rows, int insertRowIndex) {
        for (int i = 1; i <= rows; ++i) {
            XWPFTableRow sourceRow = table.getRow(sourceRowIndex);
            XWPFTableRow targetRow = table.insertNewTableRow(insertRowIndex++);
            targetRow.getCtRow().setTrPr(sourceRow.getCtRow().getTrPr());
            List sourceCells = sourceRow.getTableCells();
            for (XWPFTableCell sourceCell : sourceCells) {
                CTJc ctjc;
                XWPFTableCell newCell = targetRow.addNewTableCell();
                newCell.setVerticalAlignment(sourceCell.getVerticalAlignment());
                newCell.setColor(sourceCell.getColor());
                newCell.setWidth(String.valueOf(sourceCell.getWidth()));
                newCell.setWidthType(sourceCell.getWidthType());
                newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
                CTPPr pPr = ((CTP)sourceCell.getCTTc().getPList().get(0)).getPPr();
                if (pPr == null || pPr.getJc() == null || pPr.getJc().getVal() == null) continue;
                CTTc cttc = newCell.getCTTc();
                CTP ctp = (CTP)cttc.getPList().get(0);
                CTPPr ctppr = ctp.getPPr();
                if (ctppr == null) {
                    ctppr = ctp.addNewPPr();
                }
                if ((ctjc = ctppr.getJc()) == null) {
                    ctjc = ctppr.addNewJc();
                }
                ctjc.setVal(pPr.getJc().getVal());
            }
        }
    }

    public static void setCellObjValue(WordTable table, int rowNum, int colNum, TextWordCell textWordCell, WordCell sourceCell) {
        XWPFTable poiTable = table.getTable();
        XWPFTableRow row = poiTable.getRow(rowNum);
        if (row == null) {
            row = poiTable.insertNewTableRow(rowNum);
        }
        XWPFTableCell targetCell = row.getCell(colNum);
        List sourceParagraphList = sourceCell.getCell().getParagraphs();
        List<WordParagraph> textParagraphs = textWordCell.getParagraphs();
        for (int sourceParagraphIndex = 0; sourceParagraphIndex < sourceParagraphList.size(); ++sourceParagraphIndex) {
            XWPFParagraph sourceParagraph = (XWPFParagraph)sourceParagraphList.get(sourceParagraphIndex);
            WordParagraph wordParagraph = textParagraphs.get(sourceParagraphIndex);
            XWPFParagraph targetParagraph = targetCell.getParagraphArray(sourceParagraphIndex);
            if (targetParagraph == null) {
                targetParagraph = targetCell.addParagraph();
            }
            targetParagraph.getCTP().setPPr(sourceParagraph.getCTP().getPPr());
            List sourceRuns = sourceParagraph.getRuns();
            if (sourceRuns == null) continue;
            List<WordRun> wordRuns = wordParagraph.getRuns();
            for (int sourceRunIndex = 0; sourceRunIndex < sourceRuns.size(); ++sourceRunIndex) {
                XWPFRun sourceRun = (XWPFRun)sourceRuns.get(sourceRunIndex);
                WordRun wordRun = wordRuns.get(sourceRunIndex);
                XWPFRun targetRun = WordUtil.getRunByIndex(targetParagraph, sourceRunIndex);
                if (targetRun == null) {
                    targetRun = targetParagraph.createRun();
                }
                WordUtil.copyRunStyle(sourceRun, targetRun);
                WordUtil.setRunValue(targetRun, wordRun.getValue());
            }
        }
    }

    private static XWPFRun getRunByIndex(XWPFParagraph targetParagraph, int index) {
        List runs = targetParagraph.getRuns();
        if (runs == null) {
            return null;
        }
        if (index >= 0 && index < runs.size()) {
            return (XWPFRun)runs.get(index);
        }
        return null;
    }

    public static TextWordCell extractFormatTextCell(WordCell cell, String tagName) {
        if (cell == null) {
            return null;
        }
        XWPFTableCell poiCell = cell.getCell();
        if (poiCell == null) {
            return null;
        }
        List paragraphs = poiCell.getParagraphs();
        if (paragraphs == null) {
            return null;
        }
        TagParser.removeTagName(paragraphs, tagName);
        ArrayList<WordParagraph> wordParagraphs = new ArrayList<WordParagraph>(paragraphs.size());
        for (XWPFParagraph paragraph : paragraphs) {
            TagParser.formatExpressionInMultiRuns(paragraph);
            List runs = paragraph.getRuns();
            if (runs == null) {
                wordParagraphs.add(new WordParagraph(null));
                continue;
            }
            ArrayList<WordRun> wordRuns = new ArrayList<WordRun>();
            for (XWPFRun run : runs) {
                wordRuns.add(new WordRun(run.text()));
            }
            wordParagraphs.add(new WordParagraph(wordRuns));
        }
        return new TextWordCell(wordParagraphs);
    }
}

