/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.lzy.template.word.anno.HandlerOrder;
import pers.lzy.template.word.utils.ServiceLoaderUtil;

public class SpiLoader {
    private static final Logger logger = LoggerFactory.getLogger(SpiLoader.class);
    private static final Map<String, ServiceLoader<?>> SERVICE_LOADER_MAP = new ConcurrentHashMap();

    public static <T> List<T> loadInstanceListSorted(Class<T> clazz) {
        try {
            String key = clazz.getName();
            ServiceLoader<Object> serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoaderUtil.getServiceLoader(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            ArrayList orderWrappers = new ArrayList();
            for (Object spi : serviceLoader) {
                int order = SpiOrderResolver.resolveOrder(spi);
                SpiOrderResolver.insertSorted(orderWrappers, spi, order);
                logger.info("[SpiLoader] Found {} SPI: {} with order {}", new Object[]{clazz.getSimpleName(), spi.getClass().getCanonicalName(), order});
            }
            ArrayList<Object> list = new ArrayList<Object>(orderWrappers.size());
            for (SpiOrderWrapper orderWrapper : orderWrappers) {
                list.add(orderWrapper.spi);
            }
            return list;
        }
        catch (Throwable t) {
            logger.error("[SpiLoader] ERROR: loadInstanceListSorted failed", t);
            return new ArrayList();
        }
    }

    private static class SpiOrderWrapper<T> {
        private final int order;
        private final T spi;

        SpiOrderWrapper(int order, T spi) {
            this.order = order;
            this.spi = spi;
        }

        int getOrder() {
            return this.order;
        }

        T getSpi() {
            return this.spi;
        }
    }

    private static class SpiOrderResolver {
        private SpiOrderResolver() {
        }

        private static <T> void insertSorted(List<SpiOrderWrapper<T>> list, T spi, int order) {
            int idx;
            for (idx = 0; idx < list.size() && list.get(idx).getOrder() <= order; ++idx) {
            }
            list.add(idx, new SpiOrderWrapper<T>(order, spi));
        }

        private static <T> int resolveOrder(T spi) {
            if (!spi.getClass().isAnnotationPresent(HandlerOrder.class)) {
                return Integer.MAX_VALUE;
            }
            return spi.getClass().getAnnotation(HandlerOrder.class).value();
        }
    }
}

