/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import pers.lzy.template.word.common.PatternPool;

public class ReUtils {
    public static List<String> findAll(String regex, CharSequence content, int group) {
        return ReUtils.findAll(regex, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(String regex, CharSequence content, int group, T collection) {
        if (null == regex) {
            return collection;
        }
        return ReUtils.findAll(Pattern.compile(regex, 32), content, group, collection);
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, CharSequence content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        if (null == collection) {
            throw new NullPointerException("Null collection param provided!");
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            collection.add((String)matcher.group(group));
        }
        return collection;
    }

    public static List<String> findAll(Pattern pattern, CharSequence content, int group) {
        if (null == pattern || null == content) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            res.add(matcher.group(group));
        }
        return res;
    }

    public static String get(String regex, CharSequence content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return ReUtils.get(pattern, content, groupIndex);
    }

    public static String get(Pattern pattern, CharSequence content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static String replaceAll(CharSequence str, String regex, Func1<Matcher, String> replaceFun) {
        return ReUtils.replaceAll(str, Pattern.compile(regex), replaceFun);
    }

    public static String replaceAll(CharSequence str, Pattern pattern, Func1<Matcher, String> replaceFun) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null == str ? null : str.toString();
        }
        Matcher matcher = pattern.matcher(str);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(buffer, replaceFun.call(matcher));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    @FunctionalInterface
    public static interface Func1<P, R> {
        public R call(P var1) throws Exception;
    }
}

