/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.handler.cell;

import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import pers.lzy.template.word.anno.HandlerOrder;
import pers.lzy.template.word.anno.TagOperateHandler;
import pers.lzy.template.word.common.TagParser;
import pers.lzy.template.word.core.AbstractOperateTableCellHandler;
import pers.lzy.template.word.core.DocumentParagraphFiller;
import pers.lzy.template.word.core.ExpressionCalculator;
import pers.lzy.template.word.pojo.WordCell;
import pers.lzy.template.word.pojo.WordRow;
import pers.lzy.template.word.pojo.WordTable;
import pers.lzy.template.word.utils.WordUtil;

@HandlerOrder(value=20000)
@TagOperateHandler(tagName="t-simple")
public class TableSimpleEvalOperateTableCellHandler
extends AbstractOperateTableCellHandler {
    @Override
    public void operate(XWPFDocument document, WordTable table, WordRow row, WordCell cell, Map<String, Object> params, ExpressionCalculator expressionCalculator, DocumentParagraphFiller documentParagraphFiller) {
        List<XWPFParagraph> paragraphs = cell.paragraphs();
        if (paragraphs == null) {
            return;
        }
        TagParser.removeTagName(paragraphs, this.tagName);
        for (XWPFParagraph paragraph : paragraphs) {
            TagParser.formatExpressionInMultiRuns(paragraph);
            this.operateParagraph(document, paragraph, params, expressionCalculator);
        }
    }

    private void operateParagraph(XWPFDocument document, XWPFParagraph paragraph, Map<String, Object> params, ExpressionCalculator expressionCalculator) {
        List runs = paragraph.getRuns();
        if (runs == null) {
            return;
        }
        for (XWPFRun run : runs) {
            String expression = run.text();
            if (!TagParser.verifyHasExpression(expression)) continue;
            this.doOperate(document, run, params, expression, expressionCalculator);
        }
    }

    private void doOperate(XWPFDocument document, XWPFRun run, Map<String, Object> params, String expression, ExpressionCalculator expressionCalculator) {
        Object result = expressionCalculator.calculateNoFormat(expression, params);
        WordUtil.setRunValue(run, this.formatCellValue(result));
    }

    protected Object formatCellValue(Object realValue) {
        return realValue;
    }
}

