/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.handler.cell;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import pers.lzy.template.word.anno.HandlerOrder;
import pers.lzy.template.word.anno.TagOperateHandler;
import pers.lzy.template.word.common.TagParser;
import pers.lzy.template.word.core.AbstractOperateTableCellHandler;
import pers.lzy.template.word.core.DocumentParagraphFiller;
import pers.lzy.template.word.core.ExpressionCalculator;
import pers.lzy.template.word.pojo.ArrInfo;
import pers.lzy.template.word.pojo.WordCell;
import pers.lzy.template.word.pojo.WordRow;
import pers.lzy.template.word.pojo.WordTable;
import pers.lzy.template.word.pojo.poi.TextWordCell;
import pers.lzy.template.word.pojo.poi.WordParagraph;
import pers.lzy.template.word.pojo.poi.WordRun;
import pers.lzy.template.word.utils.WordUtil;

@HandlerOrder(value=20000)
@TagOperateHandler(tagName="arr")
public class ArrEvalOperateTableCellHandler
extends AbstractOperateTableCellHandler {
    @Override
    public void operate(XWPFDocument document, WordTable table, WordRow row, WordCell cell, Map<String, Object> params, ExpressionCalculator expressionCalculator, DocumentParagraphFiller documentParagraphFiller) {
        String cellText = cell.getCell().getText();
        Collection<?> arrInParamsByExpression = expressionCalculator.parseObjArrInParamMap(cellText, params);
        Map arrHistory = (Map)params.get("ARR_HISTORY_ITEM");
        int traverseNumber = arrInParamsByExpression.size();
        int rowIndex = row.getRowIndex();
        ArrInfo arrInfo = this.parseArrInfo(arrHistory, rowIndex, cell, arrInParamsByExpression);
        traverseNumber = this.determineTraverseNumber(traverseNumber, arrInfo);
        this.insertRowsIfNecessary(table, cell, arrInfo);
        TextWordCell textWordCell = WordUtil.extractFormatTextCell(cell, this.tagName);
        this.fillArrDataToTable(table, cell, textWordCell, traverseNumber, arrInfo, params, expressionCalculator);
    }

    private void fillArrDataToTable(WordTable table, WordCell cell, TextWordCell textWordCell, int traverseNumber, ArrInfo arrInfo, Map<String, Object> params, ExpressionCalculator expressionCalculator) {
        boolean blankFlag = false;
        if (traverseNumber <= 0) {
            ++traverseNumber;
            blankFlag = true;
        }
        for (int index = 0; index < traverseNumber; ++index) {
            TextWordCell processedTextWordCell = this.cloneAndCalculate(textWordCell, expressionCalculator, params, index, blankFlag);
            WordUtil.setCellObjValue(table, arrInfo.getStartRow() + index, cell.getCellIndex(), processedTextWordCell, cell);
        }
    }

    private TextWordCell cloneAndCalculate(TextWordCell textWordCell, ExpressionCalculator expressionCalculator, Map<String, Object> params, int paramArrIndex, boolean blankFlag) {
        TextWordCell textWordCellClone = (TextWordCell)JSON.parseObject((String)JSON.toJSONString((Object)textWordCell), TextWordCell.class);
        List<WordParagraph> paragraphs = textWordCellClone.getParagraphs();
        if (paragraphs == null) {
            return textWordCellClone;
        }
        for (WordParagraph paragraph : paragraphs) {
            List<WordRun> runs = paragraph.getRuns();
            if (runs == null) continue;
            for (WordRun run : runs) {
                if (blankFlag) {
                    run.setValue(this.formatCellValue(null));
                    continue;
                }
                String expression = run.getValue();
                if (!TagParser.verifyHasExpression(expression)) continue;
                String realExpressionStr = expression.replaceAll("\\[]", String.format("[%d]", paramArrIndex));
                Object result = expressionCalculator.calculateNoFormat(realExpressionStr, params);
                run.setValue(this.formatCellValue(result));
            }
        }
        return textWordCellClone;
    }

    private Object formatCellValue(Object realValue) {
        return realValue;
    }

    private void insertRowsIfNecessary(WordTable table, WordCell cell, ArrInfo arrInfo) {
        if (arrInfo.getInsertRowFlag().booleanValue()) {
            WordUtil.addRows(table.getTable(), arrInfo.getStartRow(), arrInfo.getSize() - 1, arrInfo.getStartRow() + 1);
        }
    }

    private int determineTraverseNumber(int traverseNumber, ArrInfo arrInfo) {
        Integer arrTraverseNumber = arrInfo.getSize();
        return Math.min(traverseNumber, arrTraverseNumber);
    }

    private ArrInfo parseArrInfo(Map<String, ArrInfo> arrHistory, int rowIndex, WordCell cell, Collection<?> arrInParamsByExpression) {
        ArrInfo arrInfo = arrHistory.get(String.valueOf(rowIndex));
        if (arrInfo == null) {
            arrInfo = new ArrInfo();
            arrInfo.setStartRow(rowIndex);
            arrInfo.setSize(arrInParamsByExpression.size());
            arrInfo.setInsertRowFlag(true);
            arrInfo.setMinColumnIndexFromGiven(cell.getCellIndex());
            arrHistory.put(String.valueOf(rowIndex), arrInfo);
        } else {
            arrInfo.setMinColumnIndexFromGiven(cell.getCellIndex());
            arrInfo.setInsertRowFlag(false);
        }
        return arrInfo;
    }
}

