/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.filler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.lzy.template.word.anno.TagOperateHandler;
import pers.lzy.template.word.calculator.Jxel3ExpressionCalculator;
import pers.lzy.template.word.common.TagParser;
import pers.lzy.template.word.core.DocumentParagraphFiller;
import pers.lzy.template.word.core.ExpressionCalculator;
import pers.lzy.template.word.core.TemplateWordFiller;
import pers.lzy.template.word.core.filler.DefaultDocumentParagraphFiller;
import pers.lzy.template.word.core.handler.OperateParagraphHandler;
import pers.lzy.template.word.core.handler.OperateTableCellHandler;
import pers.lzy.template.word.core.holder.OperateParagraphHandlerHolder;
import pers.lzy.template.word.core.holder.OperateTableCellHandlerHolder;
import pers.lzy.template.word.exception.OperateWordHandlerInitException;
import pers.lzy.template.word.pojo.WordCell;
import pers.lzy.template.word.pojo.WordRow;
import pers.lzy.template.word.pojo.WordTable;
import pers.lzy.template.word.provider.DocumentProvider;
import pers.lzy.template.word.provider.FillDataProvider;
import pers.lzy.template.word.provider.FunctionProvider;
import pers.lzy.template.word.utils.SpiLoader;

public class DefaultTemplateWordFiller
implements TemplateWordFiller {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTemplateWordFiller.class);
    private final DocumentParagraphFiller documentParagraphFiller;
    private final ExpressionCalculator expressionCalculator;
    private final Map<String, OperateParagraphHandler> operateParagraphHandlerTagMap;
    private final Map<String, OperateTableCellHandler> operateTableCellHandlerTagMap;

    public DefaultTemplateWordFiller(Builder builder) {
        int expressionCacheSize = builder.expressionCacheSize;
        this.expressionCalculator = builder.expressionCalculator != null ? builder.expressionCalculator : new Jxel3ExpressionCalculator(builder.jxltEngine, expressionCacheSize);
        this.operateParagraphHandlerTagMap = builder.operateParagraphHandlerTagMap;
        this.operateTableCellHandlerTagMap = builder.operateTableCellHandlerTagMap;
        this.documentParagraphFiller = DefaultDocumentParagraphFiller.getInstance(this.operateParagraphHandlerTagMap, this.expressionCalculator);
    }

    @Override
    public void fillData(DocumentProvider documentProvider, FillDataProvider dataProvider) {
        XWPFDocument document = documentProvider.getDocument();
        Map<String, Object> paramData = dataProvider.getParamData();
        if (document == null || paramData == null) {
            throw new IllegalStateException("document and paramData cannot be null");
        }
        this.verifyAndInitParamData(paramData);
        this.processParagraphs(document, paramData);
        this.processTables(document, paramData);
    }

    private void processTables(XWPFDocument document, Map<String, Object> paramData) {
        logger.info("process table");
        List tables = document.getTables();
        if (tables == null) {
            return;
        }
        for (int tableIndex = 0; tableIndex < tables.size(); ++tableIndex) {
            XWPFTable table = (XWPFTable)tables.get(tableIndex);
            WordTable wordTable = new WordTable(tableIndex, table);
            List rows = table.getRows();
            this.initCurrentTableParam(paramData, tableIndex);
            if (rows == null) continue;
            for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
                XWPFTableRow row = (XWPFTableRow)rows.get(rowIndex);
                WordRow wordRow = new WordRow(rowIndex, row);
                List tableCells = row.getTableCells();
                if (tableCells == null) {
                    return;
                }
                for (int cellIndex = 0; cellIndex < tableCells.size(); ++cellIndex) {
                    XWPFTableCell cell = (XWPFTableCell)tableCells.get(cellIndex);
                    WordCell wordCell = new WordCell(cellIndex, cell);
                    if (cell == null) continue;
                    this.doProcessCell(document, wordTable, wordRow, wordCell, paramData);
                }
            }
        }
    }

    private void initCurrentTableParam(Map<String, Object> paramData, int tableIndex) {
        HashMap tableArrItemInfo = new HashMap();
        Map arrAyHistory = (Map)paramData.get("ARR_HISTORY");
        arrAyHistory.put(tableIndex, tableArrItemInfo);
        paramData.put("ARR_HISTORY_ITEM", tableArrItemInfo);
    }

    private void doProcessCell(XWPFDocument document, WordTable table, WordRow row, WordCell cell, Map<String, Object> paramData) {
        String content = cell.getCell().getText();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            String tagName = TagParser.findContentTag(content);
            if (tagName == null) {
                return;
            }
            OperateTableCellHandler operateTableCellHandler = this.operateTableCellHandlerTagMap.get(tagName);
            if (operateTableCellHandler == null) {
                logger.warn("No tag({}) handler found, skipped", (Object)tagName);
                return;
            }
            operateTableCellHandler.operate(document, table, row, cell, paramData, this.expressionCalculator, this.documentParagraphFiller);
        }
    }

    private void processParagraphs(XWPFDocument document, Map<String, Object> paramData) {
        logger.info("process Paragraph");
        List paras = document.getParagraphs();
        if (paras == null) {
            return;
        }
        paras.forEach(paragraph -> this.doProcessParagraph(document, (XWPFParagraph)paragraph, paramData));
    }

    private void doProcessParagraph(XWPFDocument document, XWPFParagraph paragraph, Map<String, Object> paramData) {
        this.documentParagraphFiller.doProcessParagraph(document, paragraph, paramData);
    }

    private void verifyAndInitParamData(Map<String, Object> paramData) {
        if (paramData.get("ARR_HISTORY") != null) {
            logger.error("ARR_HISTORY cannot be used because some other information will be recorded");
            throw new IllegalArgumentException("ARR_HISTORY cannot be used because some other information will be recorded");
        }
        if (paramData.get("MERGE_ARR_INFO") != null) {
            logger.error("MERGE_ARR_INFO cannot be used because some other information will be recorded");
            throw new IllegalArgumentException("MERGE_ARR_INFO cannot be used because some other information will be recorded");
        }
        if (paramData.get("ARR_HISTORY_ITEM") != null) {
            logger.error("ARR_HISTORY_ITEM cannot be used because some other information will be recorded");
            throw new IllegalArgumentException("ARR_HISTORY_ITEM cannot be used because some other information will be recorded");
        }
        paramData.put("ARR_HISTORY", new HashMap());
        paramData.put("ARR_HISTORY_ITEM", new HashMap());
        paramData.put("MERGE_ARR_INFO", new ArrayList());
    }

    public static class Builder {
        private final JxltEngine jxltEngine;
        private final Map<String, Object> functions = new HashMap<String, Object>();
        private int expressionCacheSize = 1000;
        private final List<OperateParagraphHandler> operateParagraphHandlerList;
        private final List<OperateTableCellHandler> operateTableCellHandlerList;
        private ExpressionCalculator expressionCalculator;
        private Map<String, OperateParagraphHandler> operateParagraphHandlerTagMap;
        private Map<String, OperateTableCellHandler> operateTableCellHandlerTagMap;
        private List<OperateParagraphHandlerHolder> operateParagraphHandlerHolderList;
        private List<OperateTableCellHandlerHolder> operateTableCellHandlerHolderList;

        public Builder() {
            this.functions.putAll(this.loadFunctions());
            JexlEngine jexlEngine = new JexlBuilder().namespaces(this.functions).create();
            this.jxltEngine = jexlEngine.createJxltEngine();
            this.operateParagraphHandlerList = this.loadInstanceByInterface(OperateParagraphHandler.class);
            this.operateTableCellHandlerList = this.loadInstanceByInterface(OperateTableCellHandler.class);
            this.initAuxiliaryInfo();
        }

        private void initAuxiliaryInfo() {
            this.initOperateParagraphHandlerHolderList();
            this.initOperateTableCellHandlerHolderList();
            this.initOperateParagraphHandlerTagMap();
            this.initOperateTableCellHandlerTagMap();
        }

        private void initOperateTableCellHandlerTagMap() {
            logger.info("init OperateTableCellHandlerTagMap");
            this.operateTableCellHandlerTagMap = this.operateTableCellHandlerHolderList.stream().collect(Collectors.toConcurrentMap(OperateTableCellHandlerHolder::getHandlerTagName, OperateTableCellHandlerHolder::getOperateTableCellHandler, (oldV, newV) -> {
                throw new OperateWordHandlerInitException("There are multiple OperateHandler with the same tagName. cell:" + oldV + ";" + newV);
            }));
        }

        private void initOperateTableCellHandlerHolderList() {
            logger.info("init OperateTableCellHandlerHolderList");
            this.operateTableCellHandlerHolderList = this.operateTableCellHandlerList.stream().map(cellHandler -> {
                TagOperateHandler tagOperateHandler = cellHandler.getClass().getAnnotation(TagOperateHandler.class);
                if (tagOperateHandler == null) {
                    throw new OperateWordHandlerInitException("The OperateHandler must identify the CellOperateHandler annotation");
                }
                return new OperateTableCellHandlerHolder((OperateTableCellHandler)cellHandler, tagOperateHandler.tagName());
            }).collect(Collectors.toList());
        }

        private void initOperateParagraphHandlerHolderList() {
            logger.info("init OperateParagraphHandlerHolderList");
            this.operateParagraphHandlerHolderList = this.operateParagraphHandlerList.stream().map(cellHandler -> {
                TagOperateHandler tagOperateHandler = cellHandler.getClass().getAnnotation(TagOperateHandler.class);
                if (tagOperateHandler == null) {
                    throw new OperateWordHandlerInitException("The OperateHandler must identify the CellOperateHandler annotation");
                }
                return new OperateParagraphHandlerHolder((OperateParagraphHandler)cellHandler, tagOperateHandler.tagName());
            }).collect(Collectors.toList());
        }

        private void initOperateParagraphHandlerTagMap() {
            logger.info("init OperateParagraphHandlerTagMap");
            this.operateParagraphHandlerTagMap = this.operateParagraphHandlerHolderList.stream().collect(Collectors.toConcurrentMap(OperateParagraphHandlerHolder::getHandlerTagName, OperateParagraphHandlerHolder::getOperateParagraphHandler, (oldV, newV) -> {
                throw new OperateWordHandlerInitException("There are multiple OperateHandler with the same tagName. cell:" + oldV + ";" + newV);
            }));
        }

        private Map<String, Object> loadFunctions() {
            List<FunctionProvider> functionProviders = this.loadInstanceByInterface(FunctionProvider.class);
            return functionProviders.stream().map(FunctionProvider::provideFunctions).reduce(new HashMap(), (root, ele) -> {
                root.putAll(ele);
                return root;
            });
        }

        private <T> List<T> loadInstanceByInterface(Class<T> clazz) {
            return SpiLoader.loadInstanceListSorted(clazz);
        }

        public Builder functions(String key, Class<?> clazz) {
            this.functions.put(key, clazz);
            return this;
        }

        public Builder expressionCacheSize(int cacheSize) {
            this.expressionCacheSize = cacheSize;
            return this;
        }

        public Builder resetExpressionCalculator(ExpressionCalculator calculator) {
            this.expressionCalculator = calculator;
            return this;
        }

        public DefaultTemplateWordFiller build() {
            return new DefaultTemplateWordFiller(this);
        }
    }
}

