/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.core.filler;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.lzy.template.word.common.TagParser;
import pers.lzy.template.word.core.DocumentParagraphFiller;
import pers.lzy.template.word.core.ExpressionCalculator;
import pers.lzy.template.word.core.handler.OperateParagraphHandler;

public class DefaultDocumentParagraphFiller
implements DocumentParagraphFiller {
    private final ExpressionCalculator expressionCalculator;
    private static final Logger log = LoggerFactory.getLogger(DefaultDocumentParagraphFiller.class);
    private final Map<String, OperateParagraphHandler> operateParagraphHandlerTagMap;
    private static volatile DefaultDocumentParagraphFiller INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultDocumentParagraphFiller getInstance(Map<String, OperateParagraphHandler> operateParagraphHandlerTagMap, ExpressionCalculator expressionCalculator) {
        if (INSTANCE != null) return INSTANCE;
        Class<DefaultDocumentParagraphFiller> clazz = DefaultDocumentParagraphFiller.class;
        synchronized (DefaultDocumentParagraphFiller.class) {
            if (INSTANCE != null) return INSTANCE;
            log.info("init DefaultDocumentParagraphFiller");
            INSTANCE = new DefaultDocumentParagraphFiller(operateParagraphHandlerTagMap, expressionCalculator);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private DefaultDocumentParagraphFiller(Map<String, OperateParagraphHandler> operateParagraphHandlerTagMap, ExpressionCalculator expressionCalculator) {
        this.operateParagraphHandlerTagMap = operateParagraphHandlerTagMap;
        this.expressionCalculator = expressionCalculator;
    }

    @Override
    public void doProcessParagraph(XWPFDocument document, XWPFParagraph paragraph, Map<String, Object> paramData) {
        if (paragraph == null) {
            return;
        }
        String paragraphText = paragraph.getText();
        if (StringUtils.isNotEmpty((CharSequence)paragraphText)) {
            String tagName = TagParser.findContentTag(paragraphText);
            if (tagName == null) {
                return;
            }
            OperateParagraphHandler operateParagraphHandler = this.operateParagraphHandlerTagMap.get(tagName);
            if (operateParagraphHandler == null) {
                log.warn("No tag({}) handler found, skipped", (Object)tagName);
                return;
            }
            TagParser.removeTagName(paragraph, tagName);
            TagParser.formatExpressionInMultiRuns(paragraph);
            operateParagraphHandler.operate(document, paragraph, paramData, this.expressionCalculator);
        }
    }
}

