/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.core;

import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import pers.lzy.template.word.anno.TagOperateHandler;
import pers.lzy.template.word.common.TagParser;
import pers.lzy.template.word.core.ExpressionCalculator;
import pers.lzy.template.word.core.handler.OperateParagraphHandler;
import pers.lzy.template.word.exception.OperateWordHandlerInitException;

public abstract class AbstractOperateParagraphHandler
implements OperateParagraphHandler {
    protected final String tagName;

    public AbstractOperateParagraphHandler() {
        TagOperateHandler operateHandler = this.getClass().getAnnotation(TagOperateHandler.class);
        if (operateHandler == null) {
            throw new OperateWordHandlerInitException("The OperateParagraphHandler must identify the CellOperateHandler annotation");
        }
        this.tagName = operateHandler.tagName();
    }

    @Override
    public void operate(XWPFDocument document, XWPFParagraph paragraph, Map<String, Object> params, ExpressionCalculator expressionCalculator) {
        List runs = paragraph.getRuns();
        if (runs == null) {
            return;
        }
        for (XWPFRun run : runs) {
            String expression = run.text();
            if (!TagParser.verifyHasExpression(expression)) continue;
            this.doOperate(document, run, params, expression, expressionCalculator);
        }
    }

    protected abstract void doOperate(XWPFDocument var1, XWPFRun var2, Map<String, Object> var3, String var4, ExpressionCalculator var5);
}

