/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.common;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.lzy.template.word.utils.ReUtils;
import pers.lzy.template.word.utils.WordUtil;

public class TagParser {
    private static final Logger log = LoggerFactory.getLogger(TagParser.class);
    private static final Pattern TAG_PATTERN = Pattern.compile("(<|[</])([\\d\\w\\s-_]+?)>");
    private static final Pattern TAG_PATTERN_2 = Pattern.compile("^\\s*<(.+?)>:");
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{\\s*?(.+?)\\s*}");
    private static final int START_PHASE_FLAG = 0;
    private static final int FIND_PHASE_FLAG = 1;

    private static String restoreTag(String tagName) {
        return "<" + tagName + ">:";
    }

    public static boolean verifyHasExpression(String content) {
        if (content == null) {
            return false;
        }
        Matcher matcher = EXPRESSION_PATTERN.matcher(content);
        return matcher.find();
    }

    public static String findFirstTag(String content) {
        List<String> tagList = ReUtils.findAll(TAG_PATTERN, (CharSequence)content, 2);
        if (tagList.size() == 0) {
            return null;
        }
        return tagList.get(0);
    }

    public static String parseRunTagContent(XWPFRun run, String tagName) {
        if (run == null) {
            return null;
        }
        String value = run.text();
        String parsedValue = TagParser.parseParamByTag(value, tagName);
        if (StringUtils.isEmpty((CharSequence)parsedValue)) {
            return null;
        }
        return parsedValue;
    }

    public static String parseParamByTag(String content, String tagName) {
        String regStr = String.format("<%s>(.+)</%s>", tagName, tagName);
        return ReUtils.get(regStr, (CharSequence)content, 1);
    }

    public static String findContentTag(String content) {
        String tagName = ReUtils.get(TAG_PATTERN_2, (CharSequence)content, 1);
        if (StringUtils.isBlank((CharSequence)tagName)) {
            return null;
        }
        return tagName;
    }

    public static void formatExpressionInMultiRuns(XWPFParagraph paragraph) {
        List runs = paragraph.getRuns();
        if (runs == null) {
            return;
        }
        boolean phase = false;
        int preChar = 45;
        int startCharRunIndex = 0;
        int endExpressionRunIndex = 0;
        StringBuilder expressionCache = new StringBuilder();
        for (int curRunIndex = 0; curRunIndex < runs.size(); ++curRunIndex) {
            XWPFRun outerCurRun = (XWPFRun)runs.get(curRunIndex);
            String outerCurRunText = outerCurRun.text();
            if (outerCurRunText == null) continue;
            for (int outerCurIndex = 0; outerCurIndex < outerCurRunText.length(); ++outerCurIndex) {
                char outCurrentChar = outerCurRunText.charAt(outerCurIndex);
                if (outCurrentChar == '$') {
                    startCharRunIndex = curRunIndex;
                }
                if (outCurrentChar == '{' && preChar == 36) {
                    expressionCache = new StringBuilder();
                    if (startCharRunIndex != curRunIndex) {
                        expressionCache.append(((XWPFRun)runs.get(startCharRunIndex)).text());
                    }
                    for (int forwardIndex = 0; forwardIndex <= outerCurIndex; ++forwardIndex) {
                        expressionCache.append(outerCurRunText.charAt(forwardIndex));
                    }
                    phase = true;
                    continue;
                }
                if (phase) {
                    expressionCache.append(outCurrentChar);
                    if (outCurrentChar == '}') {
                        endExpressionRunIndex = curRunIndex;
                        phase = false;
                        WordUtil.setRunValue((XWPFRun)runs.get(startCharRunIndex), expressionCache.toString());
                        int removeStartIndex = startCharRunIndex;
                        if (outerCurIndex != outerCurRunText.length() - 1) {
                            WordUtil.insertRunAndCopyStyle(paragraph, outerCurIndex, startCharRunIndex + 1, outerCurRunText.substring(outerCurIndex + 1));
                            ++removeStartIndex;
                        }
                        for (int removeIndex = endExpressionRunIndex; removeIndex > removeStartIndex; --removeIndex) {
                            log.debug("\u79fb\u9664run\u4e0b\u6807\uff1a{}", (Object)removeIndex);
                            paragraph.removeRun(removeIndex);
                        }
                        curRunIndex = removeStartIndex;
                    }
                }
                preChar = outCurrentChar;
            }
        }
    }

    public static void removeTagName(XWPFParagraph paragraph, String tagName) {
        String tagFlag = TagParser.restoreTag(tagName);
        int tagFlagLength = tagFlag.length();
        boolean breakFlag = false;
        boolean startFlag = false;
        List runs = paragraph.getRuns();
        if (runs == null) {
            return;
        }
        for (XWPFRun run : runs) {
            StringBuilder sb = new StringBuilder();
            String runText = run.text();
            if (runText != null) {
                for (int i = 0; i < runText.length(); ++i) {
                    char curChar = runText.charAt(i);
                    if ((Character.isSpaceChar(curChar) || Character.isWhitespace(curChar)) && !startFlag) {
                        sb.append(curChar);
                        continue;
                    }
                    startFlag = true;
                    if (tagFlagLength <= 0) {
                        sb.append(curChar);
                        breakFlag = true;
                    }
                    if (tagFlagLength < 0) continue;
                    --tagFlagLength;
                }
                if (tagFlagLength == 0) {
                    breakFlag = true;
                }
                run.setText(sb.toString(), 0);
            }
            if (!breakFlag) continue;
            break;
        }
    }

    public static void removeTagName(List<XWPFParagraph> paragraphs, String tagName) {
        String tagFlag = TagParser.restoreTag(tagName);
        int tagFlagLength = tagFlag.length();
        boolean breakFlag = false;
        boolean startFlag = false;
        for (XWPFParagraph paragraph : paragraphs) {
            List runs = paragraph.getRuns();
            if (runs == null) {
                return;
            }
            for (XWPFRun run : runs) {
                StringBuilder sb = new StringBuilder();
                String runText = run.text();
                if (runText != null) {
                    for (int i = 0; i < runText.length(); ++i) {
                        char curChar = runText.charAt(i);
                        if ((Character.isSpaceChar(curChar) || Character.isWhitespace(curChar)) && !startFlag) {
                            sb.append(curChar);
                            continue;
                        }
                        startFlag = true;
                        if (tagFlagLength <= 0) {
                            sb.append(curChar);
                            breakFlag = true;
                        }
                        if (tagFlagLength < 0) continue;
                        --tagFlagLength;
                    }
                    if (tagFlagLength == 0) {
                        breakFlag = true;
                    }
                    run.setText(sb.toString(), 0);
                }
                if (!breakFlag) continue;
                break;
            }
            if (!breakFlag) continue;
            break;
        }
    }
}

