/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.common;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;

public class SimpleCache<K, V>
implements Iterable<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> cache;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SimpleCache() {
        this(new WeakHashMap());
    }

    public SimpleCache(Map<K, V> initMap) {
        this.cache = initMap;
    }

    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v = this.cache.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Func0<V> supplier) {
        V v;
        block6: {
            v = this.get(key);
            if (null == v && null != supplier) {
                this.lock.writeLock().lock();
                try {
                    v = this.cache.get(key);
                    if (null != v) break block6;
                    try {
                        v = supplier.call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.cache.put(key, v);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return v;
    }

    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.cache.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return value;
    }

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v = this.cache.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.cache.entrySet().iterator();
    }

    @FunctionalInterface
    public static interface Func0<R> {
        public R call() throws Exception;

        default public R callWithRuntimeException() {
            try {
                return this.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

