/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.common;

import java.util.regex.Pattern;
import pers.lzy.template.word.common.SimpleCache;

public class PatternPool {
    public static final String RE_PLACEHOLDER = "\\$\\{(.+?)\\}";
    public static final String RE_ARRAY_VARIABLE_CHAIN = "([a-zA-Z]\\w+\\.)*[a-zA-Z]\\w+\\[\\]";
    public static final String RE_CHINESE = "[\u4e00-\u9fff]";
    public static final String RE_CHINESES = "[\u4e00-\u9fff]+";
    public static final Pattern GENERAL = Pattern.compile("^\\w+$");
    public static final Pattern NUMBERS = Pattern.compile("\\d+");
    public static final Pattern WORD = Pattern.compile("[a-zA-Z]+");
    public static final Pattern CHINESE = Pattern.compile("[\u4e00-\u9fff]");
    public static final Pattern CHINESES = Pattern.compile("[\u4e00-\u9fff]+");
    public static final Pattern GROUP_VAR = Pattern.compile("\\$(\\d+)");
    private static final SimpleCache<RegexWithFlag, Pattern> POOL = new SimpleCache();

    public static Pattern get(String regex) {
        return PatternPool.get(regex, 0);
    }

    public static Pattern get(String regex, int flags) {
        RegexWithFlag regexWithFlag = new RegexWithFlag(regex, flags);
        Pattern pattern = POOL.get(regexWithFlag);
        if (null == pattern) {
            pattern = Pattern.compile(regex, flags);
            POOL.put(regexWithFlag, pattern);
        }
        return pattern;
    }

    public static Pattern remove(String regex, int flags) {
        return POOL.remove(new RegexWithFlag(regex, flags));
    }

    public static void clear() {
        POOL.clear();
    }

    private static class RegexWithFlag {
        private final String regex;
        private final int flag;

        public RegexWithFlag(String regex, int flag) {
            this.regex = regex;
            this.flag = flag;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.flag;
            result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegexWithFlag other = (RegexWithFlag)obj;
            if (this.flag != other.flag) {
                return false;
            }
            if (this.regex == null) {
                return other.regex == null;
            }
            return this.regex.equals(other.regex);
        }
    }
}

