/*
 * Decompiled with CFR 0.152.
 */
package pers.lzy.template.word.calculator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.lzy.template.word.core.ExpressionCalculator;
import pers.lzy.template.word.exception.CalculateException;
import pers.lzy.template.word.utils.ReUtils;

public class Jxel3ExpressionCalculator
implements ExpressionCalculator {
    private static final Logger logger = LoggerFactory.getLogger(Jxel3ExpressionCalculator.class);
    private final JxltEngine jxltEngine;
    private final LoadingCache<String, JxltEngine.Expression> READ_WRITE_CACHE_MAP;

    public Jxel3ExpressionCalculator(JxltEngine jxltEngine, int expressionCacheSize) {
        this.jxltEngine = jxltEngine;
        int guavaCacheSize = expressionCacheSize >= 100 ? expressionCacheSize : 1000;
        this.READ_WRITE_CACHE_MAP = CacheBuilder.newBuilder().maximumSize((long)guavaCacheSize).build((CacheLoader)new CacheLoader<String, JxltEngine.Expression>(){

            public JxltEngine.Expression load(@Nonnull String expressionStr) {
                return Jxel3ExpressionCalculator.this.jxltEngine.createExpression(expressionStr);
            }
        });
    }

    public JxltEngine.Expression getJxltEngineExpression(String expressionStr) throws ExecutionException {
        return (JxltEngine.Expression)this.READ_WRITE_CACHE_MAP.get((Object)expressionStr);
    }

    @Override
    public String calculate(String expressionStr, Map<String, Object> calculateParam) {
        String result = "";
        try {
            JxltEngine.Expression expression = (JxltEngine.Expression)this.READ_WRITE_CACHE_MAP.get((Object)expressionStr);
            Object evaluateRes = expression.evaluate((JexlContext)new MapContext(calculateParam));
            if (evaluateRes != null) {
                result = evaluateRes.toString();
            }
        }
        catch (ExecutionException e) {
            logger.error("Description Failed to get an expression from cache:", (Throwable)e);
            throw new CalculateException("Description Failed to get an expression from cache");
        }
        return result;
    }

    @Override
    public Object calculateNoFormat(String expressionStr, Map<String, Object> calculateParam) {
        Object evaluateRes;
        try {
            JxltEngine.Expression expression = (JxltEngine.Expression)this.READ_WRITE_CACHE_MAP.get((Object)expressionStr);
            evaluateRes = expression.evaluate((JexlContext)new MapContext(calculateParam));
        }
        catch (ExecutionException e) {
            logger.error("Description Failed to get an expression from cache:", (Throwable)e);
            throw new CalculateException("Description Failed to get an expression from cache");
        }
        return evaluateRes;
    }

    @Override
    public Collection<?> parseObjArrInParamMap(String expressionStr, Map<String, Object> calculateParam) {
        Set<String> objExprSet = this.getObjExpr(expressionStr);
        if (CollectionUtils.isEmpty(objExprSet)) {
            logger.warn("Array expression not found...eg : school.people[]");
            return new ArrayList();
        }
        int minSize = Integer.MAX_VALUE;
        Collection minSizeCollection = new ArrayList();
        for (String objExpr : objExprSet) {
            Object property = this.jxltEngine.getEngine().getProperty(calculateParam, objExpr);
            if (!(property instanceof Collection)) {
                logger.warn("Expression maps are not subclasses of Collection");
                continue;
            }
            int currentSize = ((Collection)property).size();
            if (currentSize >= minSize) continue;
            minSizeCollection = (Collection)property;
            minSize = currentSize;
        }
        return minSizeCollection;
    }

    private Set<String> getObjExpr(String expressionStr) {
        HashSet<String> objExprSet = new HashSet<String>();
        List<String> foundAllPath = ReUtils.findAll("\\$\\{(.+?)\\}", (CharSequence)expressionStr, 1);
        for (String allPath : foundAllPath) {
            List<String> allMatch = ReUtils.findAll("([a-zA-Z]\\w+\\.)*[a-zA-Z]\\w+\\[\\]", (CharSequence)allPath, 0);
            allMatch.forEach(ele -> objExprSet.add(ele.replaceAll("\\[]", "")));
        }
        return objExprSet;
    }
}

