/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apisix.plugin.runner.filter;

import java.util.List;
import org.apache.apisix.plugin.runner.HttpRequest;
import org.apache.apisix.plugin.runner.HttpResponse;
import org.apache.apisix.plugin.runner.filter.PluginFilter;

public class PluginFilterChain {
    private final int index;
    private final List<PluginFilter> filters;

    public int getIndex() {
        return this.index;
    }

    public PluginFilterChain(List<PluginFilter> filters) {
        this.filters = filters;
        this.index = 0;
    }

    public PluginFilterChain(PluginFilterChain parent, int index) {
        this.filters = parent.getFilters();
        this.index = index;
    }

    public List<PluginFilter> getFilters() {
        return this.filters;
    }

    public void filter(HttpRequest request, HttpResponse response) {
        if (this.index < this.filters.size()) {
            PluginFilter filter = this.filters.get(this.index);
            PluginFilterChain next = new PluginFilterChain(this, this.index + 1);
            filter.filter(request, response, next);
        }
    }
}

