/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apisix.plugin.runner;

import com.google.flatbuffers.FlatBufferBuilder;
import io.github.api7.A6.HTTPReqCall.Resp;
import io.github.api7.A6.HTTPReqCall.Rewrite;
import io.github.api7.A6.HTTPReqCall.Stop;
import io.github.api7.A6.TextEntry;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.apisix.plugin.runner.A6Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class HttpResponse
implements A6Response {
    private final Logger logger = LoggerFactory.getLogger(HttpResponse.class);
    private final long requestId;
    private A6Response.ActionType actionType;
    private Map<String, String> reqHeaders;
    private Map<String, String> respHeaders;
    private Map<String, String> args;
    private String path;
    private String body;
    private Integer statusCode;

    public HttpResponse(long requestId) {
        this.requestId = requestId;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public void setReqHeader(String headerKey, String headerValue) {
        if (headerKey == null) {
            this.logger.warn("headerKey is null, ignore it");
            return;
        }
        this.actionType = A6Response.ActionType.Rewrite;
        if (Objects.isNull(this.reqHeaders)) {
            this.reqHeaders = new HashMap<String, String>();
        }
        this.reqHeaders.put(headerKey, headerValue);
    }

    public void setArg(String argKey, String argValue) {
        if (argKey == null) {
            this.logger.warn("argKey is null, ignore it");
            return;
        }
        this.actionType = A6Response.ActionType.Rewrite;
        if (Objects.isNull(this.args)) {
            this.args = new HashMap<String, String>();
        }
        this.args.put(argKey, argValue);
    }

    public void setPath(String path) {
        this.actionType = A6Response.ActionType.Rewrite;
        this.path = path;
    }

    public void setHeader(String headerKey, String headerValue) {
        if (headerKey == null) {
            this.logger.warn("headerKey is null, ignore it");
            return;
        }
        this.actionType = A6Response.ActionType.Stop;
        if (Objects.isNull(this.respHeaders)) {
            this.respHeaders = new HashMap<String, String>();
        }
        this.respHeaders.put(headerKey, headerValue);
    }

    public void setBody(String body) {
        this.actionType = A6Response.ActionType.Stop;
        this.body = body;
    }

    public void setStatusCode(int statusCode) {
        this.actionType = A6Response.ActionType.Stop;
        this.statusCode = statusCode;
    }

    @Override
    public ByteBuffer encode() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        if (Objects.isNull((Object)this.actionType)) {
            this.actionType = A6Response.ActionType.NONE;
        }
        int action = 0;
        if (this.actionType == A6Response.ActionType.Rewrite) {
            action = this.buildRewriteResp(builder);
        } else if (this.actionType == A6Response.ActionType.Stop) {
            action = this.buildStopResp(builder);
        }
        Resp.startResp((FlatBufferBuilder)builder);
        Resp.addAction((FlatBufferBuilder)builder, (int)action);
        Resp.addActionType((FlatBufferBuilder)builder, (byte)this.actionType.getType());
        Resp.addId((FlatBufferBuilder)builder, (long)this.getRequestId());
        builder.finish(Resp.endResp((FlatBufferBuilder)builder));
        return builder.dataBuffer();
    }

    private int buildStopResp(FlatBufferBuilder builder) {
        int headerIndex = -1;
        if (!CollectionUtils.isEmpty(this.respHeaders)) {
            int[] headerTexts = new int[this.respHeaders.size()];
            int i = -1;
            for (Map.Entry<String, String> header : this.respHeaders.entrySet()) {
                int key = builder.createString((CharSequence)header.getKey());
                int value = 0;
                if (!Objects.isNull(header.getValue())) {
                    value = builder.createString((CharSequence)header.getValue());
                }
                int text = TextEntry.createTextEntry((FlatBufferBuilder)builder, (int)key, (int)value);
                headerTexts[++i] = text;
            }
            headerIndex = Stop.createHeadersVector((FlatBufferBuilder)builder, (int[])headerTexts);
        }
        int bodyIndex = -1;
        if (StringUtils.hasText((String)this.body)) {
            byte[] bodyBytes = this.body.getBytes(StandardCharsets.UTF_8);
            bodyIndex = Stop.createBodyVector((FlatBufferBuilder)builder, (byte[])bodyBytes);
        }
        Stop.startStop((FlatBufferBuilder)builder);
        if (!Objects.isNull(this.statusCode)) {
            Stop.addStatus((FlatBufferBuilder)builder, (int)this.statusCode);
        } else {
            Stop.addStatus((FlatBufferBuilder)builder, (int)200);
            this.logger.info("Use 200 as the default HTTP Status Code when setStatusCode is not called");
        }
        if (-1 != headerIndex) {
            Stop.addHeaders((FlatBufferBuilder)builder, (int)headerIndex);
        }
        if (-1 != bodyIndex) {
            Stop.addBody((FlatBufferBuilder)builder, (int)bodyIndex);
        }
        return Stop.endStop((FlatBufferBuilder)builder);
    }

    private int buildRewriteResp(FlatBufferBuilder builder) {
        int pathIndex = -1;
        if (!Objects.isNull(this.path)) {
            pathIndex = builder.createString((CharSequence)this.path);
        }
        int headerIndex = -1;
        if (!CollectionUtils.isEmpty(this.reqHeaders)) {
            int[] headerTexts = new int[this.reqHeaders.size()];
            int i = -1;
            for (Map.Entry<String, String> header : this.reqHeaders.entrySet()) {
                int key = builder.createString((CharSequence)header.getKey());
                int value = 0;
                if (!Objects.isNull(header.getValue())) {
                    value = builder.createString((CharSequence)header.getValue());
                }
                int text = TextEntry.createTextEntry((FlatBufferBuilder)builder, (int)key, (int)value);
                headerTexts[++i] = text;
            }
            headerIndex = Rewrite.createHeadersVector((FlatBufferBuilder)builder, (int[])headerTexts);
        }
        int argsIndex = -1;
        if (!CollectionUtils.isEmpty(this.args)) {
            int[] argTexts = new int[this.args.size()];
            int i = -1;
            for (Map.Entry<String, String> arg : this.args.entrySet()) {
                int key = builder.createString((CharSequence)arg.getKey());
                int value = 0;
                if (!Objects.isNull(arg.getValue())) {
                    value = builder.createString((CharSequence)arg.getValue());
                }
                int text = TextEntry.createTextEntry((FlatBufferBuilder)builder, (int)key, (int)value);
                argTexts[++i] = text;
            }
            argsIndex = Rewrite.createArgsVector((FlatBufferBuilder)builder, (int[])argTexts);
        }
        Rewrite.startRewrite((FlatBufferBuilder)builder);
        if (-1 != pathIndex) {
            Rewrite.addPath((FlatBufferBuilder)builder, (int)pathIndex);
        }
        if (-1 != headerIndex) {
            Rewrite.addHeaders((FlatBufferBuilder)builder, (int)headerIndex);
        }
        if (-1 != argsIndex) {
            Rewrite.addArgs((FlatBufferBuilder)builder, (int)argsIndex);
        }
        return Rewrite.endRewrite((FlatBufferBuilder)builder);
    }

    @Override
    public byte getType() {
        return 2;
    }
}

