/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apisix.plugin.runner;

import io.github.api7.A6.HTTPReqCall.Req;
import io.github.api7.A6.TextEntry;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.apisix.plugin.runner.A6Request;
import org.apache.apisix.plugin.runner.HttpResponse;
import org.apache.apisix.plugin.runner.filter.PluginFilter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class HttpRequest
implements A6Request {
    private final Req req;
    private HttpResponse response;
    private Map<String, String> config;
    private Long requestId;
    private String sourceIP;
    private Method method;
    private String path;
    private Map<String, String> headers;
    private Map<String, String> args;
    private Map<String, String> vars;
    private String body;

    public HttpRequest(Req req) {
        this.req = req;
    }

    public String getConfig(PluginFilter filter) {
        return this.config.getOrDefault(filter.name(), null);
    }

    public long getRequestId() {
        if (Objects.isNull(this.requestId)) {
            this.requestId = this.req.id();
        }
        return this.requestId;
    }

    public String getSourceIP() {
        if (Objects.isNull(this.sourceIP)) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.req.srcIpLength(); ++i) {
                builder.append(this.req.srcIp(i)).append('.');
            }
            if (StringUtils.hasText((String)builder.toString())) {
                this.sourceIP = builder.substring(0, builder.length() - 1);
            }
        }
        return this.sourceIP;
    }

    public Method getMethod() {
        if (Objects.isNull((Object)this.method)) {
            this.method = Method.values()[this.req.method()];
        }
        return this.method;
    }

    public String getPath() {
        if (Objects.isNull(this.path)) {
            this.path = this.req.path();
        }
        return this.path;
    }

    public void setPath(String path) {
        this.response.setPath(path);
    }

    public Map<String, String> getHeaders() {
        if (Objects.isNull(this.headers)) {
            this.headers = new HashMap<String, String>();
            for (int i = 0; i < this.req.headersLength(); ++i) {
                TextEntry header = this.req.headers(i);
                this.headers.put(header.name(), header.value());
            }
        }
        return this.headers;
    }

    public String getHeader(String headerName) {
        Map<String, String> headers = this.getHeaders();
        if (!CollectionUtils.isEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                if (!header.getKey().equals(headerName)) continue;
                return header.getValue();
            }
        }
        return null;
    }

    public void setHeader(String headerKey, String headerValue) {
        this.response.setReqHeader(headerKey, headerValue);
    }

    public Map<String, String> getArgs() {
        if (Objects.isNull(this.args)) {
            this.args = new HashMap<String, String>();
            for (int i = 0; i < this.req.argsLength(); ++i) {
                TextEntry arg = this.req.args(i);
                this.args.put(arg.name(), arg.value());
            }
        }
        return this.args;
    }

    public String getArg(String argName) {
        Map<String, String> args = this.getArgs();
        if (!CollectionUtils.isEmpty(args)) {
            for (Map.Entry<String, String> arg : args.entrySet()) {
                if (!arg.getKey().equals(argName)) continue;
                return arg.getValue();
            }
        }
        return null;
    }

    public void setArg(String argKey, String argValue) {
        this.response.setArg(argKey, argValue);
    }

    public long getConfToken() {
        return this.req.confToken();
    }

    public static HttpRequest from(ByteBuffer buffer) {
        Req req = Req.getRootAsReq((ByteBuffer)buffer);
        return new HttpRequest(req);
    }

    public void initCtx(HttpResponse response, Map<String, String> config) {
        this.response = response;
        this.config = config;
    }

    @Override
    public byte getType() {
        return 2;
    }

    public String getVars(String key) {
        if (CollectionUtils.isEmpty(this.vars)) {
            return null;
        }
        return this.vars.get(key);
    }

    public void setVars(Map<String, String> vars) {
        this.vars = vars;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public static enum Method {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        MKCOL,
        COPY,
        MOVE,
        OPTIONS,
        PROPFIND,
        PROPPATCH,
        LOCK,
        UNLOCK,
        PATCH,
        TRACE;

    }
}

