/*
 * Decompiled with CFR 0.152.
 */
package io.github.effiban.scala2java.test.utils.integration.matchers;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class FileMismatchMessageGenerator$ {
    public static final FileMismatchMessageGenerator$ MODULE$ = new FileMismatchMessageGenerator$();

    public final String Divider() {
        return " |";
    }

    public final String Highlight() {
        return "~";
    }

    public final String Missing() {
        return "<MISSING>";
    }

    public final String Expected() {
        return "EXPECTED";
    }

    public final String Actual() {
        return "ACTUAL";
    }

    public Option<String> generate(Path expectedPath, Path actualPath) {
        Seq expectedLines = CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(expectedPath)).asScala().toSeq();
        Seq actualLines = CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(actualPath)).asScala().toSeq();
        return this.findMismatchingLineNum((Seq<String>)expectedLines, (Seq<String>)actualLines).map((Function1 & Serializable)mismatchingLineNum -> FileMismatchMessageGenerator$.MODULE$.generate((Seq<String>)expectedLines, (Seq<String>)actualLines, BoxesRunTime.unboxToInt((Object)mismatchingLineNum)));
    }

    private String generate(Seq<String> expectedLines, Seq<String> actualLines, int mismatchingLineNum) {
        int maxNumLines = package$.MODULE$.max(actualLines.size(), expectedLines.size());
        int maxLineNumDigits = this.numDigitsOf(maxNumLines);
        int maxExpectedLineLength = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)expectedLines.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.length()))).max((Ordering)Ordering.Int$.MODULE$));
        int maxActualLineLength = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)actualLines.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.length()))).max((Ordering)Ordering.Int$.MODULE$));
        int maxRowLength = maxLineNumDigits + maxExpectedLineLength + maxActualLineLength + 2 * " |".length();
        StringBuilder diffBuilder = new StringBuilder(500);
        diffBuilder.$plus$plus$eq("\n");
        diffBuilder.$plus$plus$eq("Actual file did not match expected file at line " + (mismatchingLineNum + 1) + ":\n");
        diffBuilder.$plus$plus$eq("\n");
        diffBuilder.$plus$plus$eq(this.generateHeader(maxLineNumDigits, maxExpectedLineLength));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maxNumLines).foreach((Function1 & Serializable)lineNum -> FileMismatchMessageGenerator$.$anonfun$generate$4(mismatchingLineNum, diffBuilder, maxRowLength, maxLineNumDigits, expectedLines, maxExpectedLineLength, actualLines, BoxesRunTime.unboxToInt((Object)lineNum)));
        Object object = mismatchingLineNum == maxNumLines - 1 ? diffBuilder.$plus$plus$eq(this.generateHighlightedRow(maxRowLength)) : BoxedUnit.UNIT;
        return diffBuilder.toString();
    }

    private String generateHeader(int maxLineNumDigits, int maxExpectedLineLength) {
        return StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxLineNumDigits) + " |EXPECTED" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxExpectedLineLength - "EXPECTED".length()) + " |ACTUAL\n";
    }

    private String generateHighlightedRow(int maxRowLength) {
        return StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("~"), maxRowLength) + "\n";
    }

    private String generateLineNumber(int lineNum, int maxLineNumDigits) {
        return StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxLineNumDigits - this.numDigitsOf(lineNum + 1)) + (lineNum + 1);
    }

    private String generateExpectedLinePart(Seq<String> expectedLines, int lineNum, int maxExpectedLineLength) {
        if (lineNum < expectedLines.size()) {
            return (String)expectedLines.apply(lineNum) + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxExpectedLineLength - ((String)expectedLines.apply(lineNum)).length());
        }
        return "<MISSING>" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxExpectedLineLength - "<MISSING>".length());
    }

    private String generateActualLinePart(Seq<String> actualLines, int lineNum) {
        if (lineNum < actualLines.size()) {
            return (String)actualLines.apply(lineNum);
        }
        return "<MISSING>";
    }

    private Option<Object> findMismatchingLineNum(Seq<String> expectedLines, Seq<String> actualLines) {
        int minNumLines = package$.MODULE$.min(expectedLines.size(), actualLines.size());
        Option maybeMismatchingLineNum = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), minNumLines).find((Function1)(JFunction1.mcZI.sp & Serializable)lineNum -> {
            String string = ((String)expectedLines.apply(lineNum)).trim();
            String string2 = ((String)actualLines.apply(lineNum)).trim();
            return string == null ? string2 != null : !string.equals(string2);
        });
        Option option = maybeMismatchingLineNum;
        if (option instanceof Some) {
            Some some = (Some)option;
            int mismatchingLineNum = BoxesRunTime.unboxToInt((Object)some.value());
            return new Some((Object)BoxesRunTime.boxToInteger((int)mismatchingLineNum));
        }
        if (None$.MODULE$.equals(option) && expectedLines.size() != actualLines.size()) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)minNumLines));
        }
        return None$.MODULE$;
    }

    private int numDigitsOf(int num) {
        return (int)package$.MODULE$.floor(package$.MODULE$.log10((double)num)) + 1;
    }

    public static final /* synthetic */ StringBuilder $anonfun$generate$4(int mismatchingLineNum$1, StringBuilder diffBuilder$1, int maxRowLength$1, int maxLineNumDigits$1, Seq expectedLines$2, int maxExpectedLineLength$1, Seq actualLines$2, int lineNum) {
        Object object = mismatchingLineNum$1 == lineNum - 1 || mismatchingLineNum$1 == lineNum ? diffBuilder$1.$plus$plus$eq(MODULE$.generateHighlightedRow(maxRowLength$1)) : BoxedUnit.UNIT;
        diffBuilder$1.$plus$plus$eq(MODULE$.generateLineNumber(lineNum, maxLineNumDigits$1));
        diffBuilder$1.$plus$plus$eq(" |");
        diffBuilder$1.$plus$plus$eq(MODULE$.generateExpectedLinePart((Seq<String>)expectedLines$2, lineNum, maxExpectedLineLength$1));
        diffBuilder$1.$plus$plus$eq(" |");
        diffBuilder$1.$plus$plus$eq(MODULE$.generateActualLinePart((Seq<String>)actualLines$2, lineNum));
        return diffBuilder$1.$plus$plus$eq("\n");
    }

    private FileMismatchMessageGenerator$() {
    }
}

