/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.utils;

import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Manifest;

public final class JarUtils {
    private JarUtils() {
    }

    @CoberturaIgnore
    public static String readManifestImplementationVersion() {
        URLClassLoader classLoader = (URLClassLoader)JarUtils.class.getClassLoader();
        try {
            URL url = classLoader.findResource("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(url.openStream());
            return manifest.getMainAttributes().getValue("Implementation-Version");
        }
        catch (Exception exception) {
            return "x.x.xx";
        }
    }

    @CoberturaIgnore
    public static String readManifestBuiltDate() {
        URLClassLoader classLoader = (URLClassLoader)JarUtils.class.getClassLoader();
        try {
            URL url = classLoader.findResource("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(url.openStream());
            return manifest.getMainAttributes().getValue("Built-Date");
        }
        catch (Exception exception) {
            return "Thu, 01 Jan 1970 00:00:00 GMT";
        }
    }
}

