/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.stubs;

import io.github.azagniotov.generics.TypeSafeConverter;
import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import io.github.azagniotov.stubby4j.annotations.VisibleForTesting;
import io.github.azagniotov.stubby4j.stubs.AbstractBuilder;
import io.github.azagniotov.stubby4j.stubs.ReflectableStub;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.ConfigurableYAMLProperty;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.http.HttpStatus;

public class StubResponse
implements ReflectableStub {
    public static final String STUBBY_RESOURCE_ID_HEADER = "x-stubby-resource-id";
    private final HttpStatus.Code httpStatusCode;
    private final String body;
    private final File file;
    private final byte[] fileBytes;
    private final String latency;
    private final Map<String, String> headers;

    private StubResponse(HttpStatus.Code httpStatusCode, String body, File file, String latency, Map<String, String> headers) {
        this.httpStatusCode = httpStatusCode;
        this.body = body;
        this.file = file;
        this.fileBytes = ObjectUtils.isNull(file) ? new byte[]{} : this.getFileBytes();
        this.latency = latency;
        this.headers = ObjectUtils.isNull(headers) ? new LinkedHashMap() : headers;
    }

    public static StubResponse okResponse() {
        return new Builder().build();
    }

    public static StubResponse notFoundResponse() {
        return new Builder().withHttpStatusCode(HttpStatus.Code.NOT_FOUND).build();
    }

    public static StubResponse unauthorizedResponse() {
        return new Builder().withHttpStatusCode(HttpStatus.Code.UNAUTHORIZED).build();
    }

    public static StubResponse redirectResponse(Optional<StubResponse> stubResponseOptional) {
        if (!stubResponseOptional.isPresent()) {
            return new Builder().withHttpStatusCode(HttpStatus.Code.MOVED_PERMANENTLY).build();
        }
        StubResponse foundStubResponse = stubResponseOptional.get();
        return new StubResponse(foundStubResponse.getHttpStatusCode(), foundStubResponse.getBody(), foundStubResponse.getRawFile(), foundStubResponse.getLatency(), foundStubResponse.getHeaders());
    }

    public HttpStatus.Code getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getBody() {
        return StringUtils.isSet(this.body) ? this.body : "";
    }

    public boolean isRecordingRequired() {
        String body = this.getBody();
        return StringUtils.toLower(body).startsWith("http");
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getLatency() {
        return this.latency;
    }

    public byte[] getFile() {
        return this.fileBytes;
    }

    public File getRawFile() {
        return this.file;
    }

    public String getRawFileAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public byte[] getResponseBodyAsBytes() {
        if (this.fileBytes.length == 0) {
            return StringUtils.getBytesUtf8(this.getBody());
        }
        return this.fileBytes;
    }

    public boolean isBodyContainsTemplateTokens() {
        boolean isFileTemplate = this.fileBytes.length != 0 && this.isTemplateFile();
        return isFileTemplate || StringUtils.isTokenized(this.getBody());
    }

    public boolean isFilePathContainsTemplateTokens() {
        try {
            return FileUtils.isFilePathContainTemplateTokens(this.file);
        }
        catch (Exception e) {
            return false;
        }
    }

    @CoberturaIgnore
    private boolean isTemplateFile() {
        try {
            return FileUtils.isTemplateFile(this.file);
        }
        catch (Exception e) {
            return false;
        }
    }

    @CoberturaIgnore
    private byte[] getFileBytes() {
        try {
            return FileUtils.fileToBytes(this.file);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public boolean hasHeaderLocation() {
        return this.getHeaders().containsKey("location");
    }

    void addResourceIDHeader(int resourceIndex) {
        this.getHeaders().put(STUBBY_RESOURCE_ID_HEADER, String.valueOf(resourceIndex));
    }

    String getResourceIDHeader() {
        return this.getHeaders().get(STUBBY_RESOURCE_ID_HEADER);
    }

    public static final class Builder
    extends AbstractBuilder<StubResponse> {
        private String status = null;
        private String body = null;
        private File file = null;
        private String latency = null;
        private Map<String, String> headers = new LinkedHashMap<String, String>();

        public Builder emptyWithBody(String body) {
            this.status = String.valueOf(HttpStatus.Code.OK.getCode());
            this.body = body;
            return this;
        }

        public Builder withHttpStatusCode(HttpStatus.Code httpStatusCode) {
            this.status = String.valueOf(httpStatusCode.getCode());
            return this;
        }

        public Builder withBody(String body) {
            this.body = body;
            return this;
        }

        public Builder withFile(File file) {
            this.file = file;
            return this;
        }

        @Override
        public StubResponse build() {
            this.status = this.getStaged(String.class, ConfigurableYAMLProperty.STATUS, this.status);
            this.body = this.getStaged(String.class, ConfigurableYAMLProperty.BODY, this.body);
            this.file = this.getStaged(File.class, ConfigurableYAMLProperty.FILE, this.file);
            this.latency = this.getStaged(String.class, ConfigurableYAMLProperty.LATENCY, this.latency);
            this.headers = TypeSafeConverter.asCheckedLinkedHashMap(this.getStaged(Map.class, ConfigurableYAMLProperty.HEADERS, this.headers), String.class, String.class);
            StubResponse stubResponse = new StubResponse(this.getHttpStatusCode(), this.body, this.file, this.latency, this.headers);
            this.status = null;
            this.body = null;
            this.file = null;
            this.latency = null;
            this.headers = new LinkedHashMap<String, String>();
            this.fieldNameAndValues.clear();
            return stubResponse;
        }

        @VisibleForTesting
        HttpStatus.Code getHttpStatusCode() {
            return ObjectUtils.isNull(this.status) ? HttpStatus.Code.OK : HttpStatus.getCode(Integer.parseInt(this.status));
        }
    }
}

