/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.stubs;

import io.github.azagniotov.stubby4j.annotations.VisibleForTesting;
import io.github.azagniotov.stubby4j.cli.ANSITerminal;
import io.github.azagniotov.stubby4j.stubs.RegexParser;
import io.github.azagniotov.stubby4j.stubs.StubRequest;
import io.github.azagniotov.stubby4j.stubs.StubbableAuthorizationType;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.ConfigurableYAMLProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.xml.sax.SAXException;

class StubMatcher {
    private final Map<String, String> regexGroups;
    private static final Pattern SUB_TYPE_PATTERN = Pattern.compile("/(?:.*\\+)?(\\w*);?");

    StubMatcher(Map<String, String> regexGroups) {
        this.regexGroups = regexGroups;
    }

    boolean matches(StubRequest stubbedRequest, StubRequest assertingRequest) {
        if (!this.urlsMatch(stubbedRequest.getUri(), assertingRequest.getUri())) {
            ANSITerminal.error(String.format("Failed to match on URL [%s] WITH [%s]", stubbedRequest.getUri(), assertingRequest.getUri()));
            return false;
        }
        ANSITerminal.info(String.format("Matched on URL [%s] WITH [%s]", stubbedRequest.getUri(), assertingRequest.getUri()));
        if (!this.listsIntersect(stubbedRequest.getMethod(), assertingRequest.getMethod())) {
            ANSITerminal.error(String.format("Failed to match on METHOD [%s] WITH [%s]", stubbedRequest.getMethod(), assertingRequest.getMethod()));
            return false;
        }
        ANSITerminal.info(String.format("Matched on METHOD [%s] WITH [%s]", stubbedRequest.getMethod(), assertingRequest.getMethod()));
        if (!this.postBodiesMatch(stubbedRequest.isPostStubbed(), stubbedRequest.getPostBody(), assertingRequest)) {
            ANSITerminal.error(String.format("Failed to match on POST BODY [%s] WITH [%s]", stubbedRequest.getPostBody(), assertingRequest.getPostBody()));
            return false;
        }
        ANSITerminal.info(String.format("Matched on POST BODY [%s] WITH [%s]", stubbedRequest.getPostBody(), assertingRequest.getPostBody()));
        if (!this.headersMatch(stubbedRequest.getHeaders(), assertingRequest.getHeaders())) {
            ANSITerminal.error(String.format("Failed to match on HEADERS [%s] WITH [%s]", stubbedRequest.getHeaders(), assertingRequest.getHeaders()));
            return false;
        }
        ANSITerminal.info(String.format("Matched on HEADERS [%s] WITH [%s]", stubbedRequest.getHeaders(), assertingRequest.getHeaders()));
        if (!this.queriesMatch(stubbedRequest.getQuery(), assertingRequest.getQuery())) {
            ANSITerminal.error(String.format("Failed to match on QUERY [%s] WITH [%s]", stubbedRequest.getQuery(), assertingRequest.getQuery()));
            return false;
        }
        ANSITerminal.info(String.format("Matched on QUERY [%s] WITH [%s]", stubbedRequest.getQuery(), assertingRequest.getQuery()));
        return true;
    }

    private boolean urlsMatch(String stubbedUrl, String assertingUrl) {
        return this.stringsMatch(stubbedUrl, assertingUrl, ConfigurableYAMLProperty.URL.toString());
    }

    @VisibleForTesting
    boolean postBodiesMatch(boolean isPostStubbed, String stubbedPostBody, StubRequest assertingRequest) {
        if (isPostStubbed) {
            Matcher matcher;
            String assertingPostBody = assertingRequest.getPostBody();
            if (StringUtils.isNotSet(assertingPostBody)) {
                return false;
            }
            String assertingContentType = assertingRequest.getHeaders().get("content-type");
            if (StringUtils.isSet(assertingContentType) && (matcher = SUB_TYPE_PATTERN.matcher(assertingContentType)).find()) {
                String subType = matcher.group(1);
                if ("json".equals(subType)) {
                    return this.jsonMatch(stubbedPostBody, assertingPostBody);
                }
                if ("xml".equals(subType)) {
                    return this.xmlMatch(stubbedPostBody, assertingPostBody);
                }
            }
            return this.stringsMatch(stubbedPostBody, assertingPostBody, ConfigurableYAMLProperty.POST.toString());
        }
        return true;
    }

    private boolean queriesMatch(Map<String, String> stubbedQuery, Map<String, String> assertingQuery) {
        return this.mapsMatch(stubbedQuery, assertingQuery, ConfigurableYAMLProperty.QUERY.toString());
    }

    private boolean headersMatch(Map<String, String> stubbedHeaders, Map<String, String> assertingHeaders) {
        HashMap<String, String> stubbedHeadersCopy = new HashMap<String, String>(stubbedHeaders);
        for (StubbableAuthorizationType authorizationType : StubbableAuthorizationType.values()) {
            stubbedHeadersCopy.remove(authorizationType.asYAMLProp());
        }
        return this.mapsMatch(stubbedHeadersCopy, assertingHeaders, ConfigurableYAMLProperty.HEADERS.toString());
    }

    @VisibleForTesting
    boolean mapsMatch(Map<String, String> stubbedMappings, Map<String, String> assertingMappings, String mapName) {
        if (stubbedMappings.isEmpty()) {
            return true;
        }
        if (assertingMappings.isEmpty()) {
            return false;
        }
        HashMap<String, String> stubbedMappingsCopy = new HashMap<String, String>(stubbedMappings);
        HashMap<String, String> assertingMappingsCopy = new HashMap<String, String>(assertingMappings);
        for (Map.Entry stubbedMappingEntry : stubbedMappingsCopy.entrySet()) {
            boolean containsRequiredParam = assertingMappingsCopy.containsKey(stubbedMappingEntry.getKey());
            if (!containsRequiredParam) {
                return false;
            }
            String assertingValue = (String)assertingMappingsCopy.get(stubbedMappingEntry.getKey());
            String templateTokenName = String.format("%s.%s", mapName, stubbedMappingEntry.getKey());
            if (this.stringsMatch((String)stubbedMappingEntry.getValue(), assertingValue, templateTokenName)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean stringsMatch(String stubbedValue, String assertingValue, String templateTokenName) {
        if (StringUtils.isNotSet(stubbedValue)) {
            return true;
        }
        if (StringUtils.isNotSet(assertingValue)) {
            return false;
        }
        return this.regexMatch(stubbedValue, assertingValue, templateTokenName) || stubbedValue.equals(assertingValue);
    }

    private boolean regexMatch(String stubbedValue, String assertingValue, String templateTokenName) {
        return RegexParser.INSTANCE.match(stubbedValue, assertingValue, templateTokenName, this.regexGroups);
    }

    @VisibleForTesting
    boolean listsIntersect(List<String> stubbedArray, List<String> assertingArray) {
        if (stubbedArray.isEmpty()) {
            return true;
        }
        if (!assertingArray.isEmpty()) {
            for (String entry : assertingArray) {
                if (!stubbedArray.contains(entry)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean jsonMatch(String stubbedJson, String assertingJson) {
        try {
            boolean passed = JSONCompare.compareJSON(stubbedJson, assertingJson, JSONCompareMode.NON_EXTENSIBLE).passed();
            if (passed) {
                return true;
            }
            String escapedStubbedPostBody = StringUtils.escapeSpecialRegexCharacters(stubbedJson);
            return this.stringsMatch(escapedStubbedPostBody, assertingJson, ConfigurableYAMLProperty.POST.toString());
        }
        catch (JSONException e) {
            String escapedStubbedPostBody = StringUtils.escapeSpecialRegexCharacters(stubbedJson);
            return this.stringsMatch(escapedStubbedPostBody, assertingJson, ConfigurableYAMLProperty.POST.toString());
        }
    }

    private boolean xmlMatch(String stubbedXml, String assertingXml) {
        try {
            Diff diff = new Diff(stubbedXml, assertingXml);
            diff.overrideElementQualifier(new ElementNameAndAttributeQualifier());
            return diff.similar() || diff.identical();
        }
        catch (IOException | SAXException e) {
            return this.stringsMatch(stubbedXml, assertingXml, ConfigurableYAMLProperty.POST.toString());
        }
    }
}

