/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.stubs;

import io.github.azagniotov.stubby4j.handlers.strategy.stubs.StubResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.stubs.StubRequest;
import io.github.azagniotov.stubby4j.stubs.StubResponse;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;

public class RedirectResponseHandlingStrategy
implements StubResponseHandlingStrategy {
    private final StubResponse foundStubResponse;

    RedirectResponseHandlingStrategy(StubResponse foundStubResponse) {
        this.foundStubResponse = foundStubResponse;
    }

    @Override
    public void handle(HttpServletResponse response, StubRequest assertionStubRequest) throws Exception {
        HandlerUtils.setResponseMainHeaders(response);
        if (StringUtils.isSet(this.foundStubResponse.getLatency())) {
            long latency = Long.parseLong(this.foundStubResponse.getLatency());
            TimeUnit.MILLISECONDS.sleep(latency);
        }
        response.setStatus(this.foundStubResponse.getHttpStatusCode().getCode());
        response.setHeader(HttpHeader.LOCATION.asString(), this.foundStubResponse.getHeaders().get("location"));
        response.setHeader(HttpHeader.CONNECTION.asString(), "close");
    }
}

