/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.admin;

import io.github.azagniotov.stubby4j.handlers.strategy.admin.AdminResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.stubs.StubRepository;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.YAMLParser;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;

public class PostHandlingStrategy
implements AdminResponseHandlingStrategy {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, StubRepository stubRepository) throws Exception {
        if (!request.getRequestURI().equals("/")) {
            response.setStatus(405);
            response.getWriter().println("Method POST is not allowed on URI " + request.getRequestURI());
            return;
        }
        String post = HandlerUtils.extractPostRequestBody(request, "admin");
        if (!StringUtils.isSet(post)) {
            String errorMessage = String.format("%s request on URI %s was empty", request.getMethod(), request.getRequestURI());
            HandlerUtils.configureErrorResponse(response, 204, errorMessage);
            return;
        }
        stubRepository.refreshStubsByPost(new YAMLParser(), post);
        if (stubRepository.getStubs().size() == 1) {
            response.addHeader(HttpHeader.LOCATION.asString(), stubRepository.getOnlyStubRequestUrl());
        }
        response.setStatus(201);
        response.getWriter().println("Configuration created successfully");
    }
}

