/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers;

import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonErrorHandler
extends ErrorHandler {
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = request.getMethod();
        if (!(HttpMethod.GET.is(method) || HttpMethod.POST.is(method) || HttpMethod.PUT.is(method) || HttpMethod.HEAD.is(method))) {
            baseRequest.setHandled(true);
            return;
        }
        baseRequest.setHandled(true);
        response.setContentType(MimeTypes.Type.APPLICATION_JSON.asString());
        ByteArrayISO8859Writer byteArrayWriter = new ByteArrayISO8859Writer(4096);
        String reason = response instanceof Response ? ((Response)response).getReason() : null;
        this.handleErrorPage(request, byteArrayWriter, response.getStatus(), reason);
        byteArrayWriter.flush();
        response.setContentLength(byteArrayWriter.size());
        byteArrayWriter.writeTo(response.getOutputStream());
        byteArrayWriter.destroy();
    }

    @Override
    protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        String error;
        String string = error = ObjectUtils.isNull(message) ? HttpStatus.getMessage(code) : message;
        if (code == 404) {
            try {
                JSONObject jsonObject = new JSONObject(error);
                jsonObject.putOpt("code", code);
                writer.write(jsonObject.toString());
            }
            catch (JSONException e) {
                writer.write("{\"code\":\"" + code + "\",\"message\"=\"" + error + "\"}");
            }
        } else {
            writer.write("{\"code\":\"" + code + "\",\"message\"=\"" + error + "\"}");
        }
    }
}

