/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.generics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TypeSafeConverter {
    private TypeSafeConverter() throws InstantiationException {
        throw new InstantiationException();
    }

    public static <T, C extends Collection<T>> C asCheckedCollection(Object collectionObject, Class<T> valueClassType, C collectionImpl) {
        if (collectionObject == null) {
            throw new IllegalArgumentException("Collection object instance is null");
        }
        Collection rawCollection = (Collection)collectionObject;
        for (Object rawCollectionValue : rawCollection) {
            collectionImpl.add(TypeSafeConverter.as(valueClassType, rawCollectionValue));
        }
        return collectionImpl;
    }

    public static <K, V, M extends Map<K, V>> M asCheckedMap(Object mapObject, Class<K> keyClassType, Class<V> valueClassType, M mapImpl) {
        if (mapObject == null) {
            throw new IllegalArgumentException("Map object instance is null");
        }
        Map rawMap = (Map)mapObject;
        for (Map.Entry rawEntry : rawMap.entrySet()) {
            mapImpl.put(TypeSafeConverter.as(keyClassType, rawEntry.getKey()), TypeSafeConverter.as(valueClassType, rawEntry.getValue()));
        }
        return mapImpl;
    }

    public static <T> T as(Class<T> targetClazz, Object instance) {
        TypeSafeConverter.checkCast(targetClazz, instance);
        return targetClazz.cast(instance);
    }

    static <T> void checkCast(Class<T> targetClazz, Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance is null");
        }
        if (!targetClazz.isInstance(instance)) {
            throw new ClassCastException("Expected: " + targetClazz.getCanonicalName() + ", instead got: " + instance.getClass().getCanonicalName() + " for instance: " + instance);
        }
    }

    public static <T> Iterable<T> asCheckedIterable(Object iterableObject, Class<T> valueClassType) {
        return TypeSafeConverter.asCheckedCollection(iterableObject, valueClassType, new ArrayList());
    }

    public static <T> List<T> asCheckedArrayList(Object listObject, Class<T> valueClassType) {
        return TypeSafeConverter.asCheckedCollection(listObject, valueClassType, new ArrayList());
    }

    public static <T> List<T> asCheckedLinkedList(Object listObject, Class<T> valueClassType) {
        return TypeSafeConverter.asCheckedCollection(listObject, valueClassType, new LinkedList());
    }

    public static <T> Set<T> asCheckedHashSet(Object setObject, Class<T> valueClassType) {
        return TypeSafeConverter.asCheckedCollection(setObject, valueClassType, new HashSet());
    }

    public static <T> Set<T> asCheckedLinkedHashSet(Object setObject, Class<T> valueClassType) {
        return TypeSafeConverter.asCheckedCollection(setObject, valueClassType, new LinkedHashSet());
    }

    public static <K, V> Map<K, V> asCheckedHashMap(Object mapObject, Class<K> keyClassType, Class<V> valueClassType) {
        return TypeSafeConverter.asCheckedMap(mapObject, keyClassType, valueClassType, new HashMap());
    }

    public static <K, V> Map<K, V> asCheckedLinkedHashMap(Object mapObject, Class<K> keyClassType, Class<V> valueClassType) {
        return TypeSafeConverter.asCheckedMap(mapObject, keyClassType, valueClassType, new LinkedHashMap());
    }
}

