/*
 * Decompiled with CFR 0.152.
 */
package io.github.acm19.aws.interceptor.http;

import io.github.acm19.aws.interceptor.http.RequestSigner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public final class AwsRequestSigningApacheV5Interceptor
implements HttpRequestInterceptor {
    private final RequestSigner signer;

    public AwsRequestSigningApacheV5Interceptor(String service, Signer signer, AwsCredentialsProvider awsCredentialsProvider, Region region) {
        this.signer = new RequestSigner(service, signer, awsCredentialsProvider, region);
    }

    public void process(HttpRequest request, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
        ClassicHttpRequest httpEntityEnclosingRequest;
        ClassicHttpRequest classicHttpRequest;
        SdkHttpFullRequest.Builder requestBuilder = SdkHttpFullRequest.builder().method(SdkHttpMethod.fromValue((String)request.getMethod())).uri(AwsRequestSigningApacheV5Interceptor.buildUri(request));
        if (request instanceof ClassicHttpRequest && (classicHttpRequest = (ClassicHttpRequest)request).getEntity() != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            classicHttpRequest.getEntity().writeTo((OutputStream)outputStream);
            requestBuilder.contentStreamProvider(() -> new ByteArrayInputStream(outputStream.toByteArray()));
        }
        Map<String, List<String>> headers = AwsRequestSigningApacheV5Interceptor.headerArrayToMap(request.getHeaders());
        headers.put("x-amz-content-sha256", Collections.singletonList("required"));
        requestBuilder.headers(headers);
        SdkHttpFullRequest signedRequest = this.signer.signRequest(requestBuilder.build());
        request.setHeaders(AwsRequestSigningApacheV5Interceptor.mapToHeaderArray(signedRequest.headers()));
        if (request instanceof ClassicHttpRequest && (httpEntityEnclosingRequest = (ClassicHttpRequest)request).getEntity() != null) {
            BasicHttpEntity basicHttpEntity = new BasicHttpEntity(((ContentStreamProvider)signedRequest.contentStreamProvider().orElseThrow(() -> new IllegalStateException("There must be content"))).newStream(), ContentType.parse((CharSequence)entityDetails.getContentType()));
            httpEntityEnclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)basicHttpEntity));
        }
    }

    private static URI buildUri(HttpRequest request) throws IOException {
        try {
            return request.getUri();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI", ex);
        }
    }

    private static Map<String, List<String>> headerArrayToMap(Header[] headers) {
        TreeMap<String, List<String>> headersMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers) {
            if (AwsRequestSigningApacheV5Interceptor.skipHeader(header)) continue;
            headersMap.put(header.getName(), headersMap.getOrDefault(header.getName(), new LinkedList<String>(Collections.singletonList(header.getValue()))));
        }
        return headersMap;
    }

    private static boolean skipHeader(Header header) {
        return "Content-Length".equalsIgnoreCase(header.getName()) && "0".equals(header.getValue()) || "Host".equalsIgnoreCase(header.getName());
    }

    private static Header[] mapToHeaderArray(Map<String, List<String>> mapHeaders) {
        Header[] headers = new Header[mapHeaders.size()];
        int i = 0;
        for (Map.Entry<String, List<String>> headerEntry : mapHeaders.entrySet()) {
            for (String value : headerEntry.getValue()) {
                headers[i++] = new BasicHeader(headerEntry.getKey(), (Object)value);
            }
        }
        return headers;
    }
}

