/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.a2a.spec.JSONRPCErrorSerializer;
import io.a2a.spec.JSONRPCResponse;
import java.io.IOException;

public class JSONRPCVoidResponseSerializer
extends StdSerializer<JSONRPCResponse<Void>> {
    private static final JSONRPCErrorSerializer JSON_RPC_ERROR_SERIALIZER = new JSONRPCErrorSerializer();

    public JSONRPCVoidResponseSerializer() {
        super(TypeFactory.defaultInstance().constructParametricType(JSONRPCResponse.class, new Class[]{Void.class}));
    }

    public void serialize(JSONRPCResponse<Void> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("jsonrpc", value.getJsonrpc());
        gen.writeObjectField("id", value.getId());
        if (value.getError() != null) {
            gen.writeFieldName("error");
            JSON_RPC_ERROR_SERIALIZER.serialize(value.getError(), gen, provider);
        } else {
            gen.writeNullField("result");
        }
        gen.writeEndObject();
    }
}

