/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.apps.quarkus;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.JsonEOFException;
import io.a2a.server.ExtendedAgentCard;
import io.a2a.server.requesthandlers.JSONRPCHandler;
import io.a2a.server.util.async.Internal;
import io.a2a.spec.AgentCard;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.GetTaskPushNotificationConfigRequest;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.IdJsonMappingException;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidParamsJsonMappingException;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONErrorResponse;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.JSONRPCErrorResponse;
import io.a2a.spec.JSONRPCRequest;
import io.a2a.spec.JSONRPCResponse;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.MethodNotFoundJsonMappingException;
import io.a2a.spec.NonStreamingJSONRPCRequest;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.SetTaskPushNotificationConfigRequest;
import io.a2a.spec.StreamingJSONRPCRequest;
import io.a2a.spec.TaskResubscriptionRequest;
import io.a2a.spec.UnsupportedOperationError;
import io.a2a.util.Utils;
import io.quarkus.vertx.web.Body;
import io.quarkus.vertx.web.ReactiveRoutes;
import io.quarkus.vertx.web.Route;
import io.quarkus.vertx.web.RoutingExchange;
import io.smallrye.mutiny.Multi;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

@Singleton
public class A2AServerRoutes {
    @Inject
    JSONRPCHandler jsonRpcHandler;
    @Inject
    @ExtendedAgentCard
    Instance<AgentCard> extendedAgentCard;
    private static volatile Runnable streamingMultiSseSupportSubscribedRunnable;
    @Inject
    @Internal
    Executor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(path="/", methods={Route.HttpMethod.POST}, consumes={"application/json"}, type=Route.HandlerType.BLOCKING)
    public void invokeJSONRPCHandler(@Body String body, RoutingContext rc) {
        boolean streaming = false;
        JSONRPCResponse<?> nonStreamingResponse = null;
        Multi<? extends JSONRPCResponse<?>> streamingResponse = null;
        JSONRPCErrorResponse error = null;
        try {
            if (A2AServerRoutes.isStreamingRequest(body)) {
                streaming = true;
                request = (StreamingJSONRPCRequest)Utils.OBJECT_MAPPER.readValue(body, StreamingJSONRPCRequest.class);
                streamingResponse = this.processStreamingRequest((JSONRPCRequest<?>)request);
            } else {
                request = (NonStreamingJSONRPCRequest)Utils.OBJECT_MAPPER.readValue(body, NonStreamingJSONRPCRequest.class);
                nonStreamingResponse = this.processNonStreamingRequest(request);
            }
        }
        catch (JsonProcessingException e) {
            error = this.handleError(e);
        }
        catch (Throwable t) {
            error = new JSONRPCErrorResponse((JSONRPCError)new InternalError(t.getMessage()));
        }
        finally {
            if (error != null) {
                rc.response().setStatusCode(200).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(Json.encodeToBuffer((Object)error));
            } else if (streaming) {
                Multi<? extends JSONRPCResponse<?>> finalStreamingResponse = streamingResponse;
                this.executor.execute(() -> MultiSseSupport.subscribeObject((Multi<Object>)finalStreamingResponse.map(i -> i), rc));
            } else {
                rc.response().setStatusCode(200).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(Json.encodeToBuffer(nonStreamingResponse));
            }
        }
    }

    private JSONRPCErrorResponse handleError(JsonProcessingException exception) {
        Object id = null;
        JSONParseError jsonRpcError = null;
        if (exception.getCause() instanceof JsonParseException) {
            jsonRpcError = new JSONParseError();
        } else if (exception instanceof JsonEOFException) {
            jsonRpcError = new JSONParseError(exception.getMessage());
        } else if (exception instanceof MethodNotFoundJsonMappingException) {
            MethodNotFoundJsonMappingException err = (MethodNotFoundJsonMappingException)exception;
            id = err.getId();
            jsonRpcError = new MethodNotFoundError();
        } else if (exception instanceof InvalidParamsJsonMappingException) {
            InvalidParamsJsonMappingException err = (InvalidParamsJsonMappingException)exception;
            id = err.getId();
            jsonRpcError = new InvalidParamsError();
        } else if (exception instanceof IdJsonMappingException) {
            IdJsonMappingException err = (IdJsonMappingException)exception;
            id = err.getId();
            jsonRpcError = new InvalidRequestError();
        } else {
            jsonRpcError = new InvalidRequestError();
        }
        return new JSONRPCErrorResponse(id, (JSONRPCError)jsonRpcError);
    }

    @Route(path="/.well-known/agent.json", methods={Route.HttpMethod.GET}, produces={"application/json"})
    public AgentCard getAgentCard() {
        return this.jsonRpcHandler.getAgentCard();
    }

    @Route(path="/agent/authenticatedExtendedCard", methods={Route.HttpMethod.GET}, produces={"application/json"})
    public void getAuthenticatedExtendedAgentCard(RoutingExchange re) {
        try {
            if (!this.jsonRpcHandler.getAgentCard().supportsAuthenticatedExtendedCard()) {
                JSONErrorResponse errorResponse = new JSONErrorResponse("Extended agent card not supported or not enabled.");
                re.response().setStatusCode(Response.Status.NOT_FOUND.getStatusCode()).end(Utils.OBJECT_MAPPER.writeValueAsString((Object)errorResponse));
                return;
            }
            if (!this.extendedAgentCard.isResolvable()) {
                JSONErrorResponse errorResponse = new JSONErrorResponse("Authenticated extended agent card is supported but not configured on the server.");
                re.response().setStatusCode(Response.Status.NOT_FOUND.getStatusCode()).end(Utils.OBJECT_MAPPER.writeValueAsString((Object)errorResponse));
                return;
            }
            re.response().end(Utils.OBJECT_MAPPER.writeValueAsString(this.extendedAgentCard.get()));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONRPCResponse<?> processNonStreamingRequest(NonStreamingJSONRPCRequest<?> request) {
        if (request instanceof GetTaskRequest) {
            return this.jsonRpcHandler.onGetTask((GetTaskRequest)request);
        }
        if (request instanceof CancelTaskRequest) {
            return this.jsonRpcHandler.onCancelTask((CancelTaskRequest)request);
        }
        if (request instanceof SetTaskPushNotificationConfigRequest) {
            return this.jsonRpcHandler.setPushNotification((SetTaskPushNotificationConfigRequest)request);
        }
        if (request instanceof GetTaskPushNotificationConfigRequest) {
            return this.jsonRpcHandler.getPushNotification((GetTaskPushNotificationConfigRequest)request);
        }
        if (request instanceof SendMessageRequest) {
            return this.jsonRpcHandler.onMessageSend((SendMessageRequest)request);
        }
        return this.generateErrorResponse((JSONRPCRequest<?>)request, (JSONRPCError)new UnsupportedOperationError());
    }

    private Multi<? extends JSONRPCResponse<?>> processStreamingRequest(JSONRPCRequest<?> request) {
        Flow.Publisher publisher;
        if (request instanceof SendStreamingMessageRequest) {
            publisher = this.jsonRpcHandler.onMessageSendStream((SendStreamingMessageRequest)request);
        } else if (request instanceof TaskResubscriptionRequest) {
            publisher = this.jsonRpcHandler.onResubscribeToTask((TaskResubscriptionRequest)request);
        } else {
            return Multi.createFrom().item(this.generateErrorResponse(request, (JSONRPCError)new UnsupportedOperationError()));
        }
        return Multi.createFrom().publisher(publisher);
    }

    private JSONRPCResponse<?> generateErrorResponse(JSONRPCRequest<?> request, JSONRPCError error) {
        return new JSONRPCErrorResponse(request.getId(), error);
    }

    private static boolean isStreamingRequest(String requestBody) {
        return requestBody.contains("message/stream") || requestBody.contains("tasks/resubscribe");
    }

    private static boolean isNonStreamingRequest(String requestBody) {
        return requestBody.contains("tasks/get") || requestBody.contains("tasks/cancel") || requestBody.contains("message/send") || requestBody.contains("tasks/pushNotificationConfig/set") || requestBody.contains("tasks/pushNotificationConfig/get");
    }

    static void setStreamingMultiSseSupportSubscribedRunnable(Runnable runnable) {
        streamingMultiSseSupportSubscribedRunnable = runnable;
    }

    private static class MultiSseSupport {
        private MultiSseSupport() {
        }

        private static void initialize(HttpServerResponse response) {
            if (response.bytesWritten() == 0L) {
                MultiMap headers = response.headers();
                if (headers.get("content-type") == null) {
                    headers.set("content-type", "text/event-stream");
                }
                response.setChunked(true);
            }
        }

        private static void onWriteDone(Flow.Subscription subscription, AsyncResult<Void> ar, RoutingContext rc) {
            if (ar.failed()) {
                rc.fail(ar.cause());
            } else {
                subscription.request(1L);
            }
        }

        public static void write(Multi<Buffer> multi, final RoutingContext rc) {
            final HttpServerResponse response = rc.response();
            multi.subscribe().withSubscriber((Flow.Subscriber)new Flow.Subscriber<Buffer>(){
                Flow.Subscription upstream;

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    this.upstream = subscription;
                    this.upstream.request(1L);
                    Runnable runnable = streamingMultiSseSupportSubscribedRunnable;
                    if (runnable != null) {
                        runnable.run();
                    }
                }

                @Override
                public void onNext(Buffer item) {
                    MultiSseSupport.initialize(response);
                    response.write((Object)item, (Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> ar) {
                            MultiSseSupport.onWriteDone(upstream, ar, rc);
                        }
                    });
                }

                @Override
                public void onError(Throwable throwable) {
                    rc.fail(throwable);
                }

                @Override
                public void onComplete() {
                    MultiSseSupport.endOfStream(response);
                }
            });
        }

        public static void subscribeObject(Multi<Object> multi, RoutingContext rc) {
            final AtomicLong count = new AtomicLong();
            MultiSseSupport.write((Multi<Buffer>)multi.map((Function)new Function<Object, Buffer>(){

                @Override
                public Buffer apply(Object o) {
                    if (o instanceof ReactiveRoutes.ServerSentEvent) {
                        ReactiveRoutes.ServerSentEvent ev = (ReactiveRoutes.ServerSentEvent)o;
                        long id = ev.id() != -1L ? ev.id() : count.getAndIncrement();
                        String e = ev.event() == null ? "" : "event: " + ev.event() + "\n";
                        return Buffer.buffer((String)(e + "data: " + Json.encodeToBuffer((Object)ev.data()) + "\nid: " + id + "\n\n"));
                    }
                    return Buffer.buffer((String)("data: " + Json.encodeToBuffer((Object)o) + "\nid: " + count.getAndIncrement() + "\n\n"));
                }
            }), rc);
        }

        private static void endOfStream(HttpServerResponse response) {
            MultiMap headers;
            if (response.bytesWritten() == 0L && (headers = response.headers()).get("content-type") == null) {
                headers.set("content-type", "text/event-stream");
            }
            response.end();
        }
    }
}

