/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.a2a.A2A;
import io.a2a.client.A2ACardResolver;
import io.a2a.client.sse.SSEEventListener;
import io.a2a.http.A2AHttpClient;
import io.a2a.http.A2AHttpResponse;
import io.a2a.http.JdkA2AHttpClient;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientJSONError;
import io.a2a.spec.A2AServerException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.CancelTaskRequest;
import io.a2a.spec.CancelTaskResponse;
import io.a2a.spec.GetTaskPushNotificationConfigRequest;
import io.a2a.spec.GetTaskPushNotificationConfigResponse;
import io.a2a.spec.GetTaskRequest;
import io.a2a.spec.GetTaskResponse;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.JSONRPCResponse;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.PushNotificationConfig;
import io.a2a.spec.SendMessageRequest;
import io.a2a.spec.SendMessageResponse;
import io.a2a.spec.SendStreamingMessageRequest;
import io.a2a.spec.SetTaskPushNotificationConfigRequest;
import io.a2a.spec.SetTaskPushNotificationConfigResponse;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskResubscriptionRequest;
import io.a2a.util.Assert;
import io.a2a.util.Utils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class A2AClient {
    private static final TypeReference<SendMessageResponse> SEND_MESSAGE_RESPONSE_REFERENCE = new TypeReference<SendMessageResponse>(){};
    private static final TypeReference<GetTaskResponse> GET_TASK_RESPONSE_REFERENCE = new TypeReference<GetTaskResponse>(){};
    private static final TypeReference<CancelTaskResponse> CANCEL_TASK_RESPONSE_REFERENCE = new TypeReference<CancelTaskResponse>(){};
    private static final TypeReference<GetTaskPushNotificationConfigResponse> GET_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE = new TypeReference<GetTaskPushNotificationConfigResponse>(){};
    private static final TypeReference<SetTaskPushNotificationConfigResponse> SET_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE = new TypeReference<SetTaskPushNotificationConfigResponse>(){};
    private final A2AHttpClient httpClient;
    private final String agentUrl;
    private AgentCard agentCard;

    public A2AClient(AgentCard agentCard) {
        Assert.checkNotNullParam((String)"agentCard", (Object)agentCard);
        this.agentCard = agentCard;
        this.agentUrl = agentCard.url();
        this.httpClient = new JdkA2AHttpClient();
    }

    public A2AClient(String agentUrl) {
        Assert.checkNotNullParam((String)"agentUrl", (Object)agentUrl);
        this.agentUrl = agentUrl;
        this.httpClient = new JdkA2AHttpClient();
    }

    public static A2AClient getClientFromAgentCardUrl(A2AHttpClient httpClient, String baseUrl, String agentCardPath) throws A2AClientError, A2AClientJSONError {
        A2ACardResolver resolver = new A2ACardResolver(httpClient, baseUrl, agentCardPath);
        AgentCard card = resolver.getAgentCard();
        return new A2AClient(card);
    }

    public AgentCard getAgentCard() throws A2AClientError, A2AClientJSONError {
        if (this.agentCard == null) {
            this.agentCard = A2A.getAgentCard(this.httpClient, this.agentUrl);
        }
        return this.agentCard;
    }

    public AgentCard getAgentCard(String relativeCardPath, Map<String, String> authHeaders) throws A2AClientError, A2AClientJSONError {
        if (this.agentCard == null) {
            this.agentCard = A2A.getAgentCard(this.httpClient, this.agentUrl, relativeCardPath, authHeaders);
        }
        return this.agentCard;
    }

    public SendMessageResponse sendMessage(MessageSendParams messageSendParams) throws A2AServerException {
        return this.sendMessage(null, messageSendParams);
    }

    public SendMessageResponse sendMessage(String requestId, MessageSendParams messageSendParams) throws A2AServerException {
        SendMessageRequest.Builder sendMessageRequestBuilder = new SendMessageRequest.Builder().jsonrpc("2.0").method("message/send").params(messageSendParams);
        if (requestId != null) {
            sendMessageRequestBuilder.id((Object)requestId);
        }
        SendMessageRequest sendMessageRequest = sendMessageRequestBuilder.build();
        try {
            String httpResponseBody = this.sendPostRequest(sendMessageRequest);
            return this.unmarshalResponse(httpResponseBody, SEND_MESSAGE_RESPONSE_REFERENCE);
        }
        catch (IOException | InterruptedException e) {
            throw new A2AServerException("Failed to send message: " + e);
        }
    }

    public GetTaskResponse getTask(String id) throws A2AServerException {
        return this.getTask(null, new TaskQueryParams(id));
    }

    public GetTaskResponse getTask(TaskQueryParams taskQueryParams) throws A2AServerException {
        return this.getTask(null, taskQueryParams);
    }

    public GetTaskResponse getTask(String requestId, TaskQueryParams taskQueryParams) throws A2AServerException {
        GetTaskRequest.Builder getTaskRequestBuilder = new GetTaskRequest.Builder().jsonrpc("2.0").method("tasks/get").params(taskQueryParams);
        if (requestId != null) {
            getTaskRequestBuilder.id((Object)requestId);
        }
        GetTaskRequest getTaskRequest = getTaskRequestBuilder.build();
        try {
            String httpResponseBody = this.sendPostRequest(getTaskRequest);
            return this.unmarshalResponse(httpResponseBody, GET_TASK_RESPONSE_REFERENCE);
        }
        catch (IOException | InterruptedException e) {
            throw new A2AServerException("Failed to get task: " + e);
        }
    }

    public CancelTaskResponse cancelTask(String id) throws A2AServerException {
        return this.cancelTask(null, new TaskIdParams(id));
    }

    public CancelTaskResponse cancelTask(TaskIdParams taskIdParams) throws A2AServerException {
        return this.cancelTask(null, taskIdParams);
    }

    public CancelTaskResponse cancelTask(String requestId, TaskIdParams taskIdParams) throws A2AServerException {
        CancelTaskRequest.Builder cancelTaskRequestBuilder = new CancelTaskRequest.Builder().jsonrpc("2.0").method("tasks/cancel").params(taskIdParams);
        if (requestId != null) {
            cancelTaskRequestBuilder.id((Object)requestId);
        }
        CancelTaskRequest cancelTaskRequest = cancelTaskRequestBuilder.build();
        try {
            String httpResponseBody = this.sendPostRequest(cancelTaskRequest);
            return this.unmarshalResponse(httpResponseBody, CANCEL_TASK_RESPONSE_REFERENCE);
        }
        catch (IOException | InterruptedException e) {
            throw new A2AServerException("Failed to cancel task: " + e);
        }
    }

    public GetTaskPushNotificationConfigResponse getTaskPushNotificationConfig(String id) throws A2AServerException {
        return this.getTaskPushNotificationConfig(null, new TaskIdParams(id));
    }

    public GetTaskPushNotificationConfigResponse getTaskPushNotificationConfig(TaskIdParams taskIdParams) throws A2AServerException {
        return this.getTaskPushNotificationConfig(null, taskIdParams);
    }

    public GetTaskPushNotificationConfigResponse getTaskPushNotificationConfig(String requestId, TaskIdParams taskIdParams) throws A2AServerException {
        GetTaskPushNotificationConfigRequest.Builder getTaskPushNotificationRequestBuilder = new GetTaskPushNotificationConfigRequest.Builder().jsonrpc("2.0").method("tasks/pushNotificationConfig/get").params(taskIdParams);
        if (requestId != null) {
            getTaskPushNotificationRequestBuilder.id((Object)requestId);
        }
        GetTaskPushNotificationConfigRequest getTaskPushNotificationRequest = getTaskPushNotificationRequestBuilder.build();
        try {
            String httpResponseBody = this.sendPostRequest(getTaskPushNotificationRequest);
            return this.unmarshalResponse(httpResponseBody, GET_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE);
        }
        catch (IOException | InterruptedException e) {
            throw new A2AServerException("Failed to get task push notification config: " + e);
        }
    }

    public SetTaskPushNotificationConfigResponse setTaskPushNotificationConfig(String taskId, PushNotificationConfig pushNotificationConfig) throws A2AServerException {
        return this.setTaskPushNotificationConfig(null, taskId, pushNotificationConfig);
    }

    public SetTaskPushNotificationConfigResponse setTaskPushNotificationConfig(String requestId, String taskId, PushNotificationConfig pushNotificationConfig) throws A2AServerException {
        SetTaskPushNotificationConfigRequest.Builder setTaskPushNotificationRequestBuilder = new SetTaskPushNotificationConfigRequest.Builder().jsonrpc("2.0").method("tasks/pushNotificationConfig/set").params(new TaskPushNotificationConfig(taskId, pushNotificationConfig));
        if (requestId != null) {
            setTaskPushNotificationRequestBuilder.id((Object)requestId);
        }
        SetTaskPushNotificationConfigRequest setTaskPushNotificationRequest = setTaskPushNotificationRequestBuilder.build();
        try {
            String httpResponseBody = this.sendPostRequest(setTaskPushNotificationRequest);
            return this.unmarshalResponse(httpResponseBody, SET_TASK_PUSH_NOTIFICATION_CONFIG_RESPONSE_REFERENCE);
        }
        catch (IOException | InterruptedException e) {
            throw new A2AServerException("Failed to set task push notification config: " + e);
        }
    }

    public void sendStreamingMessage(MessageSendParams messageSendParams, Consumer<StreamingEventKind> eventHandler, Consumer<JSONRPCError> errorHandler, Runnable failureHandler) throws A2AServerException {
        this.sendStreamingMessage(null, messageSendParams, eventHandler, errorHandler, failureHandler);
    }

    public void sendStreamingMessage(String requestId, MessageSendParams messageSendParams, Consumer<StreamingEventKind> eventHandler, Consumer<JSONRPCError> errorHandler, Runnable failureHandler) throws A2AServerException {
        Assert.checkNotNullParam((String)"messageSendParams", (Object)messageSendParams);
        Assert.checkNotNullParam((String)"eventHandler", eventHandler);
        Assert.checkNotNullParam((String)"errorHandler", errorHandler);
        Assert.checkNotNullParam((String)"failureHandler", (Object)failureHandler);
        SendStreamingMessageRequest.Builder sendStreamingMessageRequestBuilder = new SendStreamingMessageRequest.Builder().jsonrpc("2.0").method("message/stream").params(messageSendParams);
        if (requestId != null) {
            sendStreamingMessageRequestBuilder.id((Object)requestId);
        }
        AtomicReference<CompletableFuture<Void>> ref = new AtomicReference<CompletableFuture<Void>>();
        SSEEventListener sseEventListener = new SSEEventListener(eventHandler, errorHandler, failureHandler);
        SendStreamingMessageRequest sendStreamingMessageRequest = sendStreamingMessageRequestBuilder.build();
        try {
            A2AHttpClient.PostBuilder builder = this.createPostBuilder(sendStreamingMessageRequest);
            ref.set(builder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> {}));
        }
        catch (IOException e) {
            throw new A2AServerException("Failed to send streaming message request: " + e);
        }
        catch (InterruptedException e) {
            throw new A2AServerException("Send streaming message request timed out: " + e);
        }
    }

    public void resubscribeToTask(TaskIdParams taskIdParams, Consumer<StreamingEventKind> eventHandler, Consumer<JSONRPCError> errorHandler, Runnable failureHandler) throws A2AServerException {
        this.resubscribeToTask(null, taskIdParams, eventHandler, errorHandler, failureHandler);
    }

    public void resubscribeToTask(String requestId, TaskIdParams taskIdParams, Consumer<StreamingEventKind> eventHandler, Consumer<JSONRPCError> errorHandler, Runnable failureHandler) throws A2AServerException {
        Assert.checkNotNullParam((String)"taskIdParams", (Object)taskIdParams);
        Assert.checkNotNullParam((String)"eventHandler", eventHandler);
        Assert.checkNotNullParam((String)"errorHandler", errorHandler);
        Assert.checkNotNullParam((String)"failureHandler", (Object)failureHandler);
        TaskResubscriptionRequest.Builder taskResubscriptionRequestBuilder = new TaskResubscriptionRequest.Builder().jsonrpc("2.0").method("tasks/resubscribe").params(taskIdParams);
        if (requestId != null) {
            taskResubscriptionRequestBuilder.id((Object)requestId);
        }
        AtomicReference<CompletableFuture<Void>> ref = new AtomicReference<CompletableFuture<Void>>();
        SSEEventListener sseEventListener = new SSEEventListener(eventHandler, errorHandler, failureHandler);
        TaskResubscriptionRequest taskResubscriptionRequest = taskResubscriptionRequestBuilder.build();
        try {
            A2AHttpClient.PostBuilder builder = this.createPostBuilder(taskResubscriptionRequest);
            ref.set(builder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> {}));
        }
        catch (IOException e) {
            throw new A2AServerException("Failed to send task resubscription request: " + e);
        }
        catch (InterruptedException e) {
            throw new A2AServerException("Task resubscription request timed out: " + e);
        }
    }

    private String sendPostRequest(Object value) throws IOException, InterruptedException {
        A2AHttpClient.PostBuilder builder = this.createPostBuilder(value);
        A2AHttpResponse response = builder.post();
        if (!response.success()) {
            throw new IOException("Request failed " + response.status());
        }
        return response.body();
    }

    private A2AHttpClient.PostBuilder createPostBuilder(Object value) throws JsonProcessingException {
        return ((A2AHttpClient.PostBuilder)((A2AHttpClient.PostBuilder)this.httpClient.createPost().url(this.agentUrl)).addHeader("Content-Type", "application/json")).body(Utils.OBJECT_MAPPER.writeValueAsString(value));
    }

    private <T extends JSONRPCResponse> T unmarshalResponse(String response, TypeReference<T> typeReference) throws A2AServerException, JsonProcessingException {
        JSONRPCResponse value = (JSONRPCResponse)Utils.unmarshalFrom((String)response, typeReference);
        JSONRPCError error = value.getError();
        if (error != null) {
            throw new A2AServerException(error.getMessage() + (String)(error.getData() != null ? ": " + error.getData() : ""));
        }
        return (T)value;
    }
}

