/*
 * Decompiled with CFR 0.152.
 */
package io.a2a;

import io.a2a.client.A2ACardResolver;
import io.a2a.http.A2AHttpClient;
import io.a2a.http.JdkA2AHttpClient;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientJSONError;
import io.a2a.spec.AgentCard;
import io.a2a.spec.Message;
import io.a2a.spec.TextPart;
import java.util.Collections;
import java.util.Map;

public class A2A {
    public static Message toUserMessage(String text) {
        return A2A.toMessage(text, Message.Role.USER, null);
    }

    public static Message toUserMessage(String text, String messageId) {
        return A2A.toMessage(text, Message.Role.USER, messageId);
    }

    public static Message toAgentMessage(String text) {
        return A2A.toMessage(text, Message.Role.AGENT, null);
    }

    public static Message toAgentMessage(String text, String messageId) {
        return A2A.toMessage(text, Message.Role.AGENT, messageId);
    }

    private static Message toMessage(String text, Message.Role role, String messageId) {
        Message.Builder messageBuilder = new Message.Builder().role(role).parts(Collections.singletonList(new TextPart(text)));
        if (messageId != null) {
            messageBuilder.messageId(messageId);
        }
        return messageBuilder.build();
    }

    public static AgentCard getAgentCard(String agentUrl) throws A2AClientError, A2AClientJSONError {
        return A2A.getAgentCard(new JdkA2AHttpClient(), agentUrl);
    }

    public static AgentCard getAgentCard(A2AHttpClient httpClient, String agentUrl) throws A2AClientError, A2AClientJSONError {
        return A2A.getAgentCard(httpClient, agentUrl, null, null);
    }

    public static AgentCard getAgentCard(String agentUrl, String relativeCardPath, Map<String, String> authHeaders) throws A2AClientError, A2AClientJSONError {
        return A2A.getAgentCard(new JdkA2AHttpClient(), agentUrl, relativeCardPath, authHeaders);
    }

    public static AgentCard getAgentCard(A2AHttpClient httpClient, String agentUrl, String relativeCardPath, Map<String, String> authHeaders) throws A2AClientError, A2AClientJSONError {
        A2ACardResolver resolver = new A2ACardResolver(httpClient, agentUrl, relativeCardPath, authHeaders);
        return resolver.getAgentCard();
    }
}

