/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes.AttributeUtils;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;

public class FileAttributes
implements PlexusIoResourceAttributes {
    @Nullable
    private final Integer groupId;
    @Nullable
    private final String groupName;
    @Nullable
    private final Integer userId;
    private final String userName;
    private final boolean symbolicLink;
    private final int octalMode;
    private final Set<PosixFilePermission> permissions;

    public FileAttributes(@Nonnull File file, @Nonnull Map<Integer, String> userCache, @Nonnull Map<Integer, String> groupCache) throws IOException {
        Path path = file.toPath();
        if (AttributeUtils.isUnix(path)) {
            Map<String, Object> attrs = Files.readAttributes(path, "unix:permissions,gid,uid,isSymbolicLink,mode", LinkOption.NOFOLLOW_LINKS);
            this.permissions = (Set)attrs.get("permissions");
            this.groupId = (Integer)attrs.get("gid");
            String groupName = groupCache.get(this.groupId);
            if (groupName != null) {
                this.groupName = groupName;
            } else {
                Object group = Files.getAttribute(path, "unix:group", LinkOption.NOFOLLOW_LINKS);
                this.groupName = ((Principal)group).getName();
                groupCache.put(this.groupId, this.groupName);
            }
            this.userId = (Integer)attrs.get("uid");
            String userName = userCache.get(this.userId);
            if (userName != null) {
                this.userName = userName;
            } else {
                Object owner = Files.getAttribute(path, "unix:owner", LinkOption.NOFOLLOW_LINKS);
                this.userName = ((Principal)owner).getName();
                userCache.put(this.userId, this.userName);
            }
            this.octalMode = (Integer)attrs.get("mode") & 0xFFF;
            this.symbolicLink = (Boolean)attrs.get("isSymbolicLink");
        } else {
            FileOwnerAttributeView fa = AttributeUtils.getFileOwnershipInfo(file);
            this.userName = fa.getOwner().getName();
            this.userId = null;
            this.groupName = null;
            this.groupId = null;
            this.octalMode = -1;
            this.permissions = Collections.emptySet();
            this.symbolicLink = Files.isSymbolicLink(path);
        }
    }

    @Nonnull
    public static PlexusIoResourceAttributes uncached(@Nonnull File file) throws IOException {
        return new FileAttributes(file, new HashMap<Integer, String>(), new HashMap<Integer, String>());
    }

    @Override
    @Nullable
    public Integer getGroupId() {
        return this.groupId;
    }

    public boolean hasGroupId() {
        return false;
    }

    public boolean hasUserId() {
        return false;
    }

    @Override
    @Nullable
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Integer getUserId() {
        return this.userId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isGroupExecutable() {
        return this.containsPermission(PosixFilePermission.GROUP_EXECUTE);
    }

    private boolean containsPermission(PosixFilePermission groupExecute) {
        return this.permissions.contains((Object)groupExecute);
    }

    @Override
    public boolean isGroupReadable() {
        return this.containsPermission(PosixFilePermission.GROUP_READ);
    }

    @Override
    public boolean isGroupWritable() {
        return this.containsPermission(PosixFilePermission.GROUP_WRITE);
    }

    @Override
    public boolean isOwnerExecutable() {
        return this.containsPermission(PosixFilePermission.OWNER_EXECUTE);
    }

    @Override
    public boolean isOwnerReadable() {
        return this.containsPermission(PosixFilePermission.OWNER_READ);
    }

    @Override
    public boolean isOwnerWritable() {
        return this.containsPermission(PosixFilePermission.OWNER_WRITE);
    }

    @Override
    public boolean isWorldExecutable() {
        return this.containsPermission(PosixFilePermission.OTHERS_EXECUTE);
    }

    @Override
    public boolean isWorldReadable() {
        return this.containsPermission(PosixFilePermission.OTHERS_READ);
    }

    @Override
    public boolean isWorldWritable() {
        return this.containsPermission(PosixFilePermission.OTHERS_WRITE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append("File Attributes:");
        sb.append(System.lineSeparator());
        sb.append("------------------------------");
        sb.append(System.lineSeparator());
        sb.append("user: ");
        sb.append(this.userName == null ? "" : this.userName);
        sb.append(System.lineSeparator());
        sb.append("group: ");
        sb.append(this.groupName == null ? "" : this.groupName);
        sb.append(System.lineSeparator());
        sb.append("uid: ");
        sb.append(this.hasUserId() ? Integer.toString(this.userId) : "");
        sb.append(System.lineSeparator());
        sb.append("gid: ");
        sb.append(this.hasGroupId() ? Integer.toString(this.groupId) : "");
        return sb.toString();
    }

    @Override
    public int getOctalMode() {
        return this.octalMode;
    }

    public int calculatePosixOctalMode() {
        int result = 0;
        if (this.isOwnerReadable()) {
            result |= 0x100;
        }
        if (this.isOwnerWritable()) {
            result |= 0x80;
        }
        if (this.isOwnerExecutable()) {
            result |= 0x40;
        }
        if (this.isGroupReadable()) {
            result |= 0x20;
        }
        if (this.isGroupWritable()) {
            result |= 0x10;
        }
        if (this.isGroupExecutable()) {
            result |= 8;
        }
        if (this.isWorldReadable()) {
            result |= 4;
        }
        if (this.isWorldWritable()) {
            result |= 2;
        }
        if (this.isWorldExecutable()) {
            result |= 1;
        }
        return result;
    }

    public String getOctalModeString() {
        return Integer.toString(this.getOctalMode(), 8);
    }

    @Override
    public boolean isSymbolicLink() {
        return this.symbolicLink;
    }
}

