/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver.zip;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import lmcoursier.internal.shaded.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import lmcoursier.internal.shaded.org.apache.commons.compress.archivers.zip.ZipFile;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.zip.ZipResource;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.zip.ZipSymlinkResource;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.EncodingSupported;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResource;

public class PlexusArchiverZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection
implements EncodingSupported {
    public static final String ROLE_HINT = "zip";
    private Charset charset = Charset.forName("UTF-8");

    @Override
    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The tar archive file has not been set.");
        }
        ZipFile zipFile = new ZipFile(f, this.charset != null ? this.charset.name() : "UTF8");
        return new CloseableIterator(zipFile);
    }

    @Override
    public boolean isConcurrentAccessSupported() {
        return false;
    }

    @Override
    public void setEncoding(Charset charset) {
        this.charset = charset;
    }

    class CloseableIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        final Enumeration<ZipArchiveEntry> en;
        private final ZipFile zipFile;

        public CloseableIterator(ZipFile zipFile) {
            this.en = zipFile.getEntriesInPhysicalOrder();
            this.zipFile = zipFile;
        }

        @Override
        public boolean hasNext() {
            return this.en.hasMoreElements();
        }

        @Override
        public PlexusIoResource next() {
            ZipArchiveEntry entry = this.en.nextElement();
            return entry.isUnixSymlink() ? new ZipSymlinkResource(this.zipFile, entry, PlexusArchiverZipFileResourceCollection.this.getStreamTransformer()) : new ZipResource(this.zipFile, entry, PlexusArchiverZipFileResourceCollection.this.getStreamTransformer());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing isn't implemented.");
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }
    }
}

