/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import lmcoursier.internal.shaded.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import lmcoursier.internal.shaded.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import lmcoursier.internal.shaded.org.apache.commons.compress.archivers.zip.ZipEncoding;
import lmcoursier.internal.shaded.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import lmcoursier.internal.shaded.org.apache.commons.compress.parallel.InputStreamSupplier;
import lmcoursier.internal.shaded.org.apache.commons.compress.utils.Charsets;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.AbstractArchiver;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiveEntry;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ArchiverException;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.ResourceIterator;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.exceptions.EmptyArchiveException;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.util.ResourceUtils;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.util.Streams;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.zip.AddedDirs;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.zip.AnonymousResource;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.zip.ConcurrentJarCreator;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.SymlinkDestinationSupplier;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResource;
import lmcoursier.internal.shaded.org.codehaus.plexus.util.FileUtils;

public abstract class AbstractZipArchiver
extends AbstractArchiver {
    private String comment;
    private String encoding = "UTF8";
    private boolean doCompress = true;
    private boolean recompressAddedZips = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    protected String archiveType = "zip";
    private boolean doFilesonly = false;
    protected final Hashtable<String, String> entries = new Hashtable();
    protected final AddedDirs addedDirs = new AddedDirs();
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    protected final String duplicate = "skip";
    protected boolean addingNewFiles = false;
    private File renamedFile = null;
    private File zipFile;
    private boolean success;
    private ConcurrentJarCreator zOut;
    protected ZipArchiveOutputStream zipArchiveOutputStream;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCompress(boolean compress) {
        this.doCompress = compress;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public boolean isRecompressAddedZips() {
        return this.recompressAddedZips;
    }

    public void setRecompressAddedZips(boolean recompressAddedZips) {
        this.recompressAddedZips = recompressAddedZips;
    }

    public void setUpdateMode(boolean update) {
        this.savedDoUpdate = this.doUpdate = update;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void setFilesonly(boolean f) {
        this.doFilesonly = f;
    }

    public boolean isFilesonly() {
        return this.doFilesonly;
    }

    @Override
    protected void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.createArchiveMain();
            this.skipWriting = false;
            this.createArchiveMain();
        } else {
            this.createArchiveMain();
        }
        this.finalizeZipOutputStream(this.zOut);
    }

    protected void finalizeZipOutputStream(ConcurrentJarCreator zOut) throws IOException, ArchiverException {
    }

    private void createArchiveMain() throws ArchiverException, IOException {
        ResourceIterator iter;
        if (!"skip".equals("skip")) {
            this.setDuplicateBehavior("skip");
        }
        if (!(iter = this.getResources()).hasNext() && !this.hasVirtualFiles()) {
            throw new EmptyArchiveException("archive cannot be empty");
        }
        this.zipFile = this.getDestFile();
        if (this.zipFile == null) {
            throw new ArchiverException("You must set the destination " + this.archiveType + "file.");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new ArchiverException(this.zipFile + " isn't a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new ArchiverException(this.zipFile + " is read-only.");
        }
        this.addingNewFiles = true;
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.getLogger().debug("ignoring update attribute as " + this.archiveType + " doesn't exist.");
        }
        this.success = false;
        if (this.doUpdate) {
            this.renamedFile = FileUtils.createTempFile("zip", ".tmp", this.zipFile.getParentFile());
            this.renamedFile.deleteOnExit();
            try {
                FileUtils.rename(this.zipFile, this.renamedFile);
            }
            catch (SecurityException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
            catch (IOException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
        }
        String action = this.doUpdate ? "Updating " : "Building ";
        this.getLogger().info(action + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        if (!this.skipWriting) {
            this.zipArchiveOutputStream = new ZipArchiveOutputStream(Streams.bufferedOutputStream(Streams.fileOutputStream(this.zipFile, "zip")));
            this.zipArchiveOutputStream.setEncoding(this.encoding);
            this.zipArchiveOutputStream.setCreateUnicodeExtraFields(this.getUnicodeExtraFieldPolicy());
            this.zipArchiveOutputStream.setMethod(this.doCompress ? 8 : 0);
            this.zOut = new ConcurrentJarCreator(this.recompressAddedZips, Runtime.getRuntime().availableProcessors());
        }
        this.initZipOutputStream(this.zOut);
        this.addResources(iter, this.zOut);
        if (this.doUpdate && !this.renamedFile.delete()) {
            this.getLogger().warn("Warning: unable to delete temporary file " + this.renamedFile.getName());
        }
        this.success = true;
    }

    private ZipArchiveOutputStream.UnicodeExtraFieldPolicy getUnicodeExtraFieldPolicy() {
        boolean utf8;
        String effectiveEncoding = this.getEncoding();
        if (effectiveEncoding == null) {
            effectiveEncoding = Charset.defaultCharset().name();
        }
        if (!(utf8 = Charsets.UTF_8.name().equalsIgnoreCase(effectiveEncoding))) {
            for (String alias : Charsets.UTF_8.aliases()) {
                if (!alias.equalsIgnoreCase(effectiveEncoding)) continue;
                utf8 = true;
                break;
            }
        }
        return utf8 ? ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NEVER : ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS;
    }

    protected final void addResources(ResourceIterator resources, ConcurrentJarCreator zOut) throws IOException, ArchiverException {
        while (resources.hasNext()) {
            ArchiveEntry entry = resources.next();
            String name = entry.getName();
            if ("".equals(name = name.replace(File.separatorChar, '/'))) continue;
            if (entry.getResource().isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            this.addParentDirs(entry, null, name, zOut);
            if (entry.getResource().isFile()) {
                this.zipFile(entry, zOut, name);
                continue;
            }
            this.zipDir(entry.getResource(), zOut, name, entry.getMode(), this.encoding);
        }
    }

    private void addParentDirs(ArchiveEntry archiveEntry, File baseDir, String entry, ConcurrentJarCreator zOut) throws IOException {
        if (!this.doFilesonly && this.getIncludeEmptyDirs()) {
            Deque<String> directories = this.addedDirs.asStringDeque(entry);
            while (!directories.isEmpty()) {
                String dir = directories.pop();
                File f = baseDir != null ? new File(baseDir, dir) : new File(dir);
                AnonymousResource res = new AnonymousResource(f);
                this.zipDir(res, zOut, dir, archiveEntry.getDefaultDirMode(), this.encoding);
            }
        }
    }

    protected void zipFile(InputStreamSupplier in, ConcurrentJarCreator zOut, String vPath, long lastModified, File fromArchive, int mode, String symlinkDestination, boolean addInParallel) throws IOException, ArchiverException {
        this.getLogger().debug("adding entry " + vPath);
        this.entries.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipArchiveEntry ze = new ZipArchiveEntry(vPath);
            this.setTime(ze, lastModified);
            ze.setMethod(this.doCompress ? 8 : 0);
            ze.setUnixMode(0x8000 | mode);
            if (ze.isUnixSymlink()) {
                byte[] bytes = this.encodeArchiveEntry(symlinkDestination, this.getEncoding());
                ByteArrayInputStream payload = new ByteArrayInputStream(bytes);
                zOut.addArchiveEntry(ze, this.createInputStreamSupplier(payload), true);
            } else {
                zOut.addArchiveEntry(ze, in, addInParallel);
            }
        }
    }

    protected void zipFile(final ArchiveEntry entry, ConcurrentJarCreator zOut, String vPath) throws IOException, ArchiverException {
        PlexusIoResource resource = entry.getResource();
        if (ResourceUtils.isSame(resource, this.getDestFile())) {
            throw new ArchiverException("A zip file cannot include itself");
        }
        boolean b = entry.getResource() instanceof SymlinkDestinationSupplier;
        String symlinkTarget = b ? ((SymlinkDestinationSupplier)((Object)entry.getResource())).getSymlinkDestination() : null;
        InputStreamSupplier in = new InputStreamSupplier(){

            @Override
            public InputStream get() {
                try {
                    return entry.getInputStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            this.zipFile(in, zOut, vPath, resource.getLastModified(), null, entry.getMode(), symlinkTarget, !entry.shouldAddSynchronously());
        }
        catch (IOException e) {
            throw new ArchiverException("IOException when zipping r" + entry.getName() + ": " + e.getMessage(), e);
        }
    }

    private void setTime(ZipEntry zipEntry, long lastModified) {
        if (this.getLastModifiedDate() != null) {
            lastModified = this.getLastModifiedDate().getTime();
        }
        zipEntry.setTime(lastModified + 1999L);
    }

    protected void zipDir(PlexusIoResource dir, ConcurrentJarCreator zOut, String vPath, int mode, String encodingToUse) throws IOException {
        if (this.addedDirs.update(vPath)) {
            return;
        }
        this.getLogger().debug("adding directory " + vPath);
        if (!this.skipWriting) {
            boolean isSymlink = dir instanceof SymlinkDestinationSupplier;
            if (isSymlink && vPath.endsWith(File.separator)) {
                vPath = vPath.substring(0, vPath.length() - 1);
            }
            ZipArchiveEntry ze = new ZipArchiveEntry(vPath);
            if (isSymlink) {
                mode = 0xA000 | mode;
            }
            if (dir != null && dir.isExisting()) {
                this.setTime(ze, dir.getLastModified());
            } else {
                this.setTime(ze, System.currentTimeMillis());
            }
            if (!isSymlink) {
                ze.setSize(0L);
                ze.setMethod(0);
                ze.setCrc(EMPTY_CRC);
            }
            ze.setUnixMode(mode);
            if (!isSymlink) {
                zOut.addArchiveEntry(ze, this.createInputStreamSupplier(new ByteArrayInputStream("".getBytes())), true);
            } else {
                String symlinkDestination = ((SymlinkDestinationSupplier)((Object)dir)).getSymlinkDestination();
                byte[] bytes = this.encodeArchiveEntry(symlinkDestination, encodingToUse);
                ze.setMethod(8);
                zOut.addArchiveEntry(ze, this.createInputStreamSupplier(new ByteArrayInputStream(bytes)), true);
            }
        }
    }

    private byte[] encodeArchiveEntry(String payload, String encoding) throws IOException {
        ZipEncoding enc = ZipEncodingHelper.getZipEncoding(encoding);
        ByteBuffer encodedPayloadByteBuffer = enc.encode(payload);
        byte[] encodedPayloadBytes = new byte[encodedPayloadByteBuffer.limit()];
        encodedPayloadByteBuffer.get(encodedPayloadBytes);
        return encodedPayloadBytes;
    }

    protected InputStreamSupplier createInputStreamSupplier(final InputStream inputStream) {
        return new InputStreamSupplier(){

            @Override
            public InputStream get() {
                return inputStream;
            }
        };
    }

    protected boolean createEmptyZip(File zipFile) throws ArchiverException {
        this.getLogger().info("Note: creating empty " + this.archiveType + " archive " + zipFile);
        try (OutputStream os = Files.newOutputStream(zipFile.toPath(), new OpenOption[0]);){
            byte[] empty = new byte[22];
            empty[0] = 80;
            empty[1] = 75;
            empty[2] = 5;
            empty[3] = 6;
            os.write(empty);
        }
        catch (IOException ioe) {
            throw new ArchiverException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe);
        }
        return true;
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.addedDirs.clear();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        this.success = false;
        this.zOut = null;
        this.renamedFile = null;
        this.zipFile = null;
    }

    public void reset() {
        this.setDestFile(null);
        this.archiveType = "zip";
        this.doCompress = true;
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected void initZipOutputStream(ConcurrentJarCreator zOut) throws ArchiverException, IOException {
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }

    @Override
    protected boolean revert(StringBuffer messageBuffer) {
        int initLength = messageBuffer.length();
        if (!(this.doUpdate && this.renamedFile == null || this.zipFile.delete())) {
            messageBuffer.append(" (and the archive is probably corrupt but I could not delete it)");
        }
        if (this.doUpdate && this.renamedFile != null) {
            try {
                FileUtils.rename(this.renamedFile, this.zipFile);
            }
            catch (IOException e) {
                messageBuffer.append(" (and I couldn't rename the temporary file ");
                messageBuffer.append(this.renamedFile.getName());
                messageBuffer.append(" back)");
            }
        }
        return messageBuffer.length() == initLength;
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.zipArchiveOutputStream != null) {
                if (this.zOut != null) {
                    this.zOut.writeTo(this.zipArchiveOutputStream);
                }
                this.zipArchiveOutputStream.close();
            }
        }
        catch (IOException ex) {
            if (this.success) {
                throw ex;
            }
        }
        catch (InterruptedException e) {
            IOException ex = new IOException("InterruptedException exception");
            ex.initCause(e.getCause());
            throw ex;
        }
        catch (ExecutionException e) {
            IOException ex = new IOException("Execution exception");
            ex.initCause(e.getCause());
            throw ex;
        }
    }

    @Override
    protected String getArchiveType() {
        return this.archiveType;
    }

    @Override
    protected Date normalizeLastModifiedDate(Date lastModifiedDate) {
        return new Date(AbstractZipArchiver.dosToJavaTime(lastModifiedDate.getTime()));
    }

    private static long dosToJavaTime(long dosTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dosTime);
        return dosTime - (long)(cal.get(15) + cal.get(16));
    }
}

