/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.apache.xbean.propertyeditor;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import lmcoursier.internal.shaded.org.apache.xbean.propertyeditor.AbstractConverter;
import lmcoursier.internal.shaded.org.apache.xbean.propertyeditor.PropertyEditorException;

public class DateEditor
extends AbstractConverter {
    private List<DateFormat> formats = new ArrayList<DateFormat>();

    public DateEditor() {
        super(Date.class);
        this.formats.add(DateFormat.getInstance());
        this.formats.add(DateFormat.getDateInstance());
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd"));
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz"));
    }

    protected Object toObjectImpl(String text2) {
        for (DateFormat format : this.formats) {
            try {
                return format.parse(text2);
            }
            catch (ParseException e) {
            }
        }
        try {
            return this.complexParse(text2);
        }
        catch (ParseException e) {
            throw new PropertyEditorException(e);
        }
    }

    private Object complexParse(String text2) throws ParseException {
        String token;
        Locale locale = Locale.getDefault();
        int style = 2;
        int firstSpaceIndex = text2.indexOf(32);
        if (firstSpaceIndex != -1 && (token = text2.substring(0, firstSpaceIndex).intern()).startsWith("locale")) {
            String localeStr = token.substring(token.indexOf(61) + 1);
            int underscoreIndex = localeStr.indexOf(95);
            if (underscoreIndex != -1) {
                String language = localeStr.substring(0, underscoreIndex);
                String country = localeStr.substring(underscoreIndex + 1);
                locale = new Locale(language, country);
            } else {
                locale = new Locale(localeStr);
            }
            int nextSpaceIndex = text2.indexOf(32, firstSpaceIndex + 1);
            token = text2.substring(firstSpaceIndex + 1, nextSpaceIndex);
            String styleStr = token.substring(token.indexOf(61) + 1);
            style = styleStr.equalsIgnoreCase("SHORT") ? 3 : (styleStr.equalsIgnoreCase("MEDIUM") ? 2 : (styleStr.equalsIgnoreCase("LONG") ? 1 : (styleStr.equalsIgnoreCase("FULL") ? 0 : 2)));
            text2 = text2.substring(nextSpaceIndex + 1);
        }
        DateFormat formats = DateFormat.getDateInstance(style, locale);
        return formats.parse(text2);
    }

    protected String toStringImpl(Object value) {
        Date date = (Date)value;
        String text2 = this.formats.get(0).format(date);
        return text2;
    }
}

