/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.CDataNode;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Comment;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.DocumentType;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Element;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Entities;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.LeafNode;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Node;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.TextNode;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.nodes.XmlDeclaration;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.parser.Parser;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.parser.Tag;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.parser.Token;
import lmcoursier.internal.shaded.coursier.util.shaded.org.jsoup.parser.TreeBuilder;

public class XmlTreeBuilder
extends TreeBuilder {
    private static final int maxQueueDepth = 256;

    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.preserveCase;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        super.initialiseParse(input, baseUri, parser);
        this.stack.add(this.doc);
        this.doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml).escapeMode(Entities.EscapeMode.xhtml).prettyPrint(false);
    }

    Document parse(Reader input, String baseUri) {
        return this.parse(input, baseUri, new Parser(this));
    }

    Document parse(String input, String baseUri) {
        return this.parse(new StringReader(input), baseUri, new Parser(this));
    }

    @Override
    XmlTreeBuilder newInstance() {
        return new XmlTreeBuilder();
    }

    @Override
    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    private void insertNode(Node node) {
        this.currentElement().appendChild(node);
    }

    Element insert(Token.StartTag startTag) {
        Tag tag2 = this.tagFor(startTag.name(), this.settings);
        if (startTag.hasAttributes()) {
            startTag.attributes.deduplicate(this.settings);
        }
        Element el = new Element(tag2, null, this.settings.normalizeAttributes(startTag.attributes));
        this.insertNode(el);
        if (startTag.isSelfClosing()) {
            if (!tag2.isKnownTag()) {
                tag2.setSelfClosing();
            }
        } else {
            this.stack.add(el);
        }
        return el;
    }

    void insert(Token.Comment commentToken) {
        XmlDeclaration decl;
        Comment comment;
        LeafNode insert = comment = new Comment(commentToken.getData());
        if (commentToken.bogus && comment.isXmlDeclaration() && (decl = comment.asXmlDeclaration()) != null) {
            insert = decl;
        }
        this.insertNode(insert);
    }

    void insert(Token.Character token) {
        String data = token.getData();
        this.insertNode(token.isCData() ? new CDataNode(data) : new TextNode(data));
    }

    void insert(Token.Doctype d) {
        DocumentType doctypeNode = new DocumentType(this.settings.normalizeTag(d.getName()), d.getPublicIdentifier(), d.getSystemIdentifier());
        doctypeNode.setPubSysKey(d.getPubSysKey());
        this.insertNode(doctypeNode);
    }

    private void popStackToClose(Token.EndTag endTag) {
        Element next;
        int pos;
        String elName = this.settings.normalizeTag(endTag.tagName);
        Element firstFound = null;
        int bottom = this.stack.size() - 1;
        int upper = bottom >= 256 ? bottom - 256 : 0;
        for (pos = this.stack.size() - 1; pos >= upper; --pos) {
            next = (Element)this.stack.get(pos);
            if (!next.nodeName().equals(elName)) continue;
            firstFound = next;
            break;
        }
        if (firstFound == null) {
            return;
        }
        for (pos = this.stack.size() - 1; pos >= 0; --pos) {
            next = (Element)this.stack.get(pos);
            this.stack.remove(pos);
            if (next == firstFound) break;
        }
    }

    List<Node> parseFragment(String inputFragment, String baseUri, Parser parser) {
        this.initialiseParse(new StringReader(inputFragment), baseUri, parser);
        this.runParser();
        return this.doc.childNodes();
    }

    @Override
    List<Node> parseFragment(String inputFragment, Element context, String baseUri, Parser parser) {
        return this.parseFragment(inputFragment, baseUri, parser);
    }
}

