/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.asn1;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Primitive;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1TaggedObject;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1UniversalType;
import io.gatling.recorder.internal.bouncycastle.asn1.DERNull;
import io.gatling.recorder.internal.bouncycastle.asn1.DEROctetString;
import java.io.IOException;

public abstract class ASN1Null
extends ASN1Primitive {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1Null.class, 5){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1Null.createPrimitive(dEROctetString.getOctets());
        }
    };

    public static ASN1Null getInstance(Object object) {
        if (object instanceof ASN1Null) {
            return (ASN1Null)object;
        }
        if (object != null) {
            try {
                return (ASN1Null)TYPE.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct NULL from byte[]: " + iOException.getMessage());
            }
        }
        return null;
    }

    public static ASN1Null getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1Null)TYPE.getContextTagged(aSN1TaggedObject, bl);
    }

    public static ASN1Null getTagged(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1Null)TYPE.getTagged(aSN1TaggedObject, bl);
    }

    ASN1Null() {
    }

    @Override
    public int hashCode() {
        return -1;
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        return aSN1Primitive instanceof ASN1Null;
    }

    public String toString() {
        return "NULL";
    }

    static ASN1Null createPrimitive(byte[] byArray) {
        if (0 != byArray.length) {
            throw new IllegalStateException("malformed NULL encoding encountered");
        }
        return DERNull.INSTANCE;
    }
}

