/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.client;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\u0007\u000f\u0005]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011%Y\u0005\u00011AA\u0002\u0013%A\nC\u0005c\u0001\u0001\u0007\t\u0019!C\u0005G\"I!\f\u0001a\u0001\u0002\u0003\u0006K!\u0014\u0005\tU\u0002A)\u0019!C\u0005W\")q\u000e\u0001C\u0005a\"A\u0011\u0011\u0003\u0001\u0005\u00029\t\u0019\u0002\u0003\u0005\u0002\u0018\u0001!\tADA\r\u0005Y\u0011V\r\u001e:b]Nl\u0017n]:j_:|\u0005/\u001a:bi>\u0014(BA\b\u0011\u0003\u0019\u0019G.[3oi*\u0011\u0011CE\u0001\u0005[F$HO\u0003\u0002\u0014)\u00059q-\u0019;mS:<'\"A\u000b\u0002\u0005%|7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 M5\t\u0001E\u0003\u0002\"E\u0005a1oY1mC2|wmZ5oO*\u00111\u0005J\u0001\tif\u0004Xm]1gK*\tQ%A\u0002d_6L!a\n\u0011\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003=y'/[4j]\u0006dW*Z:tC\u001e,\u0007C\u0001\u00163\u001b\u0005Y#BA\t-\u0015\tic&A\u0003d_\u0012,7M\u0003\u00020a\u00059\u0001.\u00198eY\u0016\u0014(BA\u0019\u0015\u0003\u0015qW\r\u001e;z\u0013\t\u00194FA\u0006NcR$X*Z:tC\u001e,\u0017AD5oSRL\u0017\r\u001c+j[\u0016|W\u000f\u001e\t\u00033YJ!a\u000e\u000e\u0003\t1{gnZ\u0001\u0012E\u0006\u001c7n\u001c4g\u001bVdG/\u001b9mS\u0016\u0014\bCA\r;\u0013\tY$DA\u0003GY>\fG/\u0001\u0006qC\u000e\\W\r^*f]\u0012\u0004B!\u0007 *\u0001&\u0011qH\u0007\u0002\n\rVt7\r^5p]F\u0002\"!G!\n\u0005\tS\"\u0001B+oSR\fa\u0001P5oSRtD#B#H\u0011&S\u0005C\u0001$\u0001\u001b\u0005q\u0001\"\u0002\u0015\u0006\u0001\u0004I\u0003\"\u0002\u001b\u0006\u0001\u0004)\u0004\"\u0002\u001d\u0006\u0001\u0004I\u0004\"\u0002\u001f\u0006\u0001\u0004i\u0014aF:dQ\u0016$W\u000f\\3e%\u0016$(/\u00198t[&\u001c8/[8o+\u0005i\u0005G\u0001(Y!\ryEKV\u0007\u0002!*\u0011\u0011KU\u0001\u000bG>t7-\u001e:sK:$(BA*1\u0003\u0011)H/\u001b7\n\u0005U\u0003&aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0011\u0005]CF\u0002\u0001\u0003\n3\"\t\t\u0011!A\u0003\u0002m\u00131a\u0018\u00132\u0003a\u00198\r[3ek2,GMU3ue\u0006t7/\\5tg&|g\u000eI\t\u00039~\u0003\"!G/\n\u0005yS\"a\u0002(pi\"Lgn\u001a\t\u00033\u0001L!!\u0019\u000e\u0003\u0007\u0005s\u00170A\u000etG\",G-\u001e7fIJ+GO]1og6L7o]5p]~#S-\u001d\u000b\u0003\u0001\u0012Dq!Z\u0004\u0002\u0002\u0003\u0007a-A\u0002yIE\u0002$aZ5\u0011\u0007=#\u0006\u000e\u0005\u0002XS\u0012I\u0011\fZA\u0001\u0002\u0003\u0015\taW\u0001\u0019e\u0016$(/\u00198t[&$H/\u001a3GSb,G\rS3bI\u0016\u0014X#\u00017\u0011\u0005)j\u0017B\u00018,\u0005=i\u0015\u000f\u001e;GSb,G\rS3bI\u0016\u0014\u0018AG:dQ\u0016$W\u000f\\3OKb$(+\u001a;sC:\u001cX.[:tS>tGc\u0001!rs\")!O\u0003a\u0001g\u0006IQM^3oi2{w\u000e\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mB\nqa\u00195b]:,G.\u0003\u0002yk\nIQI^3oi2{w\u000e\u001d\u0005\u0006u*\u0001\r!N\u0001\bi&lWm\\;uQ\u0019QA0!\u0003\u0002\fA\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0011\u0001\u00026bm\u0006L1!a\u0002\u007f\u0005A\u0019V\u000f\u001d9sKN\u001cx+\u0019:oS:<7/A\u0003wC2,X\r\f\u0002\u0002\u000e\u0005\u0012\u0011qB\u0001 _J<gf^1siJ,Wn\u001c<fe::\u0018M\u001d;t]I+7-\u001e:tS>t\u0017!B:uCJ$Hc\u0001!\u0002\u0016!)!o\u0003a\u0001g\u0006!1\u000f^8q)\u0005\u0001\u0005")
public final class RetransmissionOperator
implements StrictLogging {
    private MqttFixedHeader retransmittedFixedHeader;
    private final MqttMessage originalMessage;
    private final long initialTimeout;
    private final float backoffMultiplier;
    private final Function1<MqttMessage, BoxedUnit> packetSend;
    private ScheduledFuture<?> scheduledRetransmission;
    private Logger logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ScheduledFuture<?> scheduledRetransmission() {
        return this.scheduledRetransmission;
    }

    private void scheduledRetransmission_$eq(ScheduledFuture<?> x$1) {
        this.scheduledRetransmission = x$1;
    }

    private MqttFixedHeader retransmittedFixedHeader$lzycompute() {
        RetransmissionOperator retransmissionOperator = this;
        synchronized (retransmissionOperator) {
            if (!this.bitmap$0) {
                this.retransmittedFixedHeader = new MqttFixedHeader(this.originalMessage.fixedHeader().messageType(), true, this.originalMessage.fixedHeader().qosLevel(), this.originalMessage.fixedHeader().isRetain(), this.originalMessage.fixedHeader().remainingLength());
                this.bitmap$0 = true;
            }
        }
        return this.retransmittedFixedHeader;
    }

    private MqttFixedHeader retransmittedFixedHeader() {
        if (!this.bitmap$0) {
            return this.retransmittedFixedHeader$lzycompute();
        }
        return this.retransmittedFixedHeader;
    }

    private void scheduleNextRetransmission(EventLoop eventLoop, long timeout) {
        this.scheduledRetransmission_$eq(eventLoop.schedule(() -> {
            BoxedUnit boxedUnit;
            $this.packetSend.apply((Object)MqttMessageFactory.newMessage((MqttFixedHeader)this.retransmittedFixedHeader(), (Object)$this.originalMessage.variableHeader(), (Object)ReferenceCountUtil.retain((Object)$this.originalMessage.payload())));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("rePub {} executed id {}", new Object[]{this.retransmittedFixedHeader().messageType(), BoxesRunTime.boxToInteger((int)((MqttPublishVariableHeader)$this.originalMessage.variableHeader()).packetId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.scheduleNextRetransmission(eventLoop, (long)((float)timeout * $this.backoffMultiplier));
        }, timeout, TimeUnit.MILLISECONDS));
    }

    public void start(EventLoop eventLoop) {
        Predef$.MODULE$.require(eventLoop != null, (Function0 & Serializable)() -> "eventLoop musn't be null");
        this.scheduleNextRetransmission(eventLoop, this.initialTimeout);
    }

    public void stop() {
        ReferenceCounted referenceCounted;
        Object object = this.originalMessage.payload();
        if (object instanceof ReferenceCounted && (referenceCounted = (ReferenceCounted)object).refCnt() > 0) {
            BoxesRunTime.boxToBoolean((boolean)referenceCounted.release(referenceCounted.refCnt()));
        }
        if (this.scheduledRetransmission() != null) {
            this.scheduledRetransmission().cancel(true);
            return;
        }
    }

    public RetransmissionOperator(MqttMessage originalMessage, long initialTimeout, float backoffMultiplier, Function1<MqttMessage, BoxedUnit> packetSend) {
        this.originalMessage = originalMessage;
        this.initialTimeout = initialTimeout;
        this.backoffMultiplier = backoffMultiplier;
        this.packetSend = packetSend;
        StrictLogging.$init$((StrictLogging)this);
        Predef$.MODULE$.require(packetSend != null, (Function0 & Serializable)() -> "packetSend mustn't be null");
        ReferenceCountUtil.retain((Object)originalMessage.payload());
        Statics.releaseFence();
    }
}

