/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.client;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.mqtt.client.MqttChannelHandler;
import io.gatling.mqtt.client.MqttChannelHandler$;
import io.gatling.mqtt.client.MqttClient;
import io.gatling.mqtt.client.MqttClientConfig;
import io.gatling.mqtt.client.MqttClientImpl$;
import io.gatling.mqtt.client.MqttConnectionListener;
import io.gatling.mqtt.client.MqttIncomingQos2Publish;
import io.gatling.mqtt.client.MqttPendingPublish;
import io.gatling.mqtt.client.MqttPendingPublish$;
import io.gatling.mqtt.client.MqttPendingSubscription;
import io.gatling.mqtt.client.MqttPendingSubscription$;
import io.gatling.mqtt.client.MqttPendingUnsubscription;
import io.gatling.mqtt.client.MqttPendingUnsubscription$;
import io.gatling.mqtt.client.MqttSubscription;
import io.gatling.mqtt.client.MqttTopicListener;
import io.gatling.mqtt.client.NettyFutures$;
import io.gatling.mqtt.client.NettyFutures$PimpedNettyFuture$;
import io.gatling.mqtt.client.NoopHandler$;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r}t!B'O\u0011\u00039f!B-O\u0011\u0003Q\u0006\"B1\u0002\t\u0003\u0011\u0007bB2\u0002\u0005\u0004%I\u0001\u001a\u0005\u0007a\u0006\u0001\u000b\u0011B3\t\u000fE\f!\u0019!C\u0005e\"1a0\u0001Q\u0001\nMDqa`\u0001C\u0002\u0013%!\u000fC\u0004\u0002\u0002\u0005\u0001\u000b\u0011B:\t\u0013\u0005\r\u0011A1A\u0005\n\u0005\u0015\u0001\u0002CA\u0007\u0003\u0001\u0006I!a\u0002\t\u0013\u0005=\u0011A1A\u0005\n\u0005E\u0001\u0002CA\r\u0003\u0001\u0006I!a\u0005\t\u0013\u0005u\u0012A1A\u0005\n\u0005}\u0002\u0002CA#\u0003\u0001\u0006I!!\u0011\t\u0013\u0005\u001d\u0013A1A\u0005\n\u0005%\u0003\u0002CA(\u0003\u0001\u0006I!a\u0013\u0007\u000bes%!!\u0015\t\u0015\u00055\u0014C!A!\u0002\u0013\ty\u0007\u0003\u0006\u0002zE\u0011\t\u0011)A\u0005\u0003wB!\"!#\u0012\u0005\u000b\u0007I\u0011AAF\u0011)\t\u0019*\u0005B\u0001B\u0003%\u0011Q\u0012\u0005\u0007CF!\t!!&\t\u0013\u0005}\u0015C1A\u0005\n\u0005\u0005\u0006\u0002CAX#\u0001\u0006I!a)\t\u0015\u0005E\u0016C1A\u0005\u00029\u000b\u0019\f\u0003\u0005\u0002ZF\u0001\u000b\u0011BA[\u0011)\tY.\u0005b\u0001\n\u0003q\u0015Q\u001c\u0005\t\u0003g\f\u0002\u0015!\u0003\u0002`\"Q\u0011Q_\tC\u0002\u0013\u0005a*a>\t\u0011\t\u0005\u0011\u0003)A\u0005\u0003sD!Ba\u0001\u0012\u0005\u0004%\tA\u0014B\u0003\u0011!\u0011)\"\u0005Q\u0001\n\t\u001d\u0001B\u0003B\f#\t\u0007I\u0011\u0001(\u0003\u001a!A!1E\t!\u0002\u0013\u0011Y\u0002C\u0005\u0003&E\u0001\r\u0011\"\u0003\u0003(!I!qF\tA\u0002\u0013%!\u0011\u0007\u0005\t\u0005{\t\u0002\u0015)\u0003\u0003*!a\u0011\u0011V\tA\u0002\u0003\u0007I\u0011\u0001(\u0003@!a!qI\tA\u0002\u0003\u0007I\u0011\u0001(\u0003J!Y!QJ\tA\u0002\u0003\u0005\u000b\u0015\u0002B!\u00111\u0011y%\u0005a\u0001\u0002\u0004%\tA\u0014B)\u00111\u0011I&\u0005a\u0001\u0002\u0004%\tA\u0014B.\u0011-\u0011y&\u0005a\u0001\u0002\u0003\u0006KAa\u0015\t\u0013\t\u0005\u0014\u00031A\u0005\u0002\t\u001d\u0002\"\u0003B2#\u0001\u0007I\u0011\u0001B3\u0011!\u0011I'\u0005Q!\n\t%\u0002b\u0003B6#\u0001\u0007\t\u0019!C\u0005\u0005[B1Ba \u0012\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0002\"Y!QQ\tA\u0002\u0003\u0005\u000b\u0015\u0002B8\u0011-\u00119)\u0005a\u0001\u0002\u0004%IA!#\t\u0017\tE\u0015\u00031AA\u0002\u0013%!1\u0013\u0005\f\u0005/\u000b\u0002\u0019!A!B\u0013\u0011Y\tC\u0006\u0003\u001aF\u0001\r\u00111A\u0005\n\tm\u0005b\u0003BR#\u0001\u0007\t\u0019!C\u0005\u0005KC1B!+\u0012\u0001\u0004\u0005\t\u0015)\u0003\u0003\u001e\"I!1V\tA\u0002\u0013%!Q\u0016\u0005\n\u0005k\u000b\u0002\u0019!C\u0005\u0005oC\u0001Ba/\u0012A\u0003&!q\u0016\u0005\b\u0005{\u000bB\u0011\u0002B`\u0011\u001d\u0011Y-\u0005C\u0005\u0005\u001bDqAa3\u0012\t\u0003\u0012)\u000e\u0003\u0005\u0003\\F!\tA\u0014Bo\u0011\u001d\u0011y.\u0005C\u0005\u0005CDqAa:\u0012\t\u0013\u0011\t\u0006C\u0004\u0003jF!\tEa;\t\u000f\r\r\u0011\u0003\"\u0011\u0004\u0006!91\u0011B\t\u0005B\r-\u0001bBB\u0005#\u0011\u00053q\u0004\u0005\b\u0007\u0013\tB\u0011IB\u0014\u0011\u001d\u0019\t$\u0005C\u0005\u0007gAqa!\u0003\u0012\t\u0003\u001aY\u0005C\u0004\u0004VE!\tE!8\t\u0011\r]\u0013\u0003\"\u0001O\u00073Bqaa\u0019\u0012\t\u0013\u0019)\u0007C\u0004\u0004nE!Iaa\u001c\t\u000f\rU\u0014\u0003\"\u0003\u0004x\u0005qQ*\u001d;u\u00072LWM\u001c;J[Bd'BA(Q\u0003\u0019\u0019G.[3oi*\u0011\u0011KU\u0001\u0005[F$HO\u0003\u0002T)\u00069q-\u0019;mS:<'\"A+\u0002\u0005%|7\u0001\u0001\t\u00031\u0006i\u0011A\u0014\u0002\u000f\u001bF$Ho\u00117jK:$\u0018*\u001c9m'\t\t1\f\u0005\u0002]?6\tQLC\u0001_\u0003\u0015\u00198-\u00197b\u0013\t\u0001WL\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u000bqc\u0015;biN\u001c\u0005.\u00198oK2D\u0015M\u001c3mKJt\u0015-\\3\u0016\u0003\u0015\u0004\"AZ7\u000f\u0005\u001d\\\u0007C\u00015^\u001b\u0005I'B\u00016W\u0003\u0019a$o\\8u}%\u0011A.X\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002m;\u0006A2\u000b^1ug\u000eC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe:\u000bW.\u001a\u0011\u0002-M+(m]2sS\n,W*Z:tC\u001e,\u0007*Z1eKJ,\u0012a\u001d\t\u0003irl\u0011!\u001e\u0006\u0003#ZT!a\u001e=\u0002\u000b\r|G-Z2\u000b\u0005eT\u0018a\u00025b]\u0012dWM\u001d\u0006\u0003wR\u000bQA\\3uifL!!`;\u0003\u001f5\u000bH\u000f\u001e$jq\u0016$\u0007*Z1eKJ\fqcU;cg\u000e\u0014\u0018NY3NKN\u001c\u0018mZ3IK\u0006$WM\u001d\u0011\u00021Us7/\u001e2tGJL'-Z'fgN\fw-\u001a%fC\u0012,'/A\rV]N,(m]2sS\n,W*Z:tC\u001e,\u0007*Z1eKJ\u0004\u0013!\u0005#jg\u000e|gN\\3di6+7o]1hKV\u0011\u0011q\u0001\t\u0004i\u0006%\u0011bAA\u0006k\nYQ*\u001d;u\u001b\u0016\u001c8/Y4f\u0003I!\u0015n]2p]:,7\r^'fgN\fw-\u001a\u0011\u0002+5\u000b\u0007PU3d_:tWm\u0019;Fq\u000e,\u0007\u000f^5p]V\u0011\u00111\u0003\n\u0007\u0003+\tY\"!\f\u0007\r\u0005]A\u0002AA\n\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003Yi\u0015\r\u001f*fG>tg.Z2u\u000bb\u001cW\r\u001d;j_:\u0004\u0003\u0003BA\u000f\u0003OqA!a\b\u0002$9\u0019\u0001.!\t\n\u0003yK1!!\n^\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000b\u0002,\tIQ\t_2faRLwN\u001c\u0006\u0004\u0003Ki\u0006\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\bG>tGO]8m\u0015\r\t9$X\u0001\u0005kRLG.\u0003\u0003\u0002<\u0005E\"\u0001\u0004(p'R\f7m\u001b+sC\u000e,\u0017aG\"iC:tW\r\u001c(pi^\u0013\u0018\u000e^1cY\u0016,\u0005pY3qi&|g.\u0006\u0002\u0002BI1\u00111IA\u000e\u0003[1a!a\u0006\u000f\u0001\u0005\u0005\u0013\u0001H\"iC:tW\r\u001c(pi^\u0013\u0018\u000e^1cY\u0016,\u0005pY3qi&|g\u000eI\u0001\u0017\u0007\"\fgN\\3m\u00072|7/\u001a3Fq\u000e,\u0007\u000f^5p]V\u0011\u00111\n\n\u0007\u0003\u001b\nY\"!\f\u0007\r\u0005]\u0001\u0003AA&\u0003]\u0019\u0005.\u00198oK2\u001cEn\\:fI\u0016C8-\u001a9uS>t\u0007e\u0005\u0004\u00127\u0006M\u0013\u0011\f\t\u00041\u0006U\u0013bAA,\u001d\nQQ*\u001d;u\u00072LWM\u001c;\u0011\t\u0005m\u0013\u0011N\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005a1oY1mC2|wmZ5oO*!\u00111MA3\u0003!!\u0018\u0010]3tC\u001a,'BAA4\u0003\r\u0019w.\\\u0005\u0005\u0003W\niFA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\nE>|Go\u001d;sCB\u0004B!!\u001d\u0002v5\u0011\u00111\u000f\u0006\u0004\u0003[R\u0018\u0002BA<\u0003g\u0012\u0011BQ8piN$(/\u00199\u0002\u000b\rdwnY6\u0011\t\u0005u\u0014QQ\u0007\u0003\u0003\u007fRA!a\u000e\u0002\u0002*\u0019\u00111\u0011*\u0002\u000f\r|W.\\8og&!\u0011qQA@\u0005\u0015\u0019En\\2l\u00031\u0019G.[3oi\u000e{gNZ5h+\t\ti\tE\u0002Y\u0003\u001fK1!!%O\u0005Ai\u0015\u000f\u001e;DY&,g\u000e^\"p]\u001aLw-A\u0007dY&,g\u000e^\"p]\u001aLw\r\t\u000b\t\u0003/\u000bI*a'\u0002\u001eB\u0011\u0001,\u0005\u0005\b\u0003[2\u0002\u0019AA8\u0011\u001d\tIH\u0006a\u0001\u0003wBq!!#\u0017\u0001\u0004\ti)A\u0005fm\u0016tG\u000fT8paV\u0011\u00111\u0015\t\u0005\u0003K\u000bY+\u0004\u0002\u0002(*\u0019\u0011\u0011\u0016>\u0002\u000f\rD\u0017M\u001c8fY&!\u0011QVAT\u0005%)e/\u001a8u\u0019>|\u0007/\u0001\u0006fm\u0016tG\u000fT8pa\u0002\n\u0011\u0004]3oI&twmU3sm\u0016\u0014XK\\:vEN\u001c'/\u001b2fgV\u0011\u0011Q\u0017\t\t\u0003o\u000b\u0019-a2\u0002T6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u000e\u0002@*\u0011\u0011\u0011Y\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002F\u0006e&!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011\u0011ZAh\u001b\t\tYM\u0003\u0003\u0002N\u0006}\u0016\u0001\u00027b]\u001eLA!!5\u0002L\n9\u0011J\u001c;fO\u0016\u0014\bc\u0001-\u0002V&\u0019\u0011q\u001b(\u000335\u000bH\u000f\u001e)f]\u0012LgnZ+ogV\u00147o\u0019:jaRLwN\\\u0001\u001ba\u0016tG-\u001b8h'\u0016\u0014h/\u001a:V]N,(m]2sS\n,7\u000fI\u0001\u001dc>\u001c(\u0007U3oI&tw-\u00138d_6Lgn\u001a)vE2L7\u000f[3t+\t\ty\u000e\u0005\u0004\u0002b\u0006%\u0018Q^\u0007\u0003\u0003GTA!!:\u0002h\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0007\u0005]\"0\u0003\u0003\u0002l\u0006\r(\u0001E%oi>\u0013'.Z2u\u0011\u0006\u001c\b.T1q!\rA\u0016q^\u0005\u0004\u0003ct%aF'riRLenY8nS:<\u0017k\\:3!V\u0014G.[:i\u0003u\txn\u001d\u001aQK:$\u0017N\\4J]\u000e|W.\u001b8h!V\u0014G.[:iKN\u0004\u0013\u0001\u00059f]\u0012Lgn\u001a)vE2L7\u000f[3t+\t\tI\u0010\u0005\u0004\u0002b\u0006%\u00181 \t\u00041\u0006u\u0018bAA\u0000\u001d\n\u0011R*\u001d;u!\u0016tG-\u001b8h!V\u0014G.[:i\u0003E\u0001XM\u001c3j]\u001e\u0004VO\u00197jg\",7\u000fI\u0001\u000egV\u00147o\u0019:jaRLwN\\:\u0016\u0005\t\u001d\u0001c\u0002B\u0005\u0005\u0017)'qB\u0007\u0003\u0003{KAA!\u0004\u0002>\n\u0019Q*\u00199\u0011\u0007a\u0013\t\"C\u0002\u0003\u00149\u0013\u0001#T9uiN+(m]2sSB$\u0018n\u001c8\u0002\u001dM,(m]2sSB$\u0018n\u001c8tA\u0005!\u0002/\u001a8eS:<7+\u001e2tGJL\u0007\u000f^5p]N,\"Aa\u0007\u0011\r\u0005\u0005\u0018\u0011\u001eB\u000f!\rA&qD\u0005\u0004\u0005Cq%aF'riR\u0004VM\u001c3j]\u001e\u001cVOY:de&\u0004H/[8o\u0003U\u0001XM\u001c3j]\u001e\u001cVOY:de&\u0004H/[8og\u0002\nQB\\3yi6+7o]1hK&#WC\u0001B\u0015!\ra&1F\u0005\u0004\u0005[i&aA%oi\u0006\tb.\u001a=u\u001b\u0016\u001c8/Y4f\u0013\u0012|F%Z9\u0015\t\tM\"\u0011\b\t\u00049\nU\u0012b\u0001B\u001c;\n!QK\\5u\u0011%\u0011Y\u0004JA\u0001\u0002\u0004\u0011I#A\u0002yIE\naB\\3yi6+7o]1hK&#\u0007%\u0006\u0002\u0003BA!\u0011Q\u0015B\"\u0013\u0011\u0011)%a*\u0003\u000f\rC\u0017M\u001c8fY\u0006Y1\r[1o]\u0016dw\fJ3r)\u0011\u0011\u0019Da\u0013\t\u0013\tmr%!AA\u0002\t\u0005\u0013\u0001C2iC:tW\r\u001c\u0011\u0002+M$\u0018M\u001d;D_:tWm\u0019;US6,7\u000f^1naV\u0011!1\u000b\t\u00049\nU\u0013b\u0001B,;\n!Aj\u001c8h\u0003e\u0019H/\u0019:u\u0007>tg.Z2u)&lWm\u001d;b[B|F%Z9\u0015\t\tM\"Q\f\u0005\n\u0005wQ\u0013\u0011!a\u0001\u0005'\nac\u001d;beR\u001cuN\u001c8fGR$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0014e\u0016\u001cwN\u001c8fGR\u001c\u0018\t\u001e;f[B$X\rZ\u0001\u0018e\u0016\u001cwN\u001c8fGR\u001c\u0018\t\u001e;f[B$X\rZ0%KF$BAa\r\u0003h!I!1H\u0017\u0002\u0002\u0003\u0007!\u0011F\u0001\u0015e\u0016\u001cwN\u001c8fGR\u001c\u0018\t\u001e;f[B$X\r\u001a\u0011\u0002\u001b\r|gN\\3di\u001a+H/\u001e:f+\t\u0011y\u0007\u0005\u0004\u0003r\tU$\u0011P\u0007\u0003\u0005gRA!a/\u0002h&!!q\u000fB:\u0005\u001d\u0001&o\\7jg\u0016\u00042\u0001\u001eB>\u0013\r\u0011i(\u001e\u0002\u0016\u001bF$HoQ8o]\u0016\u001cGOU3ukJt7i\u001c3f\u0003E\u0019wN\u001c8fGR4U\u000f^;sK~#S-\u001d\u000b\u0005\u0005g\u0011\u0019\tC\u0005\u0003<A\n\t\u00111\u0001\u0003p\u0005q1m\u001c8oK\u000e$h)\u001e;ve\u0016\u0004\u0013AE2p]:,7\r^5p]2K7\u000f^3oKJ,\"Aa#\u0011\u0007a\u0013i)C\u0002\u0003\u0010:\u0013a#T9ui\u000e{gN\\3di&|g\u000eT5ti\u0016tWM]\u0001\u0017G>tg.Z2uS>tG*[:uK:,'o\u0018\u0013fcR!!1\u0007BK\u0011%\u0011YdMA\u0001\u0002\u0004\u0011Y)A\nd_:tWm\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\b%A\u0007u_BL7\rT5ti\u0016tWM]\u000b\u0003\u0005;\u00032\u0001\u0017BP\u0013\r\u0011\tK\u0014\u0002\u0012\u001bF$H\u000fV8qS\u000ed\u0015n\u001d;f]\u0016\u0014\u0018!\u0005;pa&\u001cG*[:uK:,'o\u0018\u0013fcR!!1\u0007BT\u0011%\u0011YDNA\u0001\u0002\u0004\u0011i*\u0001\bu_BL7\rT5ti\u0016tWM\u001d\u0011\u0002\u001b\u0011L7oY8o]\u0016\u001cG/\u001b8h+\t\u0011y\u000bE\u0002]\u0005cK1Aa-^\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0003Z5tG>tg.Z2uS:<w\fJ3r)\u0011\u0011\u0019D!/\t\u0013\tm\u0012(!AA\u0002\t=\u0016A\u00043jg\u000e|gN\\3di&tw\rI\u0001\u0013S:\u001cH/\u00197m\u001bF$H\u000fS1oI2,'\u000f\u0006\u0003\u00034\t\u0005\u0007b\u0002Bbw\u0001\u0007!QY\u0001\ta&\u0004X\r\\5oKB!\u0011Q\u0015Bd\u0013\u0011\u0011I-a*\u0003\u001f\rC\u0017M\u001c8fYBK\u0007/\u001a7j]\u0016\fqaY8o]\u0016\u001cG\u000f\u0006\u0002\u0003PB1!\u0011\u000fBi\u0005sJAAa5\u0003t\t1a)\u001e;ve\u0016$bAa4\u0003X\ne\u0007b\u0002BD{\u0001\u0007!1\u0012\u0005\b\u00053k\u0004\u0019\u0001BO\u0003%\u0011XmY8o]\u0016\u001cG\u000f\u0006\u0002\u00034\u0005\t2o\u00195fIVdWMU3d_:tWm\u0019;\u0015\t\tM\"1\u001d\u0005\b\u0005K|\u0004\u0019\u0001B*\u00039\u0011XmY8o]\u0016\u001cG\u000fR3mCf\fQcY8naV$XMU3d_:tWm\u0019;EK2\f\u00170A\u0005tk\n\u001c8M]5cKR1!Q\u001eB{\u0005s\u0004bA!\u001d\u0003R\n=\b\u0003BAe\u0005cLAAa=\u0002L\n!ak\\5e\u0011\u0019\u001190\u0011a\u0001K\u0006)Ao\u001c9jG\"9!1`!A\u0002\tu\u0018aA9pgB\u0019AOa@\n\u0007\r\u0005QOA\u0004NcR$\u0018k\\*\u0002\u0017Ut7/\u001e2tGJL'-\u001a\u000b\u0005\u0005[\u001c9\u0001\u0003\u0004\u0003x\n\u0003\r!Z\u0001\baV\u0014G.[:i)\u0019\u0011io!\u0004\u0004\u0010!1!q_\"A\u0002\u0015Dqa!\u0005D\u0001\u0004\u0019\u0019\"A\u0004qCfdw.\u00193\u0011\t\rU11D\u0007\u0003\u0007/Q1a!\u0007{\u0003\u0019\u0011WO\u001a4fe&!1QDB\f\u0005\u001d\u0011\u0015\u0010^3Ck\u001a$\u0002B!<\u0004\"\r\r2Q\u0005\u0005\u0007\u0005o$\u0005\u0019A3\t\u000f\rEA\t1\u0001\u0004\u0014!9!1 #A\u0002\tuH\u0003\u0003Bw\u0007S\u0019Yc!\f\t\r\t]X\t1\u0001f\u0011\u001d\u0019\t\"\u0012a\u0001\u0007'Aqaa\fF\u0001\u0004\u0011y+\u0001\u0004sKR\f\u0017N\\\u0001\taV\u0014G.[:iaQQ!1GB\u001b\u0007\u007f\u0019\u0019e!\u0013\t\u000f\r]b\t1\u0001\u0004:\u00059Q.Z:tC\u001e,\u0007c\u0001;\u0004<%\u00191QH;\u0003%5\u000bH\u000f\u001e)vE2L7\u000f['fgN\fw-\u001a\u0005\b\u0007\u00032\u0005\u0019AA~\u00039\u0001XM\u001c3j]\u001e\u0004VO\u00197jg\"Dqa!\u0012G\u0001\u0004\u00199%\u0001\u0004gkR,(/\u001a\t\u0007\u0005c\u0012)Ha<\t\u000f\u0005}e\t1\u0001\u0002$RQ!Q^B'\u0007\u001f\u001a\tfa\u0015\t\r\t]x\t1\u0001f\u0011\u001d\u0019\tb\u0012a\u0001\u0007'AqAa?H\u0001\u0004\u0011i\u0010C\u0004\u00040\u001d\u0003\rAa,\u0002\u000b\rdwn]3\u0002%M,g\u000eZ!oI\u001acWo\u001d5QC\u000e\\W\r\u001e\u000b\u0005\u00077\u001a\t\u0007\u0005\u0003\u0002&\u000eu\u0013\u0002BB0\u0003O\u0013Qb\u00115b]:,GNR;ukJ,\u0007bBB\u001c\u0013\u0002\u0007\u0011qA\u0001\u0010O\u0016$h*Z<NKN\u001c\u0018mZ3JIV\u00111q\r\t\u0004i\u000e%\u0014bAB6k\nYR*\u001d;u\u001b\u0016\u001c8/Y4f\u0013\u00124\u0016M]5bE2,\u0007*Z1eKJ\f!c\u0019:fCR,7+\u001e2tGJL\u0007\u000f^5p]R1!Q^B9\u0007gBaAa>L\u0001\u0004)\u0007b\u0002B~\u0017\u0002\u0007!Q`\u0001\u000fg\u0016tG-\u00168tk\n\u001c'/\u001b2f)\u0019\u0011io!\u001f\u0004|!1!q\u001f'A\u0002\u0015Dqa! M\u0001\u0004\u00199%A\u0004qe>l\u0017n]3")
public final class MqttClientImpl
implements MqttClient,
StrictLogging {
    private final Bootstrap bootstrap;
    private final Clock clock;
    private final MqttClientConfig clientConfig;
    private final EventLoop eventLoop;
    private final ConcurrentHashMap<Integer, MqttPendingUnsubscription> pendingServerUnsubscribes;
    private final IntObjectHashMap<MqttIncomingQos2Publish> qos2PendingIncomingPublishes;
    private final IntObjectHashMap<MqttPendingPublish> pendingPublishes;
    private final Map<String, MqttSubscription> subscriptions;
    private final IntObjectHashMap<MqttPendingSubscription> pendingSubscriptions;
    private int nextMessageId;
    private Channel channel;
    private long startConnectTimestamp;
    private int reconnectsAttempted;
    private Promise<MqttConnectReturnCode> connectFuture;
    private MqttConnectionListener connectionListener;
    private MqttTopicListener topicListener;
    private boolean disconnecting;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public MqttClientConfig clientConfig() {
        return this.clientConfig;
    }

    private EventLoop eventLoop() {
        return this.eventLoop;
    }

    public ConcurrentHashMap<Integer, MqttPendingUnsubscription> pendingServerUnsubscribes() {
        return this.pendingServerUnsubscribes;
    }

    public IntObjectHashMap<MqttIncomingQos2Publish> qos2PendingIncomingPublishes() {
        return this.qos2PendingIncomingPublishes;
    }

    public IntObjectHashMap<MqttPendingPublish> pendingPublishes() {
        return this.pendingPublishes;
    }

    public Map<String, MqttSubscription> subscriptions() {
        return this.subscriptions;
    }

    public IntObjectHashMap<MqttPendingSubscription> pendingSubscriptions() {
        return this.pendingSubscriptions;
    }

    private int nextMessageId() {
        return this.nextMessageId;
    }

    private void nextMessageId_$eq(int x$1) {
        this.nextMessageId = x$1;
    }

    public Channel channel() {
        return this.channel;
    }

    public void channel_$eq(Channel x$1) {
        this.channel = x$1;
    }

    public long startConnectTimestamp() {
        return this.startConnectTimestamp;
    }

    public void startConnectTimestamp_$eq(long x$1) {
        this.startConnectTimestamp = x$1;
    }

    @Override
    public int reconnectsAttempted() {
        return this.reconnectsAttempted;
    }

    public void reconnectsAttempted_$eq(int x$1) {
        this.reconnectsAttempted = x$1;
    }

    private Promise<MqttConnectReturnCode> connectFuture() {
        return this.connectFuture;
    }

    private void connectFuture_$eq(Promise<MqttConnectReturnCode> x$1) {
        this.connectFuture = x$1;
    }

    private MqttConnectionListener connectionListener() {
        return this.connectionListener;
    }

    private void connectionListener_$eq(MqttConnectionListener x$1) {
        this.connectionListener = x$1;
    }

    private MqttTopicListener topicListener() {
        return this.topicListener;
    }

    private void topicListener_$eq(MqttTopicListener x$1) {
        this.topicListener = x$1;
    }

    private boolean disconnecting() {
        return this.disconnecting;
    }

    private void disconnecting_$eq(boolean x$1) {
        this.disconnecting = x$1;
    }

    private void installMqttHandler(ChannelPipeline pipeline) {
        pipeline.addLast("mqttHandler", (ChannelHandler)new MqttChannelHandler(this, this.connectFuture(), this.connectionListener(), this.topicListener(), this.clock));
        pipeline.write(MqttChannelHandler$.MODULE$.SendConnectMessage());
    }

    private Future<MqttConnectReturnCode> connect() {
        this.startConnectTimestamp_$eq(this.clock.nowMillis());
        this.connectionListener().onTcpConnectAttempt();
        if (this.reconnectsAttempted() == Integer.MAX_VALUE) {
            this.reconnectsAttempted_$eq(0);
        }
        this.connectFuture_$eq((Promise<MqttConnectReturnCode>)new DefaultPromise((EventExecutor)this.eventLoop()));
        ChannelFuture whenChannelConnected = this.bootstrap.connect();
        NettyFutures$PimpedNettyFuture$.MODULE$.onComplete$extension(NettyFutures$.MODULE$.PimpedNettyFuture(whenChannelConnected), (Function1 & Serializable)x0$1 -> {
            MqttClientImpl.$anonfun$connect$1(this, whenChannelConnected, x0$1);
            return BoxedUnit.UNIT;
        });
        return this.connectFuture();
    }

    @Override
    public Future<MqttConnectReturnCode> connect(MqttConnectionListener connectionListener, MqttTopicListener topicListener) {
        this.connectionListener_$eq(connectionListener);
        this.topicListener_$eq(topicListener);
        return this.connect();
    }

    public void reconnect() {
        if (this.connectFuture().isDone()) {
            this.connectFuture_$eq((Promise<MqttConnectReturnCode>)new DefaultPromise((EventExecutor)this.eventLoop()));
        }
        if (this.clientConfig().reconnect() && !this.disconnecting()) {
            if (this.reconnectsAttempted() < this.clientConfig().maxReconnectAttempts()) {
                this.reconnectsAttempted_$eq(this.reconnectsAttempted() + 1);
                this.scheduleReconnect(this.computeReconnectDelay());
                return;
            }
            this.connectFuture().tryFailure((Throwable)MqttClientImpl$.MODULE$.io$gatling$mqtt$client$MqttClientImpl$$MaxReconnectException());
            return;
        }
    }

    private void scheduleReconnect(long reconnectDelay) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Schedule Reconnection attempt reconnectDelay={}", (Object)BoxesRunTime.boxToLong((long)reconnectDelay));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.eventLoop().schedule(() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Reconnection attempt");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.connect().addListener(f -> {
                if (!f.isSuccess()) {
                    this.reconnect();
                    return;
                }
            });
        }, reconnectDelay, TimeUnit.MILLISECONDS);
    }

    private long computeReconnectDelay() {
        long reconnectDelay = this.clientConfig().reconnectDelay();
        int end$macro$3 = this.reconnectsAttempted();
        for (int index$macro$2 = 0; index$macro$2 <= end$macro$3; ++index$macro$2) {
            reconnectDelay = (long)((float)reconnectDelay * this.clientConfig().reconnectBackoffMultiplier());
        }
        return reconnectDelay;
    }

    @Override
    public Future<Void> subscribe(String topic, MqttQoS qos) {
        return this.createSubscription(topic, qos);
    }

    @Override
    public Future<Void> unsubscribe(String topic) {
        DefaultPromise future = new DefaultPromise((EventExecutor)this.eventLoop());
        this.sendUnsubcribe(topic, (Promise<Void>)future);
        return future;
    }

    @Override
    public Future<Void> publish(String topic, ByteBuf payload) {
        return this.publish(topic, payload, MqttQoS.AT_MOST_ONCE, false);
    }

    @Override
    public Future<Void> publish(String topic, ByteBuf payload, MqttQoS qos) {
        return this.publish(topic, payload, qos, false);
    }

    @Override
    public Future<Void> publish(String topic, ByteBuf payload, boolean retain) {
        return this.publish(topic, payload, MqttQoS.AT_MOST_ONCE, retain);
    }

    private void publish0(MqttPublishMessage message, MqttPendingPublish pendingPublish, Promise<Void> future, EventLoop eventLoop) {
        if (this.channel().isActive()) {
            ChannelFuture whenWrite = this.sendAndFlushPacket((MqttMessage)message);
            if (whenWrite != null) {
                pendingPublish.sent_$eq(true);
                MqttQoS mqttQoS = pendingPublish.qos();
                if (MqttQoS.AT_MOST_ONCE.equals(mqttQoS)) {
                    NettyFutures$PimpedNettyFuture$.MODULE$.onComplete$extension(NettyFutures$.MODULE$.PimpedNettyFuture(whenWrite), (Function1 & Serializable)x0$1 -> {
                        MqttClientImpl.$anonfun$publish0$1(future, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                this.pendingPublishes().put(pendingPublish.messageId(), (Object)pendingPublish);
                pendingPublish.startPublishRetransmissionTimer(eventLoop);
                return;
            }
            pendingPublish.sent_$eq(false);
            pendingPublish.startPublishRetransmissionTimer(eventLoop);
            return;
        }
    }

    @Override
    public Future<Void> publish(String topic, ByteBuf payload, MqttQoS qos, boolean retain) {
        DefaultPromise future;
        block0: {
            future = new DefaultPromise((EventExecutor)this.eventLoop());
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, qos, retain, 0);
            MqttPublishVariableHeader variableHeader = new MqttPublishVariableHeader(topic, this.getNewMessageId().messageId());
            MqttPublishMessage message2 = new MqttPublishMessage(fixedHeader, variableHeader, payload);
            MqttPendingPublish pendingPublish = MqttPendingPublish$.MODULE$.apply(variableHeader.packetId(), (Promise<Void>)future, message2, qos, this.clientConfig().resendDelay(), this.clientConfig().resendBackoffMultiplier(), (Function1<MqttMessage, BoxedUnit>)(Function1 & Serializable)message -> {
                this.sendAndFlushPacket(message);
                return BoxedUnit.UNIT;
            });
            if (this.eventLoop().isShutdown()) break block0;
            this.publish0(message2, pendingPublish, (Promise<Void>)future, this.eventLoop());
        }
        return future;
    }

    @Override
    public void close() {
        if (!this.disconnecting()) {
            BoxedUnit boxedUnit;
            this.disconnecting_$eq(true);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Disconnecting");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.reconnectsAttempted_$eq(Integer.MAX_VALUE);
            Object object = this.channel().isActive() ? this.channel().writeAndFlush((Object)MqttClientImpl$.MODULE$.io$gatling$mqtt$client$MqttClientImpl$$DisconnectMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE) : BoxedUnit.UNIT;
            this.connectionListener().onDisconnected();
            if (this.clientConfig().cleanSession()) {
                CollectionConverters$.MODULE$.CollectionHasAsScala(this.pendingSubscriptions().values()).asScala().foreach((Function1 & Serializable)x$7 -> {
                    x$7.remove();
                    return BoxedUnit.UNIT;
                });
                this.pendingSubscriptions().clear();
                CollectionConverters$.MODULE$.CollectionHasAsScala(this.qos2PendingIncomingPublishes().values()).asScala().foreach((Function1 & Serializable)x$8 -> {
                    x$8.remove();
                    return BoxedUnit.UNIT;
                });
                this.qos2PendingIncomingPublishes().clear();
                CollectionConverters$.MODULE$.CollectionHasAsScala(this.pendingServerUnsubscribes().values()).asScala().foreach((Function1 & Serializable)x$9 -> {
                    x$9.remove();
                    return BoxedUnit.UNIT;
                });
                this.pendingServerUnsubscribes().clear();
            }
            CollectionConverters$.MODULE$.CollectionHasAsScala(this.pendingPublishes().values()).asScala().foreach((Function1 & Serializable)x$10 -> {
                x$10.remove();
                return BoxedUnit.UNIT;
            });
            this.pendingPublishes().clear();
            CollectionConverters$.MODULE$.CollectionHasAsScala(this.pendingSubscriptions().values()).asScala().foreach((Function1 & Serializable)x$11 -> {
                x$11.sent_$eq(false);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public ChannelFuture sendAndFlushPacket(MqttMessage message) {
        if (this.channel() == null) {
            return null;
        }
        if (!this.channel().isWritable()) {
            return this.channel().newFailedFuture((Throwable)MqttClientImpl$.MODULE$.io$gatling$mqtt$client$MqttClientImpl$$ChannelNotWritableException());
        }
        if (this.channel().isActive()) {
            return this.channel().writeAndFlush((Object)message);
        }
        return this.channel().newFailedFuture((Throwable)MqttClientImpl$.MODULE$.io$gatling$mqtt$client$MqttClientImpl$$ChannelClosedException());
    }

    private MqttMessageIdVariableHeader getNewMessageId() {
        if (this.nextMessageId() == Integer.MAX_VALUE) {
            this.nextMessageId_$eq(0);
        } else {
            this.nextMessageId_$eq(this.nextMessageId() + 1);
        }
        return MqttMessageIdVariableHeader.from((int)this.nextMessageId());
    }

    private Future<Void> createSubscription(String topic, MqttQoS qos) {
        Option option = CollectionConverters$.MODULE$.CollectionHasAsScala(this.pendingSubscriptions().values()).asScala().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MqttClientImpl.$anonfun$createSubscription$1(topic, x$12)));
        if (option instanceof Some) {
            Some some = (Some)option;
            MqttPendingSubscription pendingSubscription = (MqttPendingSubscription)some.value();
            return pendingSubscription.future();
        }
        MqttTopicSubscription subscription = new MqttTopicSubscription(topic, qos);
        MqttMessageIdVariableHeader variableHeader = this.getNewMessageId();
        MqttSubscribePayload payload = new MqttSubscribePayload(List.of(subscription));
        MqttSubscribeMessage message2 = new MqttSubscribeMessage(MqttClientImpl$.MODULE$.io$gatling$mqtt$client$MqttClientImpl$$SubscribeMessageHeader(), variableHeader, payload);
        DefaultPromise future = new DefaultPromise((EventExecutor)this.eventLoop());
        ScheduledFuture timeout = this.eventLoop().schedule(() -> {
            this.pendingSubscriptions().remove(variableHeader.messageId());
            future.tryFailure((Throwable)new TimeoutException("Subscribe timeout"));
            return this.channel().close();
        }, 3000L, TimeUnit.MILLISECONDS);
        MqttPendingSubscription pendingSubscription = MqttPendingSubscription$.MODULE$.apply((Promise<Void>)future, timeout, topic, message2, this.clientConfig().resendDelay(), this.clientConfig().resendBackoffMultiplier(), (Function1<MqttMessage, BoxedUnit>)(Function1 & Serializable)message -> {
            this.sendAndFlushPacket(message);
            return BoxedUnit.UNIT;
        });
        this.pendingSubscriptions().put(variableHeader.messageId(), (Object)pendingSubscription);
        pendingSubscription.sent_$eq(this.sendAndFlushPacket((MqttMessage)message2) != null);
        pendingSubscription.startRetransmitTimer(this.eventLoop());
        return future;
    }

    private Future<Void> sendUnsubcribe(String topic, Promise<Void> promise) {
        if (!this.subscriptions().containsKey(topic)) {
            MqttMessageIdVariableHeader variableHeader = this.getNewMessageId();
            MqttUnsubscribePayload payload = new MqttUnsubscribePayload(List.of(topic));
            MqttUnsubscribeMessage message2 = new MqttUnsubscribeMessage(MqttClientImpl$.MODULE$.io$gatling$mqtt$client$MqttClientImpl$$UnsubscribeMessageHeader(), variableHeader, payload);
            MqttPendingUnsubscription pendingUnsubscription = MqttPendingUnsubscription$.MODULE$.apply(promise, topic, message2, this.clientConfig().resendDelay(), this.clientConfig().resendBackoffMultiplier(), (Function1<MqttMessage, BoxedUnit>)(Function1 & Serializable)message -> {
                this.sendAndFlushPacket(message);
                return BoxedUnit.UNIT;
            });
            this.pendingServerUnsubscribes().put(Predef$.MODULE$.int2Integer(variableHeader.messageId()), pendingUnsubscription);
            pendingUnsubscription.startRetransmissionTimer(this.eventLoop());
            return this.sendAndFlushPacket((MqttMessage)message2);
        }
        promise.trySuccess(null);
        return promise;
    }

    public static final /* synthetic */ void $anonfun$connect$3(MqttClientImpl $this, ChannelPipeline pipeline$1, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("TLS handshake failure", t);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.connectionListener().onTlsHandshakeFailure(t);
            $this.connectionListener().onMqttConnectFailure(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE);
            return;
        }
        $this.connectionListener().onTlsHandshakeSuccess();
        $this.installMqttHandler(pipeline$1);
    }

    public static final /* synthetic */ void $anonfun$connect$1(MqttClientImpl $this, ChannelFuture whenChannelConnected$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            $this.connectionListener().onTcpConnectFailure(t);
            $this.connectionListener().onMqttConnectFailure(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE);
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("TCP connect failure", t);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.reconnect();
            return;
        }
        ChannelHandler statsHandler = (ChannelHandler)Option$.MODULE$.apply((Object)$this.connectionListener().channelStatsHandler()).getOrElse((Function0 & Serializable)() -> NoopHandler$.MODULE$);
        whenChannelConnected$1.channel().pipeline().addFirst(MqttClientImpl$.MODULE$.io$gatling$mqtt$client$MqttClientImpl$$StatsChannelHandlerName(), statsHandler);
        $this.connectionListener().onTcpConnectSuccess();
        Channel ch = whenChannelConnected$1.channel();
        ChannelPipeline pipeline = ch.pipeline();
        Option<SslHandler> option = $this.clientConfig().createSslHandler(ch.alloc());
        if (option instanceof Some) {
            Some some = (Some)option;
            SslHandler sslHandler = (SslHandler)some.value();
            pipeline.addAfter(MqttClientImpl$.MODULE$.io$gatling$mqtt$client$MqttClientImpl$$StatsChannelHandlerName(), "ssl", (ChannelHandler)sslHandler);
            $this.connectionListener().onTlsHandshakeAttempt();
            NettyFutures$PimpedNettyFuture$.MODULE$.onComplete$extension(NettyFutures$.MODULE$.PimpedNettyFuture(sslHandler.handshakeFuture()), (Function1 & Serializable)x0$2 -> {
                MqttClientImpl.$anonfun$connect$3($this, pipeline, x0$2);
                return BoxedUnit.UNIT;
            });
        } else {
            $this.installMqttHandler(pipeline);
        }
    }

    public static final /* synthetic */ void $anonfun$publish0$1(Promise future$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            future$1.tryFailure((Throwable)new Exception("Failed to publish QoS 0", t));
            return;
        }
        future$1.trySuccess(null);
    }

    public static final /* synthetic */ boolean $anonfun$createSubscription$1(String topic$1, MqttPendingSubscription x$12) {
        String string = x$12.topic();
        String string2 = topic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public MqttClientImpl(Bootstrap bootstrap, Clock clock, MqttClientConfig clientConfig) {
        this.bootstrap = bootstrap;
        this.clock = clock;
        this.clientConfig = clientConfig;
        StrictLogging.$init$((StrictLogging)this);
        this.eventLoop = bootstrap.config().group().next();
        this.pendingServerUnsubscribes = new ConcurrentHashMap();
        this.qos2PendingIncomingPublishes = new IntObjectHashMap();
        this.pendingPublishes = new IntObjectHashMap();
        this.subscriptions = new HashMap<String, MqttSubscription>();
        this.pendingSubscriptions = new IntObjectHashMap();
        this.nextMessageId = 0;
        this.reconnectsAttempted = 0;
        this.disconnecting = false;
        Statics.releaseFence();
    }
}

