/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.client;

import io.gatling.commons.model.Credentials;
import io.gatling.core.session.Session;
import io.gatling.mqtt.client.MqttClientConfig;
import io.gatling.mqtt.client.MqttLastWill;
import io.gatling.mqtt.protocol.MqttProtocol;
import io.gatling.mqtt.ssl.SslContextSupport$;
import io.gatling.shared.util.StringBuilderPool;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple17;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class MqttClientConfig$
implements Serializable {
    public static final MqttClientConfig$ MODULE$ = new MqttClientConfig$();
    private static final StringBuilderPool stringBuilderPool = new StringBuilderPool();
    private static final char[] randomClientIdChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();

    private StringBuilderPool stringBuilderPool() {
        return stringBuilderPool;
    }

    private char[] randomClientIdChars() {
        return randomClientIdChars;
    }

    private String randomClientId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String idRoot = "netty-io.gatling.mqtt/";
        StringBuilder sb = this.stringBuilderPool().get().append(idRoot);
        int limit$macro$4 = 8;
        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
            sb.append(this.randomClientIdChars()[random.nextInt(this.randomClientIdChars().length)]);
        }
        return sb.toString();
    }

    public String io$gatling$mqtt$client$MqttClientConfig$$domain(String hostname) {
        int fqdnLength = hostname.length() - 1;
        if (hostname.charAt(fqdnLength) == '.') {
            return hostname.substring(0, fqdnLength);
        }
        return hostname;
    }

    public MqttClientConfig apply(Option<String> clientId, Option<Credentials> credentials, int connectTimeoutMillis, int keepAliveSeconds, InetSocketAddress remoteAddress, boolean enableSni, long handshakeTimeoutMillis, Option<MqttLastWill> lastWill, Session session, MqttProtocol mqttProtocol) {
        return new MqttClientConfig(mqttProtocol.version(), credentials, (String)clientId.getOrElse((Function0 & Serializable)() -> MODULE$.randomClientId()), connectTimeoutMillis, keepAliveSeconds, mqttProtocol.cleanSession(), lastWill, remoteAddress, SslContextSupport$.MODULE$.sslContext(session), enableSni, handshakeTimeoutMillis, true, mqttProtocol.reconnect().reconnectAttemptsMax(), mqttProtocol.reconnect().reconnectDelay().toMillis(), mqttProtocol.reconnect().reconnectBackOffMultiplier(), mqttProtocol.resend().resendDelay().toMillis(), mqttProtocol.resend().resendBackoffMultiplier());
    }

    public MqttClientConfig apply(MqttVersion protocolVersion, Option<Credentials> credentials, String clientId, int connectTimeoutMillis, int keepAliveSeconds, boolean cleanSession, Option<MqttLastWill> lastWill, InetSocketAddress remoteAddress, Option<SslContext> sslContext, boolean enableSni, long handshakeTimeoutMillis, boolean reconnect, int maxReconnectAttempts, long reconnectDelay, float reconnectBackoffMultiplier, long resendDelay, float resendBackoffMultiplier) {
        return new MqttClientConfig(protocolVersion, credentials, clientId, connectTimeoutMillis, keepAliveSeconds, cleanSession, lastWill, remoteAddress, sslContext, enableSni, handshakeTimeoutMillis, reconnect, maxReconnectAttempts, reconnectDelay, reconnectBackoffMultiplier, resendDelay, resendBackoffMultiplier);
    }

    public Option<Tuple17<MqttVersion, Option<Credentials>, String, Object, Object, Object, Option<MqttLastWill>, InetSocketAddress, Option<SslContext>, Object, Object, Object, Object, Object, Object, Object, Object>> unapply(MqttClientConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple17((Object)x$0.protocolVersion(), x$0.credentials(), (Object)x$0.clientId(), (Object)BoxesRunTime.boxToInteger((int)x$0.connectTimeoutMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.keepAliveSeconds()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.cleanSession()), x$0.lastWill(), (Object)x$0.remoteAddress(), x$0.sslContext(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.enableSni()), (Object)BoxesRunTime.boxToLong((long)x$0.handshakeTimeoutMillis()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.reconnect()), (Object)BoxesRunTime.boxToInteger((int)x$0.maxReconnectAttempts()), (Object)BoxesRunTime.boxToLong((long)x$0.reconnectDelay()), (Object)BoxesRunTime.boxToFloat((float)x$0.reconnectBackoffMultiplier()), (Object)BoxesRunTime.boxToLong((long)x$0.resendDelay()), (Object)BoxesRunTime.boxToFloat((float)x$0.resendBackoffMultiplier())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MqttClientConfig$.class);
    }

    private MqttClientConfig$() {
    }
}

