/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.client;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.mqtt.client.MqttChannelHandler$;
import io.gatling.mqtt.client.MqttChannelHandler$MqttConnectTimeout$;
import io.gatling.mqtt.client.MqttClientConfig;
import io.gatling.mqtt.client.MqttClientImpl;
import io.gatling.mqtt.client.MqttConnectionListener;
import io.gatling.mqtt.client.MqttIncomingQos2Publish;
import io.gatling.mqtt.client.MqttIncomingQos2Publish$;
import io.gatling.mqtt.client.MqttPendingPublish;
import io.gatling.mqtt.client.MqttPendingSubscription;
import io.gatling.mqtt.client.MqttPendingUnsubscription;
import io.gatling.mqtt.client.MqttSubscription;
import io.gatling.mqtt.client.MqttTopicListener;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t}v!\u0002\u001b6\u0011\u0003qd!\u0002!6\u0011\u0003\t\u0005\"\u0002%\u0002\t\u0003I\u0005b\u0002&\u0002\u0005\u0004%\ta\u0013\u0005\u0007\u001f\u0006\u0001\u000b\u0011\u0002'\t\u000fA\u000b!\u0019!C\u0005#\"1Q+\u0001Q\u0001\nI;QaZ\u0001\t\n\"4QA[\u0001\t\n.DQ\u0001\u0013\u0005\u0005\u0002mDq\u0001 \u0005\u0002\u0002\u0013\u0005S\u0010C\u0005\u0002\n!\t\t\u0011\"\u0001\u0002\f!I\u00111\u0003\u0005\u0002\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u00037A\u0011\u0011!C!\u0003;A\u0011\"a\u000b\t\u0003\u0003%\t!!\f\t\u0013\u0005]\u0002\"!A\u0005B\u0005e\u0002\"CA\u001e\u0011\u0005\u0005I\u0011IA\u001f\u0011%\ty\u0004CA\u0001\n\u0013\t\t\u0005C\u0005\u0002J\u0005\u0011\r\u0011\"\u0003\u0002L!A\u0011\u0011L\u0001!\u0002\u0013\ti\u0005C\u0005\u0002\\\u0005\u0011\r\u0011\"\u0003\u0002^!A\u0011QO\u0001!\u0002\u0013\ty\u0006C\u0005\u0002x\u0005\u0011\r\u0011\"\u0003\u0002^!A\u0011\u0011P\u0001!\u0002\u0013\ty\u0006C\u0005\u0002|\u0005\u0011\r\u0011\"\u0003\u0002^!A\u0011QP\u0001!\u0002\u0013\tyFB\u0003Ak\t\ty\bC\u000575\t\u0005\t\u0015!\u0003\u0002\"\"Q\u0011q\u0015\u000e\u0003\u0002\u0003\u0006I!!+\t\u0015\u0005m&D!A!\u0002\u0013\ti\f\u0003\u0006\u0002Dj\u0011\t\u0011)A\u0005\u0003\u000bD!\"a3\u001b\u0005\u0003\u0005\u000b\u0011BAg\u0011\u0019A%\u0004\"\u0001\u0002\\\"9\u0011\u0011\u001e\u000e\u0005B\u0005-\bb\u0002B\u00015\u0011%!1\u0001\u0005\b\u0005\u001fQB\u0011\tB\t\u0011\u001d\u0011\tC\u0007C\u0005\u0005GA1Ba\u000b\u001b\u0001\u0004\u0005\r\u0011\"\u0003\u0003.!Y!\u0011\n\u000eA\u0002\u0003\u0007I\u0011\u0002B&\u0011-\u0011yD\u0007a\u0001\u0002\u0003\u0006KAa\f\t\u000f\t]#\u0004\"\u0003\u0003Z!9!Q\f\u000e\u0005B\t}\u0003b\u0002B45\u0011\u0005#\u0011\u000e\u0005\b\u0005[RB\u0011\u0002B8\u0011\u001d\u0011YH\u0007C\u0005\u0005{BqA!\"\u001b\t\u0013\u00119\tC\u0004\u0003\u000ej!IAa$\t\u000f\tU%\u0004\"\u0003\u0003\u0018\"9!1\u0014\u000e\u0005\n\tu\u0005b\u0002BQ5\u0011%!1\u0015\u0005\b\u0005cSB\u0011\u0002BZ\u0011\u001d\u0011IL\u0007C\u0005\u0005w\u000b!#T9ui\u000eC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe*\u0011agN\u0001\u0007G2LWM\u001c;\u000b\u0005aJ\u0014\u0001B7riRT!AO\u001e\u0002\u000f\u001d\fG\u000f\\5oO*\tA(\u0001\u0002j_\u000e\u0001\u0001CA \u0002\u001b\u0005)$AE'riR\u001c\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001c\"!\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta(\u0001\nTK:$7i\u001c8oK\u000e$X*Z:tC\u001e,W#\u0001'\u0011\u0005\rk\u0015B\u0001(E\u0005\r\te._\u0001\u0014'\u0016tGmQ8o]\u0016\u001cG/T3tg\u0006<W\rI\u0001\u0018\u0007>tg.Z2u)&lWm\\;u\u000bb\u001cW\r\u001d;j_:,\u0012A\u0015\n\u0004'Z\u0003g\u0001\u0002+\u0007\u0001I\u0013A\u0002\u0010:fM&tW-\\3oiz\n\u0001dQ8o]\u0016\u001cG\u000fV5nK>,H/\u0012=dKB$\u0018n\u001c8!!\t9f,D\u0001Y\u0015\tI&,\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0017/\u0002\tU$\u0018\u000e\u001c\u0006\u0002;\u0006!!.\u0019<b\u0013\ty\u0006L\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]B\u0011\u0011-Z\u0007\u0002E*\u00111\rZ\u0001\bG>tGO]8m\u0015\tYF)\u0003\u0002gE\naaj\\*uC\u000e\\GK]1dK\u0006\u0011R*\u001d;u\u0007>tg.Z2u)&lWm\\;u!\tI\u0007\"D\u0001\u0002\u0005Ii\u0015\u000f\u001e;D_:tWm\u0019;US6,w.\u001e;\u0014\t!\u0011En\u001c\t\u0003\u00076L!A\u001c#\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\u000f\u001f\b\u0003cZt!A];\u000e\u0003MT!\u0001^\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0015BA<E\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001f>\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005]$E#\u00015\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007a\u0016\u0001\u00027b]\u001eLA!a\u0002\u0002\u0002\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0004\u0011\u0007\r\u000by!C\u0002\u0002\u0012\u0011\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001TA\f\u0011%\tI\u0002DA\u0001\u0002\u0004\ti!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003?\u0001R!!\t\u0002(1k!!a\t\u000b\u0007\u0005\u0015B)\u0001\u0006d_2dWm\u0019;j_:LA!!\u000b\u0002$\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty#!\u000e\u0011\u0007\r\u000b\t$C\u0002\u00024\u0011\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u001a9\t\t\u00111\u0001M\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0007\u0003!!xn\u0015;sS:<G#\u0001@\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\r\u0003cA@\u0002F%!\u0011qIA\u0001\u0005\u0019y%M[3di\u0006QQ)\u001c9us\nKH/Z:\u0016\u0005\u00055\u0003#B\"\u0002P\u0005M\u0013bAA)\t\n)\u0011I\u001d:bsB\u00191)!\u0016\n\u0007\u0005]CI\u0001\u0003CsR,\u0017aC#naRL()\u001f;fg\u0002\nAcQ8o]\u0016\u001cG/T3tg\u0006<W\rS3bI\u0016\u0014XCAA0!\u0011\t\t'!\u001d\u000e\u0005\u0005\r$b\u0001\u001d\u0002f)!\u0011qMA5\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\tY'!\u001c\u0002\u000f!\fg\u000e\u001a7fe*\u0019\u0011qN\u001e\u0002\u000b9,G\u000f^=\n\t\u0005M\u00141\r\u0002\u0010\u001bF$HOR5yK\u0012DU-\u00193fe\u0006)2i\u001c8oK\u000e$X*Z:tC\u001e,\u0007*Z1eKJ\u0004\u0013a\u0005)vEJ+G.T3tg\u0006<W\rS3bI\u0016\u0014\u0018\u0001\u0006)vEJ+G.T3tg\u0006<W\rS3bI\u0016\u0014\b%\u0001\u000bQk\n\u001cu.\u001c9NKN\u001c\u0018mZ3IK\u0006$WM]\u0001\u0016!V\u00147i\\7q\u001b\u0016\u001c8/Y4f\u0011\u0016\fG-\u001a:!'\u0015Q\u0012\u0011QAG!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%\u0002BAD\u0003[\nqa\u00195b]:,G.\u0003\u0003\u0002\f\u0006\u0015%\u0001F\"iC:tW\r\u001c#va2,\u0007\u0010S1oI2,'\u000f\u0005\u0003\u0002\u0010\u0006uUBAAI\u0015\u0011\t\u0019*!&\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005]\u0015\u0011T\u0001\tif\u0004Xm]1gK*\u0011\u00111T\u0001\u0004G>l\u0017\u0002BAP\u0003#\u0013Qb\u0015;sS\u000e$Hj\\4hS:<\u0007cA \u0002$&\u0019\u0011QU\u001b\u0003\u001d5\u000bH\u000f^\"mS\u0016tG/S7qY\u0006i1m\u001c8oK\u000e$h)\u001e;ve\u0016\u0004b!a+\u00022\u0006UVBAAW\u0015\rI\u0016q\u0016\u0006\u00047\u00065\u0014\u0002BAZ\u0003[\u0013q\u0001\u0015:p[&\u001cX\r\u0005\u0003\u0002b\u0005]\u0016\u0002BA]\u0003G\u0012Q#T9ui\u000e{gN\\3diJ+G/\u001e:o\u0007>$W-\u0001\nd_:tWm\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\bcA \u0002@&\u0019\u0011\u0011Y\u001b\u0003-5\u000bH\u000f^\"p]:,7\r^5p]2K7\u000f^3oKJ\fQ\u0002^8qS\u000ed\u0015n\u001d;f]\u0016\u0014\bcA \u0002H&\u0019\u0011\u0011Z\u001b\u0003#5\u000bH\u000f\u001e+pa&\u001cG*[:uK:,'/A\u0003dY>\u001c7\u000e\u0005\u0003\u0002P\u0006]WBAAi\u0015\rY\u00161\u001b\u0006\u0004\u0003+L\u0014aB2p[6|gn]\u0005\u0005\u00033\f\tNA\u0003DY>\u001c7\u000e\u0006\u0007\u0002^\u0006}\u0017\u0011]Ar\u0003K\f9\u000f\u0005\u0002@5!1a\u0007\ta\u0001\u0003CCq!a*!\u0001\u0004\tI\u000bC\u0004\u0002<\u0002\u0002\r!!0\t\u000f\u0005\r\u0007\u00051\u0001\u0002F\"9\u00111\u001a\u0011A\u0002\u00055\u0017aC2iC:tW\r\u001c*fC\u0012$b!!<\u0002t\u0006u\bcA\"\u0002p&\u0019\u0011\u0011\u001f#\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003k\f\u0003\u0019AA|\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0007\u000bI0\u0003\u0003\u0002|\u0006\u0015%!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u007f\f\u0003\u0019\u0001'\u0002\u00075\u001cx-A\bsK\u0006$W*\u001d;u\u001b\u0016\u001c8/Y4f)\u0019\tiO!\u0002\u0003\b!9\u0011Q\u001f\u0012A\u0002\u0005]\bbBA\u0000E\u0001\u0007!\u0011\u0002\t\u0005\u0003C\u0012Y!\u0003\u0003\u0003\u000e\u0005\r$aC'riRlUm]:bO\u0016\fQa\u001e:ji\u0016$\u0002\"!<\u0003\u0014\tU!q\u0003\u0005\b\u0003k\u001c\u0003\u0019AA|\u0011\u0019\typ\ta\u0001\u0019\"9!\u0011D\u0012A\u0002\tm\u0011a\u00029s_6L7/\u001a\t\u0005\u0003\u0007\u0013i\"\u0003\u0003\u0003 \u0005\u0015%AD\"iC:tW\r\u001c)s_6L7/Z\u0001\u000fG>tg.Z2u\u001b\u0016\u001c8/Y4f+\t\u0011)\u0003\u0005\u0003\u0002b\t\u001d\u0012\u0002\u0002B\u0015\u0003G\u0012!#T9ui\u000e{gN\\3di6+7o]1hK\u000692o\u00195fIVdW\rZ\"p]:\f5m\u001b+j[\u0016|W\u000f^\u000b\u0003\u0005_\u0001DA!\r\u0003<A)qKa\r\u00038%\u0019!Q\u0007-\u0003\u001fM\u001b\u0007.\u001a3vY\u0016$g)\u001e;ve\u0016\u0004BA!\u000f\u0003<1\u0001Aa\u0003B\u001fO\u0005\u0005\t\u0011!B\u0001\u0005\u0003\u00121a\u0018\u00132\u0003a\u00198\r[3ek2,GmQ8o]\u0006\u001b7\u000eV5nK>,H\u000fI\t\u0004\u0005\u0007b\u0005cA\"\u0003F%\u0019!q\t#\u0003\u000f9{G\u000f[5oO\u0006Y2o\u00195fIVdW\rZ\"p]:\f5m\u001b+j[\u0016|W\u000f^0%KF$B!!<\u0003N!I\u0011\u0011\u0004\u0014\u0002\u0002\u0003\u0007!q\n\u0019\u0005\u0005#\u0012)\u0006E\u0003X\u0005g\u0011\u0019\u0006\u0005\u0003\u0003:\tUC\u0001\u0004B\u001f\u0005\u001b\n\t\u0011!A\u0003\u0002\t\u0005\u0013!\u00069fe\u001a|'/\\\"p]:,7\r\u001e+j[\u0016|W\u000f\u001e\u000b\u0005\u0003[\u0014Y\u0006C\u0004\u0002v\"\u0002\r!a>\u0002%U\u001cXM]#wK:$HK]5hO\u0016\u0014X\r\u001a\u000b\u0007\u0003[\u0014\tGa\u0019\t\u000f\u0005U\u0018\u00061\u0001\u0002x\"9!QM\u0015A\u0002\u0005\r\u0013aA3wi\u0006y1\r[1o]\u0016d\u0017J\\1di&4X\r\u0006\u0003\u0002n\n-\u0004bBA{U\u0001\u0007\u0011q_\u0001!S:4xn[3IC:$G.\u001a:t\r>\u0014\u0018J\\2p[&tw\rU;cY&\u001c\b\u000e\u0006\u0003\u0002n\nE\u0004b\u0002B:W\u0001\u0007!QO\u0001\b[\u0016\u001c8/Y4f!\u0011\t\tGa\u001e\n\t\te\u00141\r\u0002\u0013\u001bF$H\u000fU;cY&\u001c\b.T3tg\u0006<W-A\u0007iC:$G.Z\"p]:\f5m\u001b\u000b\u0007\u0003[\u0014yH!!\t\u000f\u0005UH\u00061\u0001\u0002x\"9!1\u0011\u0017A\u0002\u0005U\u0016A\u0003:fiV\u0014hnQ8eK\u0006a\u0001.\u00198eY\u0016\u001cVOY!dWR!\u0011Q\u001eBE\u0011\u001d\u0011Y)\fa\u0001\u0003\u001b\t\u0011\"\\3tg\u0006<W-\u00133\u0002)!\fg\u000e\u001a7f\u0013:\u0014w.\u001e8e!V\u0014G.[:i)\u0019\tiO!%\u0003\u0014\"9\u0011Q\u001f\u0018A\u0002\u0005]\bb\u0002B:]\u0001\u0007!QO\u0001\u000fQ\u0006tG\r\\3V]N,(-Y2l)\u0011\tiO!'\t\u000f\t-u\u00061\u0001\u0002\u000e\u0005a\u0001.\u00198eY\u0016\u0004VOY1dWR!\u0011Q\u001eBP\u0011\u001d\u0011Y\t\ra\u0001\u0003\u001b\tA\u0002[1oI2,\u0007+\u001e2sK\u000e$b!!<\u0003&\n\u001d\u0006bBA{c\u0001\u0007\u0011q\u001f\u0005\b\u0005S\u000b\u0004\u0019\u0001BV\u0003UiWm]:bO\u00164\u0016M]5bE2,\u0007*Z1eKJ\u0004B!!\u0019\u0003.&!!qVA2\u0005mi\u0015\u000f\u001e;NKN\u001c\u0018mZ3JIZ\u000b'/[1cY\u0016DU-\u00193fe\u0006a\u0001.\u00198eY\u0016\u0004VO\u0019:fYR1\u0011Q\u001eB[\u0005oCq!!>3\u0001\u0004\t9\u0010C\u0004\u0003\fJ\u0002\r!!\u0004\u0002\u001b!\fg\u000e\u001a7f!V\u00147m\\7q)\u0011\tiO!0\t\u000f\t-5\u00071\u0001\u0002\u000e\u0001")
public final class MqttChannelHandler
extends ChannelDuplexHandler
implements StrictLogging {
    private final MqttClientImpl client;
    private final Promise<MqttConnectReturnCode> connectFuture;
    private final MqttConnectionListener connectionListener;
    private final MqttTopicListener topicListener;
    private final Clock clock;
    private ScheduledFuture<?> scheduledConnAckTimeout;
    private Logger logger;

    public static Object SendConnectMessage() {
        return MqttChannelHandler$.MODULE$.SendConnectMessage();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof MqttMessage) {
            MqttMessage mqttMessage = (MqttMessage)object;
            try {
                BoxedUnit boxedUnit;
                if (mqttMessage.decoderResult().isFailure()) {
                    BoxedUnit boxedUnit2;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Decoder failure", mqttMessage.decoderResult().cause());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    ctx.close();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.readMqttMessage(ctx, mqttMessage);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                ReferenceCountUtil.release((Object)mqttMessage.payload());
            }
            return;
        }
        ctx.fireChannelRead(msg);
    }

    private void readMqttMessage(ChannelHandlerContext ctx, MqttMessage msg) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received {}", (Object)msg);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MqttMessageType mqttMessageType = msg.fixedHeader().messageType();
        if (MqttMessageType.CONNACK.equals(mqttMessageType)) {
            this.handleConnAck(ctx, ((MqttConnAckMessage)msg).variableHeader().connectReturnCode());
            return;
        }
        if (MqttMessageType.SUBACK.equals(mqttMessageType)) {
            this.handleSubAck(((MqttSubAckMessage)msg).variableHeader().messageId());
            return;
        }
        if (MqttMessageType.PUBLISH.equals(mqttMessageType)) {
            this.handleInboundPublish(ctx, (MqttPublishMessage)msg);
            return;
        }
        if (MqttMessageType.UNSUBACK.equals(mqttMessageType)) {
            this.handleUnsuback(((MqttUnsubAckMessage)msg).variableHeader().messageId());
            return;
        }
        if (MqttMessageType.PUBACK.equals(mqttMessageType)) {
            this.handlePuback(((MqttPubAckMessage)msg).variableHeader().messageId());
            return;
        }
        if (MqttMessageType.PUBREC.equals(mqttMessageType)) {
            this.handlePubrec(ctx, (MqttMessageIdVariableHeader)msg.variableHeader());
            return;
        }
        if (MqttMessageType.PUBREL.equals(mqttMessageType)) {
            this.handlePubrel(ctx, ((MqttMessageIdVariableHeader)msg.variableHeader()).messageId());
            return;
        }
        if (MqttMessageType.PUBCOMP.equals(mqttMessageType)) {
            this.handlePubcomp(((MqttMessageIdVariableHeader)msg.variableHeader()).messageId());
            return;
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Object object = msg;
        if (BoxesRunTime.equals((Object)MqttChannelHandler$.MODULE$.SendConnectMessage(), (Object)object)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Channel Active");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            int timeoutMillis = this.client.clientConfig().connectTimeoutMillis() - (int)(this.clock.nowMillis() - this.client.startConnectTimestamp());
            if (timeoutMillis > 0) {
                this.client.channel_$eq(ctx.channel());
                Object object2 = ctx.channel().isActive() ? ctx.writeAndFlush((Object)this.connectMessage(), ctx.voidPromise()) : BoxedUnit.UNIT;
                this.scheduledConnAckTimeout_$eq((ScheduledFuture<?>)ctx.channel().eventLoop().schedule(() -> ctx.fireUserEventTriggered((Object)MqttChannelHandler$MqttConnectTimeout$.MODULE$), (long)timeoutMillis, TimeUnit.MILLISECONDS));
                return;
            }
            this.performConnectTimeout(ctx);
            return;
        }
        if (ctx.channel().isActive()) {
            ctx.write(msg, promise);
            return;
        }
    }

    private MqttConnectMessage connectMessage() {
        MqttClientConfig config = this.client.clientConfig();
        MqttConnectVariableHeader variableHeader = new MqttConnectVariableHeader(config.protocolVersion().protocolName(), (int)config.protocolVersion().protocolLevel(), config.credentials().isDefined(), config.credentials().isDefined(), config.lastWill().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.retain())), ((MqttQoS)config.lastWill().map((Function1 & Serializable)x$2 -> x$2.qos()).getOrElse((Function0 & Serializable)() -> MqttQoS.AT_MOST_ONCE)).value(), config.lastWill().isDefined(), config.cleanSession(), config.keepAliveSeconds());
        MqttConnectPayload payload = new MqttConnectPayload(config.clientId(), (String)config.lastWill().map((Function1 & Serializable)x$3 -> x$3.topic()).getOrElse((Function0 & Serializable)() -> ""), (byte[])config.lastWill().map((Function1 & Serializable)x$4 -> x$4.message()).getOrElse((Function0 & Serializable)() -> MqttChannelHandler$.MODULE$.io$gatling$mqtt$client$MqttChannelHandler$$EmptyBytes()), (String)config.credentials().map((Function1 & Serializable)x$5 -> x$5.username()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (byte[])config.credentials().map((Function1 & Serializable)x$6 -> x$6.password().getBytes(StandardCharsets.UTF_8)).getOrElse((Function0 & Serializable)() -> MqttChannelHandler$.MODULE$.io$gatling$mqtt$client$MqttChannelHandler$$EmptyBytes()));
        return new MqttConnectMessage(MqttChannelHandler$.MODULE$.io$gatling$mqtt$client$MqttChannelHandler$$ConnectMessageHeader(), variableHeader, payload);
    }

    private ScheduledFuture<?> scheduledConnAckTimeout() {
        return this.scheduledConnAckTimeout;
    }

    private void scheduledConnAckTimeout_$eq(ScheduledFuture<?> x$1) {
        this.scheduledConnAckTimeout = x$1;
    }

    private void performConnectTimeout(ChannelHandlerContext ctx) {
        this.connectFuture.tryFailure((Throwable)MqttChannelHandler$.MODULE$.io$gatling$mqtt$client$MqttChannelHandler$$ConnectTimeoutException());
        this.connectionListener.onMqttConnectFailure(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Object object = evt;
        if (MqttChannelHandler$MqttConnectTimeout$.MODULE$.equals(object)) {
            if (!this.connectFuture.isDone()) {
                this.performConnectTimeout(ctx);
                return;
            }
            return;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        BoxedUnit boxedUnit;
        super.channelInactive(ctx);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Channel {} Inactive", (Object)ctx.channel().id());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.connectionListener.onDisconnected();
        this.client.reconnect();
    }

    private void invokeHandlersForIncomingPublish(MqttPublishMessage message) {
        this.topicListener.onMessageReceived(message);
    }

    private void handleConnAck(ChannelHandlerContext ctx, MqttConnectReturnCode returnCode) {
        if (!this.connectFuture.isDone()) {
            BoxedUnit boxedUnit;
            this.scheduledConnAckTimeout().cancel(true);
            this.connectFuture.trySuccess((Object)returnCode);
            MqttConnectReturnCode mqttConnectReturnCode = returnCode;
            if (MqttConnectReturnCode.CONNECTION_ACCEPTED.equals(mqttConnectReturnCode)) {
                this.client.reconnectsAttempted_$eq(0);
                this.connectionListener.onMqttConnectSuccess();
                CollectionConverters$.MODULE$.CollectionHasAsScala(this.client.pendingSubscriptions().values()).asScala().foreach((Function1 & Serializable)pendingSubscription -> {
                    MqttChannelHandler.$anonfun$handleConnAck$1(ctx, pendingSubscription);
                    return BoxedUnit.UNIT;
                });
                CollectionConverters$.MODULE$.CollectionHasAsScala(this.client.pendingPublishes().values()).asScala().foreach((Function1 & Serializable)publish -> {
                    if (!publish.sent()) {
                        Object object = ctx.channel().isActive() ? ctx.write((Object)publish.message(), ctx.voidPromise()) : BoxedUnit.UNIT;
                        publish.sent_$eq(true);
                        MqttQoS mqttQoS = publish.qos();
                        MqttQoS mqttQoS2 = MqttQoS.AT_MOST_ONCE;
                        if (!(mqttQoS != null ? !mqttQoS.equals(mqttQoS2) : mqttQoS2 != null)) {
                            publish.future().trySuccess(null);
                            return $this.client.pendingPublishes().remove(publish.messageId());
                        }
                        publish.startPublishRetransmissionTimer(ctx.channel().eventLoop());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                ctx.flush();
                return;
            }
            if (MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD.equals(mqttConnectReturnCode)) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Failed connecting: CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.client.reconnectsAttempted_$eq(Integer.MAX_VALUE);
                this.connectionListener.onMqttConnectFailure(returnCode);
                ctx.close();
                return;
            }
            if (MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED.equals(mqttConnectReturnCode)) {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Failed connecting: CONNECTION_REFUSED_IDENTIFIER_REJECTED");
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                this.client.reconnectsAttempted_$eq(Integer.MAX_VALUE);
                this.connectionListener.onMqttConnectFailure(returnCode);
                ctx.close();
                return;
            }
            if (MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED.equals(mqttConnectReturnCode)) {
                BoxedUnit boxedUnit4;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Failed connecting: CONNECTION_REFUSED_NOT_AUTHORIZED");
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                this.client.reconnectsAttempted_$eq(Integer.MAX_VALUE);
                this.connectionListener.onMqttConnectFailure(returnCode);
                ctx.close();
                return;
            }
            if (MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE.equals(mqttConnectReturnCode)) {
                BoxedUnit boxedUnit5;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Failed connecting: CONNECTION_REFUSED_SERVER_UNAVAILABLE");
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                this.connectionListener.onMqttConnectFailure(returnCode);
                ctx.close();
                return;
            }
            if (MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION.equals(mqttConnectReturnCode)) {
                BoxedUnit boxedUnit6;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Failed connecting: CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION");
                    boxedUnit6 = BoxedUnit.UNIT;
                } else {
                    boxedUnit6 = BoxedUnit.UNIT;
                }
                this.client.reconnectsAttempted_$eq(Integer.MAX_VALUE);
                this.connectionListener.onMqttConnectFailure(returnCode);
                ctx.close();
                return;
            }
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Failed connecting: Unrecognized return code, are you connecting to an MQTT server?");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.connectionListener.onMqttConnectFailure(returnCode);
            ctx.close();
            return;
        }
    }

    private void handleSubAck(int messageId) {
        MqttPendingSubscription pendingSubscription = (MqttPendingSubscription)this.client.pendingSubscriptions().get(messageId);
        if (pendingSubscription == null) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Failed subscribe (suback failed to process), no matching sub for this client");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        pendingSubscription.onSubackReceived();
        MqttSubscription subscription = new MqttSubscription(pendingSubscription.topic());
        this.client.subscriptions().put(pendingSubscription.topic(), subscription);
    }

    private void handleInboundPublish(ChannelHandlerContext ctx, MqttPublishMessage message2) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received inbound PUBLISH message: {} {}", new Object[]{message2, message2.payload()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MqttQoS mqttQoS = message2.fixedHeader().qosLevel();
        if (MqttQoS.AT_MOST_ONCE.equals(mqttQoS)) {
            this.invokeHandlersForIncomingPublish(message2);
            return;
        }
        if (MqttQoS.AT_LEAST_ONCE.equals(mqttQoS)) {
            this.invokeHandlersForIncomingPublish(message2);
            if (message2.variableHeader().packetId() != -1) {
                MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
                MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)message2.variableHeader().packetId());
                if (ctx.channel().isActive()) {
                    ctx.writeAndFlush((Object)new MqttPubAckMessage(fixedHeader, variableHeader), ctx.voidPromise());
                    return;
                }
                return;
            }
            return;
        }
        if (MqttQoS.EXACTLY_ONCE.equals(mqttQoS)) {
            if (message2.variableHeader().packetId() != -1) {
                MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREC, false, MqttQoS.AT_MOST_ONCE, false, 0);
                MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)message2.variableHeader().packetId());
                MqttMessage pubrecMessage = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
                MqttIncomingQos2Publish incomingQos2Publish = MqttIncomingQos2Publish$.MODULE$.apply(message2, pubrecMessage, this.client.clientConfig().resendDelay(), 2.0f, (Function1<MqttMessage, BoxedUnit>)(Function1 & Serializable)message -> {
                    this.client.sendAndFlushPacket(message);
                    return BoxedUnit.UNIT;
                });
                this.client.qos2PendingIncomingPublishes().put(message2.variableHeader().packetId(), (Object)incomingQos2Publish);
                incomingQos2Publish.startPubrecRetransmitTimer(ctx.channel().eventLoop());
                if (ctx.channel().isActive()) {
                    ctx.writeAndFlush((Object)pubrecMessage, ctx.voidPromise());
                    return;
                }
                return;
            }
            return;
        }
        if (MqttQoS.FAILURE.equals(mqttQoS)) {
            return;
        }
        throw new MatchError((Object)mqttQoS);
    }

    private void handleUnsuback(int messageId) {
        MqttPendingUnsubscription unsubscription = this.client.pendingServerUnsubscribes().get(BoxesRunTime.boxToInteger((int)messageId));
        if (unsubscription != null) {
            unsubscription.onUnsubackReceived();
            this.client.subscriptions().remove(unsubscription.topic());
            Object object = !unsubscription.future().isDone() ? BoxesRunTime.boxToBoolean((boolean)unsubscription.future().trySuccess(null)) : BoxedUnit.UNIT;
            this.client.pendingServerUnsubscribes().remove(BoxesRunTime.boxToInteger((int)messageId));
            this.client.pendingSubscriptions().remove(messageId);
            return;
        }
    }

    private void handlePuback(int messageId) {
        MqttPendingPublish pendingPublish = (MqttPendingPublish)this.client.pendingPublishes().get(messageId);
        if (pendingPublish == null) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Received unknown or duplicate puback, messageId: {}, client {}", new Object[]{BoxesRunTime.boxToInteger((int)messageId), this.client.clientConfig().clientId()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        pendingPublish.onPubackReceived();
        this.client.pendingPublishes().remove(messageId);
    }

    private void handlePubrec(ChannelHandlerContext ctx, MqttMessageIdVariableHeader messageVariableHeader) {
        MqttPendingPublish pendingPublish = (MqttPendingPublish)this.client.pendingPublishes().get(messageVariableHeader.messageId());
        pendingPublish.onPubackReceived();
        MqttMessage pubrelMessage = MqttMessageFactory.newMessage((MqttFixedHeader)MqttChannelHandler$.MODULE$.io$gatling$mqtt$client$MqttChannelHandler$$PubRelMessageHeader(), (Object)messageVariableHeader, null);
        Object object = ctx.channel().isActive() ? ctx.writeAndFlush((Object)pubrelMessage, ctx.voidPromise()) : BoxedUnit.UNIT;
        pendingPublish.startPubrelRetransmissionTimer(ctx.channel().eventLoop());
    }

    private void handlePubrel(ChannelHandlerContext ctx, int messageId) {
        Object object;
        MqttIncomingQos2Publish incomingQos2Publish = (MqttIncomingQos2Publish)this.client.qos2PendingIncomingPublishes().get(messageId);
        if (incomingQos2Publish != null) {
            this.invokeHandlersForIncomingPublish(incomingQos2Publish.incomingPublish());
            incomingQos2Publish.onPubrelReceived();
            object = this.client.qos2PendingIncomingPublishes().remove(incomingQos2Publish.incomingPublish().variableHeader().packetId());
        } else {
            object = BoxedUnit.UNIT;
        }
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)messageId);
        if (ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)MqttMessageFactory.newMessage((MqttFixedHeader)MqttChannelHandler$.MODULE$.io$gatling$mqtt$client$MqttChannelHandler$$PubCompMessageHeader(), (Object)variableHeader, null), ctx.voidPromise());
            return;
        }
    }

    private void handlePubcomp(int messageId) {
        MqttPendingPublish pendingPublish = (MqttPendingPublish)this.client.pendingPublishes().get(messageId);
        Object object = !pendingPublish.future().isDone() ? BoxesRunTime.boxToBoolean((boolean)pendingPublish.future().trySuccess(null)) : BoxedUnit.UNIT;
        this.client.pendingPublishes().remove(messageId);
        pendingPublish.onPubcompReceived();
    }

    public static final /* synthetic */ void $anonfun$handleConnAck$1(ChannelHandlerContext ctx$2, MqttPendingSubscription pendingSubscription) {
        if (!pendingSubscription.sent()) {
            Object object = ctx$2.channel().isActive() ? ctx$2.write((Object)pendingSubscription.subscribeMessage(), ctx$2.voidPromise()) : BoxedUnit.UNIT;
            pendingSubscription.sent_$eq(true);
            pendingSubscription.startRetransmitTimer(ctx$2.channel().eventLoop());
            return;
        }
    }

    public MqttChannelHandler(MqttClientImpl client, Promise<MqttConnectReturnCode> connectFuture, MqttConnectionListener connectionListener, MqttTopicListener topicListener, Clock clock) {
        this.client = client;
        this.connectFuture = connectFuture;
        this.connectionListener = connectionListener;
        this.topicListener = topicListener;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

