/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.action;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.core.CoreComponents;
import io.gatling.core.action.Action;
import io.gatling.core.action.RequestAction;
import io.gatling.core.check.Check;
import io.gatling.core.session.Session;
import io.gatling.mqtt.action.MqttAction;
import io.gatling.mqtt.action.MqttPayload;
import io.gatling.mqtt.check.MqttExpectation;
import io.gatling.mqtt.client.MqttClient;
import io.gatling.mqtt.client.MqttTopicListener;
import io.gatling.mqtt.client.NettyFutures$;
import io.gatling.mqtt.client.NettyFutures$PimpedNettyFuture$;
import io.gatling.mqtt.enterprise.MqttStatsEngineAdapter;
import io.gatling.mqtt.enterprise.MqttStatsEngineAdapterFactory$;
import io.gatling.mqtt.protocol.MqttClientInstance;
import io.gatling.mqtt.protocol.MqttClientInstance$;
import io.gatling.mqtt.protocol.MqttComponents;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\u000b\u0016\u0005yA\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005Y!A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!9\u0006A!A!\u0002\u0013a\u0003\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011u\u0003!\u0011!Q\u0001\nyC\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\t]\u0002\u0011\t\u0011)A\u0005_\"A\u0001\u0010\u0001BC\u0002\u0013\u0005\u0011\u0010\u0003\u0005~\u0001\t\u0005\t\u0015!\u0003{\u0011\u0015q\b\u0001\"\u0001\u0000\u0011%\t)\u0002\u0001b\u0001\n\u0003\n9\u0002C\u0004\u0002\u001a\u0001\u0001\u000b\u0011\u0002!\t\u0013\u0005m\u0001A1A\u0005B\u0005u\u0001\u0002CA\u0018\u0001\u0001\u0006I!a\b\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0002\u0002CA!\u0001\u0001\u0006I!!\u000e\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F\t9\u0001+\u001e2mSND'B\u0001\f\u0018\u0003\u0019\t7\r^5p]*\u0011\u0001$G\u0001\u0005[F$HO\u0003\u0002\u001b7\u00059q-\u0019;mS:<'\"\u0001\u000f\u0002\u0005%|7\u0001A\n\u0004\u0001}\u0019\u0003C\u0001\u0011\"\u001b\u0005)\u0012B\u0001\u0012\u0016\u0005)i\u0015\u000f\u001e;BGRLwN\u001c\t\u0003I!j\u0011!\n\u0006\u0003-\u0019R!aJ\r\u0002\t\r|'/Z\u0005\u0003S\u0015\u0012QBU3rk\u0016\u001cH/Q2uS>t\u0017a\u0003:fcV,7\u000f\u001e(b[\u0016,\u0012\u0001\f\t\u0004[u\u0002eB\u0001\u0018;\u001d\ty\u0003H\u0004\u00021o9\u0011\u0011G\u000e\b\u0003eUj\u0011a\r\u0006\u0003iu\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005iY\u0012BA\u0014\u001a\u0013\tId%A\u0004tKN\u001c\u0018n\u001c8\n\u0005mb\u0014a\u00029bG.\fw-\u001a\u0006\u0003s\u0019J!AP \u0003\u0015\u0015C\bO]3tg&|gN\u0003\u0002<yA\u0011\u0011i\u0012\b\u0003\u0005\u0016\u0003\"AM\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\r\u000e\u000bAB]3rk\u0016\u001cHOT1nK\u0002\na\"\\9ui\u000e{W\u000e]8oK:$8\u000f\u0005\u0002N!6\taJ\u0003\u0002P/\u0005A\u0001O]8u_\u000e|G.\u0003\u0002R\u001d\nqQ*\u001d;u\u0007>l\u0007o\u001c8f]R\u001c\u0018AD2pe\u0016\u001cu.\u001c9p]\u0016tGo\u001d\t\u0003)Vk\u0011AJ\u0005\u0003-\u001a\u0012abQ8sK\u000e{W\u000e]8oK:$8/A\u0003u_BL7-A\u0004qCfdw.\u00193\u0011\u00075j$\f\u0005\u0002!7&\u0011A,\u0006\u0002\f\u001bF$H\u000fU1zY>\fG-A\u0002r_N\u0004\"aX4\u000e\u0003\u0001T!\u0001G1\u000b\u0005\t\u001c\u0017!B2pI\u0016\u001c'B\u00013f\u0003\u001dA\u0017M\u001c3mKJT!AZ\u000e\u0002\u000b9,G\u000f^=\n\u0005!\u0004'aB'riR\fvnU\u0001\u0007e\u0016$\u0018-\u001b8\u0011\u0005-dW\"A\"\n\u00055\u001c%a\u0002\"p_2,\u0017M\\\u0001\u0011[\u0006L(-Z#ya\u0016\u001cG/\u0019;j_:\u00042a\u001b9s\u0013\t\t8I\u0001\u0004PaRLwN\u001c\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k^\tQa\u00195fG.L!a\u001e;\u0003\u001f5\u000bH\u000f^#ya\u0016\u001cG/\u0019;j_:\fAA\\3yiV\t!\u0010\u0005\u0002%w&\u0011A0\n\u0002\u0007\u0003\u000e$\u0018n\u001c8\u0002\u000b9,\u0007\u0010\u001e\u0011\u0002\rqJg.\u001b;?)Q\t\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014A\u0011\u0001\u0005\u0001\u0005\u0006U1\u0001\r\u0001\f\u0005\u0006\u00172\u0001\r\u0001\u0014\u0005\u0006%2\u0001\ra\u0015\u0005\u0006/2\u0001\r\u0001\f\u0005\u000612\u0001\r!\u0017\u0005\u0006;2\u0001\rA\u0018\u0005\u0006S2\u0001\rA\u001b\u0005\u0006]2\u0001\ra\u001c\u0005\u0006q2\u0001\rA_\u0001\u0005]\u0006lW-F\u0001A\u0003\u0015q\u0017-\\3!\u0003\u0015\u0019Gn\\2l+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0003SI\u0012aB2p[6|gn]\u0005\u0005\u0003[\t\u0019CA\u0003DY>\u001c7.\u0001\u0004dY>\u001c7\u000eI\u0001\u0013gR\fGo]#oO&tW-\u00113baR,'/\u0006\u0002\u00026A!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<]\t!\"\u001a8uKJ\u0004(/[:f\u0013\u0011\ty$!\u000f\u0003-5\u000bH\u000f^*uCR\u001cXI\\4j]\u0016\fE-\u00199uKJ\f1c\u001d;biN,enZ5oK\u0006#\u0017\r\u001d;fe\u0002\n1b]3oIJ+\u0017/^3tiR!\u0011qIA-!\u0019\tI%a\u0014\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\n9#\u0001\u0006wC2LG-\u0019;j_:LA!!\u0015\u0002L\tQa+\u00197jI\u0006$\u0018n\u001c8\u0011\u0007-\f)&C\u0002\u0002X\r\u0013A!\u00168ji\"1\u0011h\u0005a\u0001\u00037\u0002B!!\u0018\u0002`5\tA(C\u0002\u0002bq\u0012qaU3tg&|g\u000e")
public final class Publish
extends MqttAction
implements RequestAction {
    private final Function1<Session, Validation<String>> requestName;
    private final Function1<Session, Validation<String>> topic;
    private final Function1<Session, Validation<MqttPayload>> payload;
    private final MqttQoS qos;
    private final boolean retain;
    private final Option<MqttExpectation> maybeExpectation;
    private final Action next;
    private final String name;
    private final Clock clock;
    private final MqttStatsEngineAdapter statsEngineAdapter;

    public void execute(Session session) {
        RequestAction.execute$((RequestAction)this, (Session)session);
    }

    public Function1<Session, Validation<String>> requestName() {
        return this.requestName;
    }

    public Action next() {
        return this.next;
    }

    public String name() {
        return this.name;
    }

    public Clock clock() {
        return this.clock;
    }

    private MqttStatsEngineAdapter statsEngineAdapter() {
        return this.statsEngineAdapter;
    }

    public Validation<BoxedUnit> sendRequest(Session session) {
        return ((Validation)this.requestName().apply((Object)session)).flatMap((Function1 & Serializable)reqName -> MqttClientInstance$.MODULE$.getClient(session).flatMap((Function1 & Serializable)x$3 -> {
            MqttClientInstance mqttClientInstance = x$3;
            if (mqttClientInstance != null) {
                MqttClient client = mqttClientInstance.client();
                long clientId = mqttClientInstance.id();
                MqttTopicListener listener = mqttClientInstance.messageListener();
                return ((Validation)$this.topic.apply((Object)session)).flatMap((Function1 & Serializable)resolvedTopic -> ((Validation)$this.payload.apply((Object)session)).flatMap((Function1 & Serializable)resolvedPayload -> ((Validation)$this.maybeExpectation.flatMap((Function1 & Serializable)x$1 -> x$1.topic()).map((Function1 & Serializable)x$2 -> (Validation)x$2.apply((Object)session)).getOrElse((Function0 & Serializable)() -> package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper(resolvedTopic)))).flatMap((Function1 & Serializable)resolvedExpectationTopic -> this.resolveCorrelationId((MqttPayload)resolvedPayload, session).map((Function1 & Serializable)maybeCorrelationId -> {
                    Publish.$anonfun$sendRequest$9(this, clientId, reqName, resolvedTopic, resolvedPayload, session, client, listener, resolvedExpectationTopic, maybeCorrelationId);
                    return BoxedUnit.UNIT;
                }))));
            }
            throw new MatchError((Object)mqttClientInstance);
        }));
    }

    public static final /* synthetic */ void $anonfun$sendRequest$10(Publish $this, long clientId$1, String resolvedTopic$1, Session session$1, String reqName$1, long requestStartDate$1, MqttTopicListener listener$1, String resolvedExpectationTopic$1, Option maybeCorrelationId$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(clientId$1 + ": Failed to publish on " + resolvedTopic$1, t);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.statsEngineAdapter().logResponseOnly(session$1.scenario(), (List<String>)session$1.groups(), reqName$1, requestStartDate$1, $this.clock().nowMillis(), (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)("Failed to publish: " + Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(t)))));
            $this.next().$bang(session$1.markAsFailed());
            return;
        }
        Option<MqttExpectation> option = $this.maybeExpectation;
        if (option instanceof Some) {
            Some some = (Some)option;
            MqttExpectation expectation = (MqttExpectation)some.value();
            long now = $this.clock().nowMillis();
            long remainingBeforeTimeout = expectation.timeout().toMillis() + requestStartDate$1 - now;
            if (remainingBeforeTimeout >= 0L) {
                FiniteDuration x$1 = new package.DurationLong(package$.MODULE$.DurationLong(remainingBeforeTimeout)).millis();
                List<Check<ByteBuf>> x$2 = expectation.copy$default$1();
                Option<Function1<Session, Validation<String>>> x$3 = expectation.copy$default$3();
                boolean x$4 = expectation.copy$default$4();
                listener$1.onWaitForMessage(resolvedExpectationTopic$1, (Option<String>)maybeCorrelationId$1, reqName$1, now, session$1, $this.next(), expectation.copy(x$2, x$1, x$3, x$4));
                if (!expectation.blocking()) {
                    $this.next().$bang(session$1);
                }
            } else {
                $this.statsEngineAdapter().logResponseOnly(session$1.scenario(), (List<String>)session$1.groups(), reqName$1, requestStartDate$1, now, (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"Expectation timeout on Publish"));
                $this.next().$bang(session$1.markAsFailed());
            }
        } else {
            $this.statsEngineAdapter().logResponseOnly(session$1.scenario(), (List<String>)session$1.groups(), reqName$1, requestStartDate$1, $this.clock().nowMillis(), (Status)OK$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.next().$bang(session$1);
        }
    }

    public static final /* synthetic */ void $anonfun$sendRequest$9(Publish $this, long clientId$1, String reqName$1, String resolvedTopic$1, MqttPayload resolvedPayload$1, Session session$1, MqttClient client$1, MqttTopicListener listener$1, String resolvedExpectationTopic$1, Option maybeCorrelationId) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("{}: Publish {}:{} Payload: {}", new Object[]{BoxesRunTime.boxToLong((long)clientId$1), reqName$1, resolvedTopic$1, resolvedPayload$1});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long requestStartDate = $this.clock().nowMillis();
        $this.statsEngineAdapter().logRequest(session$1.scenario(), (List<String>)session$1.groups(), reqName$1, requestStartDate, true);
        NettyFutures$PimpedNettyFuture$.MODULE$.onComplete$extension(NettyFutures$.MODULE$.PimpedNettyFuture(client$1.publish(resolvedTopic$1, resolvedPayload$1.buffer(), $this.qos, $this.retain)), (Function1 & Serializable)x0$1 -> {
            Publish.$anonfun$sendRequest$10($this, clientId$1, resolvedTopic$1, session$1, reqName$1, requestStartDate, listener$1, resolvedExpectationTopic$1, maybeCorrelationId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Publish(Function1<Session, Validation<String>> requestName, MqttComponents mqttComponents, CoreComponents coreComponents, Function1<Session, Validation<String>> topic, Function1<Session, Validation<MqttPayload>> payload, MqttQoS qos, boolean retain, Option<MqttExpectation> maybeExpectation, Action next) {
        this.requestName = requestName;
        this.topic = topic;
        this.payload = payload;
        this.qos = qos;
        this.retain = retain;
        this.maybeExpectation = maybeExpectation;
        this.next = next;
        super(mqttComponents, coreComponents);
        RequestAction.$init$((RequestAction)this);
        this.name = this.genName("mqttPublish");
        this.clock = coreComponents.clock();
        this.statsEngineAdapter = MqttStatsEngineAdapterFactory$.MODULE$.apply(this.statsEngine());
    }
}

