/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mqtt.action;

import io.gatling.commons.model.Credentials;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.core.CoreComponents;
import io.gatling.core.action.Action;
import io.gatling.core.action.RequestAction;
import io.gatling.core.session.Session;
import io.gatling.core.session.package$;
import io.gatling.mqtt.action.Connect$;
import io.gatling.mqtt.action.MqttAction;
import io.gatling.mqtt.action.MqttConnectionListenerImpl;
import io.gatling.mqtt.action.MqttTopicListenerImpl;
import io.gatling.mqtt.client.MqttChannelInitializer;
import io.gatling.mqtt.client.MqttClientConfig;
import io.gatling.mqtt.client.MqttClientConfig$;
import io.gatling.mqtt.client.MqttClientImpl;
import io.gatling.mqtt.client.MqttLastWill;
import io.gatling.mqtt.enterprise.MqttStatsEngineAdapter;
import io.gatling.mqtt.enterprise.MqttStatsEngineAdapterFactory$;
import io.gatling.mqtt.protocol.MqttClientInstance;
import io.gatling.mqtt.protocol.MqttClientInstance$;
import io.gatling.mqtt.protocol.MqttComponents;
import io.gatling.netty.util.Transports;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\ter!\u0002\u0016,\u0011\u0003!d!\u0002\u001c,\u0011\u00039\u0004\"\u0002 \u0002\t\u0003y\u0004b\u0002!\u0002\u0005\u0004%I!\u0011\u0005\u0007\u0015\u0006\u0001\u000b\u0011\u0002\"\u0007\tYZ\u0003a\u0013\u0005\t-\u0016\u0011)\u0019!C\u0001/\"AA/\u0002B\u0001B\u0003%\u0001\f\u0003\u0005v\u000b\t\u0005\t\u0015!\u0003w\u0011!aXA!A!\u0002\u0013i\bBCA\u0002\u000b\t\u0015\r\u0011\"\u0001\u0002\u0006!Q\u0011QB\u0003\u0003\u0002\u0003\u0006I!a\u0002\t\ry*A\u0011AA\b\u0011%\tY\"\u0002b\u0001\n\u0003\ni\u0002C\u0004\u0002 \u0015\u0001\u000b\u0011\u00027\t\u0013\u0005\u0005RA1A\u0005B\u0005\r\u0002\u0002CA\u0019\u000b\u0001\u0006I!!\n\t\u0013\u0005MRA1A\u0005\n\u0005U\u0002\u0002CA$\u000b\u0001\u0006I!a\u000e\t\u0013\u0005%SA1A\u0005\n\u0005-\u0003\u0002CA*\u000b\u0001\u0006I!!\u0014\t\u0013\u0005USA1A\u0005\n\u0005]\u0003\u0002CA0\u000b\u0001\u0006I!!\u0017\t\u0013\u0005\u0005TA1A\u0005\n\u0005-\u0003\u0002CA2\u000b\u0001\u0006I!!\u0014\t\u0013\u0005\u0015TA1A\u0005\n\u0005-\u0003\u0002CA4\u000b\u0001\u0006I!!\u0014\t\u0013\u0005%TA1A\u0005\n\u0005-\u0004\u0002CAF\u000b\u0001\u0006I!!\u001c\t\u0013\u00055UA1A\u0005\n\u0005=\u0005\u0002CAT\u000b\u0001\u0006I!!%\t\u0013\u0005uVA1A\u0005\n\u0005}\u0006\u0002CAg\u000b\u0001\u0006I!!1\t\u0013\u0005=WA1A\u0005\n\u0005E\u0007\u0002CAp\u000b\u0001\u0006I!a5\t\u000f\u0005\u0015U\u0001\"\u0003\u0002b\"I\u0011Q^\u0003C\u0002\u0013%\u0011q\u001e\u0005\t\u0003\u007f,\u0001\u0015!\u0003\u0002r\"9!\u0011A\u0003\u0005\n\t\r\u0001b\u0002B\u000e\u000b\u0011%!Q\u0004\u0005\b\u0005S)A\u0011\u0002B\u0016\u0011\u001d\u0011\u0019$\u0002C!\u0005k\tqaQ8o]\u0016\u001cGO\u0003\u0002-[\u00051\u0011m\u0019;j_:T!AL\u0018\u0002\t5\fH\u000f\u001e\u0006\u0003aE\nqaZ1uY&twMC\u00013\u0003\tIwn\u0001\u0001\u0011\u0005U\nQ\"A\u0016\u0003\u000f\r{gN\\3diN\u0011\u0011\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0014aF!me\u0016\fG-_\"p]:,7\r^3e\r\u0006LG.\u001e:f+\u0005\u0011\u0005CA\"I\u001b\u0005!%BA#G\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u000f>\nqaY8n[>t7/\u0003\u0002J\t\n9a)Y5mkJ,\u0017\u0001G!me\u0016\fG-_\"p]:,7\r^3e\r\u0006LG.\u001e:fAM\u0019Q\u0001T(\u0011\u0005Uj\u0015B\u0001(,\u0005)i\u0015\u000f\u001e;BGRLwN\u001c\t\u0003!Rk\u0011!\u0015\u0006\u0003YIS!aU\u0018\u0002\t\r|'/Z\u0005\u0003+F\u0013QBU3rk\u0016\u001cH/Q2uS>t\u0017a\u0003:fcV,7\u000f\u001e(b[\u0016,\u0012\u0001\u0017\t\u00043&dgB\u0001.g\u001d\tYFM\u0004\u0002]G:\u0011QL\u0019\b\u0003=\u0006l\u0011a\u0018\u0006\u0003AN\na\u0001\u0010:p_Rt\u0014\"\u0001\u001a\n\u0005A\n\u0014BA*0\u0013\t)'+A\u0004tKN\u001c\u0018n\u001c8\n\u0005\u001dD\u0017a\u00029bG.\fw-\u001a\u0006\u0003KJK!A[6\u0003\u0015\u0015C\bO]3tg&|gN\u0003\u0002hQB\u0011Q.\u001d\b\u0003]>\u0004\"A\u0018\u001e\n\u0005AT\u0014A\u0002)sK\u0012,g-\u0003\u0002sg\n11\u000b\u001e:j]\u001eT!\u0001\u001d\u001e\u0002\u0019I,\u0017/^3ti:\u000bW.\u001a\u0011\u0002\u001d5\fH\u000f^\"p[B|g.\u001a8ugB\u0011qO_\u0007\u0002q*\u0011\u00110L\u0001\taJ|Go\\2pY&\u00111\u0010\u001f\u0002\u000f\u001bF$HoQ8na>tWM\u001c;t\u00039\u0019wN]3D_6\u0004xN\\3oiN\u0004\"A`@\u000e\u0003IK1!!\u0001S\u00059\u0019uN]3D_6\u0004xN\\3oiN\fAA\\3yiV\u0011\u0011q\u0001\t\u0004!\u0006%\u0011bAA\u0006#\n1\u0011i\u0019;j_:\fQA\\3yi\u0002\"\"\"!\u0005\u0002\u0014\u0005U\u0011qCA\r!\t)T\u0001C\u0003W\u0019\u0001\u0007\u0001\fC\u0003v\u0019\u0001\u0007a\u000fC\u0003}\u0019\u0001\u0007Q\u0010C\u0004\u0002\u00041\u0001\r!a\u0002\u0002\t9\fW.Z\u000b\u0002Y\u0006)a.Y7fA\u0005)1\r\\8dWV\u0011\u0011Q\u0005\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111\u0006$\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003_\tICA\u0003DY>\u001c7.\u0001\u0004dY>\u001c7\u000eI\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0004]\u0016$(BAA!\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00131\b\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018A\u0004:f[>$X-\u00113ee\u0016\u001c8\u000fI\u0001\u0015G>tg.Z2u)&lWm\\;u\u001b&dG.[:\u0016\u0005\u00055\u0003cA\u001d\u0002P%\u0019\u0011\u0011\u000b\u001e\u0003\u0007%sG/A\u000bd_:tWm\u0019;US6,w.\u001e;NS2d\u0017n\u001d\u0011\u0002\u0013\u0015t\u0017M\u00197f':LWCAA-!\rI\u00141L\u0005\u0004\u0003;R$a\u0002\"p_2,\u0017M\\\u0001\u000bK:\f'\r\\3T]&\u0004\u0013A\u00065b]\u0012\u001c\b.Y6f)&lWm\\;u\u001b&dG.[:\u0002/!\fg\u000eZ:iC.,G+[7f_V$X*\u001b7mSN\u0004\u0013\u0001E6fKB\fE.\u001b<f'\u0016\u001cwN\u001c3t\u0003EYW-\u001a9BY&4XmU3d_:$7\u000fI\u0001\u000bE>|Go\u001d;sCB\u001cXCAA7!\u0019\ty'a\u001f\u0002\u00005\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u000b\u0002x)\u0019\u0011\u0011P\u0019\u0002\u000b9,G\u000f^=\n\t\u0005u\u0014\u0011\u000f\u0002\u0010\r\u0006\u001cH\u000f\u00165sK\u0006$Gj\\2bYB!\u0011\u0011QAD\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006]\u0014!\u00032p_R\u001cHO]1q\u0013\u0011\tI)a!\u0003\u0013\t{w\u000e^:ue\u0006\u0004\u0018a\u00032p_R\u001cHO]1qg\u0002\nab\u00195b]:,GNR1di>\u0014\u00180\u0006\u0002\u0002\u0012B\"\u00111SAR!\u0019\t)*a'\u0002 6\u0011\u0011q\u0013\u0006\u0005\u00033\u000b9(A\u0004dQ\u0006tg.\u001a7\n\t\u0005u\u0015q\u0013\u0002\u000f\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:z!\u0011\t\t+a)\r\u0001\u0011Y\u0011Q\u0015\u0010\u0002\u0002\u0003\u0005)\u0011AAU\u0005\ty\u0004'A\bdQ\u0006tg.\u001a7GC\u000e$xN]=!#\u0011\tY+!-\u0011\u0007e\ni+C\u0002\u00020j\u0012qAT8uQ&tw\r\u0005\u0003\u00024\u0006eVBAA[\u0015\u0011\t9,a&\u0002\rM|7m[3u\u0013\u0011\tY,!.\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003Yi\u0017\u000f\u001e;DQ\u0006tg.\u001a7J]&$\u0018.\u00197ju\u0016\u0014XCAAa!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'bAAd[\u000511\r\\5f]RLA!a3\u0002F\n1R*\u001d;u\u0007\"\fgN\\3m\u0013:LG/[1mSj,'/A\fncR$8\t[1o]\u0016d\u0017J\\5uS\u0006d\u0017N_3sA\u0005\u00112\u000f^1ug\u0016sw-\u001b8f\u0003\u0012\f\u0007\u000f^3s+\t\t\u0019\u000e\u0005\u0003\u0002V\u0006mWBAAl\u0015\r\tI.L\u0001\u000bK:$XM\u001d9sSN,\u0017\u0002BAo\u0003/\u0014a#T9uiN#\u0018\r^:F]\u001eLg.Z!eCB$XM]\u0001\u0014gR\fGo]#oO&tW-\u00113baR,'\u000f\t\u000b\u0005\u0003\u007f\n\u0019\u000fC\u0004\u0002f\u000e\u0002\r!a:\u0002\u0013\u00154XM\u001c;M_>\u0004\b\u0003BAK\u0003SLA!a;\u0002\u0018\nIQI^3oi2{w\u000e]\u0001\u0013Y\u0006\u001cHoV5mY\u0016C\bO]3tg&|g.\u0006\u0002\u0002rB)\u0011(a=\u0002x&\u0019\u0011Q\u001f\u001e\u0003\r=\u0003H/[8o!\u0011I\u0016.!?\u0011\t\u0005\r\u00171`\u0005\u0005\u0003{\f)M\u0001\u0007NcR$H*Y:u/&dG.A\nmCN$x+\u001b7m\u000bb\u0004(/Z:tS>t\u0007%A\u000ewC2LG-\u0019;f\u001d>$\u0018\t\u001c:fC\u0012L8i\u001c8oK\u000e$X\r\u001a\u000b\u0005\u0005\u000b\u0011\t\u0002E\u0003D\u0005\u000f\u0011Y!C\u0002\u0003\n\u0011\u0013!BV1mS\u0012\fG/[8o!\rI$QB\u0005\u0004\u0005\u001fQ$\u0001B+oSRDa!\u001a\u0014A\u0002\tM\u0001\u0003\u0002B\u000b\u0005/i\u0011\u0001[\u0005\u0004\u00053A'aB*fgNLwN\\\u0001\u0011[F$Ho\u00117jK:$8i\u001c8gS\u001e$BAa\b\u0003(A)1Ia\u0002\u0003\"A!\u00111\u0019B\u0012\u0013\u0011\u0011)#!2\u0003!5\u000bH\u000f^\"mS\u0016tGoQ8oM&<\u0007BB3(\u0001\u0004\u0011\u0019\"A\u0004d_:tWm\u0019;\u0015\u0011\t-!Q\u0006B\u0018\u0005cAQA\u0016\u0015A\u00021DqAa\u0007)\u0001\u0004\u0011\t\u0003\u0003\u0004fQ\u0001\u0007!1C\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0003\u0003\u0006\t]\u0002BB3*\u0001\u0004\u0011\u0019\u0002")
public class Connect
extends MqttAction
implements RequestAction {
    private final Function1<Session, Validation<String>> requestName;
    private final MqttComponents mqttComponents;
    private final CoreComponents coreComponents;
    private final Action next;
    private final String name;
    private final Clock clock;
    private final InetSocketAddress remoteAddress;
    private final int connectTimeoutMillis;
    private final boolean enableSni;
    private final int handshakeTimeoutMillis;
    private final int keepAliveSeconds;
    private final FastThreadLocal<Bootstrap> bootstraps;
    private final ChannelFactory<? extends SocketChannel> channelFactory;
    private final MqttChannelInitializer mqttChannelInitializer;
    private final MqttStatsEngineAdapter statsEngineAdapter;
    private final Option<Function1<Session, Validation<MqttLastWill>>> lastWillExpression;

    public void execute(Session session) {
        RequestAction.execute$((RequestAction)this, (Session)session);
    }

    public Function1<Session, Validation<String>> requestName() {
        return this.requestName;
    }

    public Action next() {
        return this.next;
    }

    public String name() {
        return this.name;
    }

    public Clock clock() {
        return this.clock;
    }

    private InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    private int connectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    private boolean enableSni() {
        return this.enableSni;
    }

    private int handshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    private int keepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    private FastThreadLocal<Bootstrap> bootstraps() {
        return this.bootstraps;
    }

    private ChannelFactory<? extends SocketChannel> channelFactory() {
        return this.channelFactory;
    }

    private MqttChannelInitializer mqttChannelInitializer() {
        return this.mqttChannelInitializer;
    }

    private MqttStatsEngineAdapter statsEngineAdapter() {
        return this.statsEngineAdapter;
    }

    private Bootstrap bootstrap(EventLoop eventLoop) {
        Bootstrap bootstrap;
        block0: {
            bootstrap = (Bootstrap)this.bootstraps().get();
            if (bootstrap != null) break block0;
            bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoop).channelFactory(this.channelFactory())).remoteAddress((SocketAddress)this.remoteAddress()).handler((ChannelHandler)this.mqttChannelInitializer()).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Predef$.MODULE$.int2Integer(this.connectTimeoutMillis())).option(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(this.coreComponents.configuration().socket().tcpNoDelay())).option(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(this.coreComponents.configuration().socket().soKeepAlive()));
            this.bootstraps().set((Object)bootstrap);
        }
        return bootstrap;
    }

    private Option<Function1<Session, Validation<MqttLastWill>>> lastWillExpression() {
        return this.lastWillExpression;
    }

    private Validation<BoxedUnit> validateNotAlreadyConnected(Session session) {
        Validation<MqttClientInstance> validation = MqttClientInstance$.MODULE$.getClient(session);
        if (validation instanceof Success) {
            return Connect$.MODULE$.io$gatling$mqtt$action$Connect$$AlreadyConnectedFailure();
        }
        return Validation$.MODULE$.unit();
    }

    private Validation<MqttClientConfig> mqttClientConfig(Session session) {
        return package$.MODULE$.resolveOptionalExpression(this.mqttComponents.mqttProtocol().clientId(), session).flatMap((Function1 & Serializable)clientId -> package$.MODULE$.resolveOptionalExpression($this.mqttComponents.mqttProtocol().credentials(), session).flatMap((Function1 & Serializable)credentials -> package$.MODULE$.resolveOptionalExpression(this.lastWillExpression(), session).map((Function1 & Serializable)lastWill -> MqttClientConfig$.MODULE$.apply((Option<String>)clientId, (Option<Credentials>)credentials, this.connectTimeoutMillis(), this.keepAliveSeconds(), this.remoteAddress(), this.enableSni(), this.handshakeTimeoutMillis(), (Option<MqttLastWill>)lastWill, session, $this.mqttComponents.mqttProtocol()))));
    }

    private void connect(String requestName, MqttClientConfig mqttClientConfig, Session session) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}: Execute {}", new Object[]{BoxesRunTime.boxToLong((long)session.userId()), requestName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MqttClientImpl client = new MqttClientImpl(this.bootstrap(session.eventLoop()), this.clock(), mqttClientConfig);
        MqttTopicListenerImpl topicListener = new MqttTopicListenerImpl(session.userId(), this.mqttComponents.mqttProtocol().correlator(), this.mqttComponents.mqttProtocol().timeoutCheckInterval(), this.mqttComponents.mqttProtocol().unmatchedInboundMessageBufferSize(), this.statsEngine(), session.eventLoop(), this.clock());
        MqttConnectionListenerImpl connectionListener = new MqttConnectionListenerImpl(requestName, session, client, topicListener, this.remoteAddress(), mqttClientConfig.maxReconnectAttempts(), this.statsEngine(), this.coreComponents.clock(), this.next());
        this.statsEngineAdapter().logRequest(session.scenario(), (List<String>)session.groups(), requestName, this.clock().nowMillis(), true);
        client.connect(connectionListener, topicListener);
    }

    public Validation<BoxedUnit> sendRequest(Session session) {
        return ((Validation)this.requestName().apply((Object)session)).flatMap((Function1 & Serializable)reqName -> this.validateNotAlreadyConnected(session).flatMap((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit = x$3;
            return this.mqttClientConfig(session).map((Function1 & Serializable)config -> {
                Connect.$anonfun$sendRequest$3(this, reqName, session, config);
                return BoxedUnit.UNIT;
            });
        }));
    }

    public static final /* synthetic */ void $anonfun$sendRequest$3(Connect $this, String reqName$1, Session session$3, MqttClientConfig config) {
        $this.connect(reqName$1, config, session$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Connect(Function1<Session, Validation<String>> requestName, MqttComponents mqttComponents, CoreComponents coreComponents, Action next) {
        this.requestName = requestName;
        this.mqttComponents = mqttComponents;
        this.coreComponents = coreComponents;
        this.next = next;
        super(mqttComponents, coreComponents);
        RequestAction.$init$((RequestAction)this);
        this.name = this.genName("mqttConnect");
        this.clock = coreComponents.clock();
        this.remoteAddress = mqttComponents.mqttProtocol().brokerAddress();
        this.connectTimeoutMillis = (int)coreComponents.configuration().socket().connectTimeout().toMillis();
        this.enableSni = coreComponents.configuration().ssl().enableSni();
        this.handshakeTimeoutMillis = (int)coreComponents.configuration().ssl().handshakeTimeout().toMillis();
        this.keepAliveSeconds = (int)mqttComponents.mqttProtocol().keepAlive().toSeconds();
        this.bootstraps = new FastThreadLocal();
        this.channelFactory = Transports.newSocketChannelFactory((boolean)coreComponents.configuration().netty().useNativeTransport(), (boolean)coreComponents.configuration().netty().useIoUring());
        this.mqttChannelInitializer = new MqttChannelInitializer(this.keepAliveSeconds());
        this.statsEngineAdapter = MqttStatsEngineAdapterFactory$.MODULE$.apply(this.statsEngine());
        this.lastWillExpression = mqttComponents.mqttProtocol().lastWill().map((Function1 & Serializable)lastWill -> {
            MqttQoS lastWillQos = (MqttQoS)lastWill.qosOverride().getOrElse((Function0 & Serializable)() -> $this.mqttComponents.mqttProtocol().qos());
            boolean lastWillRetain = BoxesRunTime.unboxToBoolean((Object)lastWill.retainOverride().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.mqttComponents.mqttProtocol().retain()));
            return (Function1 & Serializable)session -> ((Validation)lastWill.topic().apply(session)).flatMap((Function1 & Serializable)willTopic -> ((Validation)lastWill.message().apply(session)).map((Function1 & Serializable)willMessage -> new MqttLastWill((String)willTopic, (byte[])willMessage, lastWillRetain, lastWillQos)));
        });
    }
}

