/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt.internal;

import io.gatling.core.check.Check;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.internal.CoreCheckType;
import io.gatling.mqtt.Predef$;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.List;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;

public final class MqttChecks$ {
    public static final MqttChecks$ MODULE$ = new MqttChecks$();

    private Check<ByteBuf> toScalaCheck(CheckBuilder javaCheck) {
        io.gatling.core.check.CheckBuilder scalaCheck = javaCheck.asScala();
        CheckBuilder.CheckType checkType = javaCheck.type();
        if (CoreCheckType.BodyBytes.equals(checkType)) {
            return scalaCheck.build(Predef$.MODULE$.MqttBufferBodyBytesCorrelatorMaterializer());
        }
        if (CoreCheckType.BodyLength.equals(checkType)) {
            return scalaCheck.build(Predef$.MODULE$.MqttBufferBodyLengthCorrelatorMaterializer());
        }
        if (CoreCheckType.BodyString.equals(checkType)) {
            return scalaCheck.build(Predef$.MODULE$.MqttBufferBodyStringCorrelatorMaterializer());
        }
        if (CoreCheckType.BodyStream.equals(checkType)) {
            return scalaCheck.build(Predef$.MODULE$.MqttBufferBodyStreamCorrelatorMaterializer());
        }
        if (CoreCheckType.Substring.equals(checkType)) {
            return scalaCheck.build(Predef$.MODULE$.MqttBufferSubstringCorrelatorMaterializer());
        }
        if (CoreCheckType.Regex.equals(checkType)) {
            return scalaCheck.build(Predef$.MODULE$.MqttBufferRegexCorrelatorMaterializer());
        }
        if (CoreCheckType.JsonPath.equals(checkType)) {
            return scalaCheck.build(Predef$.MODULE$.mqttBufferJsonPathMaterializer(io.gatling.core.Predef$.MODULE$.defaultJsonParsers()));
        }
        if (CoreCheckType.JmesPath.equals(checkType)) {
            return scalaCheck.build(Predef$.MODULE$.mqttBufferJmesPathMaterializer(io.gatling.core.Predef$.MODULE$.defaultJsonParsers()));
        }
        throw new IllegalArgumentException("MQTT DSL doesn't support " + checkType);
    }

    public Seq<Check<ByteBuf>> toScalaChecks(List<CheckBuilder> javaChecks) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(javaChecks).asScala().map((Function1 & Serializable)javaCheck -> MODULE$.toScalaCheck((CheckBuilder)javaCheck))).toSeq();
    }

    private MqttChecks$() {
    }
}

