/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt;

import io.gatling.javaapi.core.ActionBuilder;
import io.gatling.javaapi.core.Body;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.mqtt.internal.MqttChecks;
import io.gatling.mqtt.action.MqttActionPublishBase;
import io.gatling.mqtt.action.builder.CheckablePublishBuilder;
import io.gatling.mqtt.action.builder.PublishBuilder;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public final class PublishActionBuilder
implements ActionBuilder {
    private final PublishBuilder wrapped;

    public PublishActionBuilder(PublishBuilder publishBuilder) {
        this.wrapped = publishBuilder;
    }

    public @NonNull PublishActionBuilder qosAtMostOnce() {
        return new PublishActionBuilder(this.wrapped.qosAtMostOnce());
    }

    public @NonNull PublishActionBuilder qosAtLeastOnce() {
        return new PublishActionBuilder(this.wrapped.qosAtLeastOnce());
    }

    public @NonNull PublishActionBuilder qosExactlyOnce() {
        return new PublishActionBuilder(this.wrapped.qosExactlyOnce());
    }

    public @NonNull Checkable await(long l) {
        return this.await(Duration.ofSeconds(l));
    }

    public @NonNull Checkable await(@NonNull Duration duration) {
        return new Checkable(this.wrapped.await(Converters.toScalaDuration((Duration)duration)));
    }

    public @NonNull Checkable await(long l, @NonNull String string) {
        return new Checkable(this.wrapped.await(Converters.toScalaDuration((Duration)Duration.ofSeconds(l)), Expressions.toStringExpression((String)string)));
    }

    public @NonNull Checkable await(Duration duration, @NonNull String string) {
        return new Checkable(this.wrapped.await(Converters.toScalaDuration((Duration)duration), Expressions.toStringExpression((String)string)));
    }

    public @NonNull Checkable await(long l, @NonNull Function<Session, String> function) {
        return new Checkable(this.wrapped.await(Converters.toScalaDuration((Duration)Duration.ofSeconds(l)), Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull Checkable await(@NonNull Duration duration, @NonNull Function<Session, String> function) {
        return new Checkable(this.wrapped.await(Converters.toScalaDuration((Duration)duration), Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull Checkable expect(long l) {
        return this.expect(Duration.ofSeconds(l));
    }

    public @NonNull Checkable expect(@NonNull Duration duration) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)duration)));
    }

    public @NonNull Checkable expect(long l, @NonNull String string) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)Duration.ofSeconds(l)), Expressions.toStringExpression((String)string)));
    }

    public @NonNull Checkable expect(@NonNull Duration duration, @NonNull Function<Session, String> function) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)duration), Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull Checkable expect(long l, @NonNull Function<Session, String> function) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)Duration.ofSeconds(l)), Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull Checkable expect(@NonNull Duration duration, @NonNull String string) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)duration), Expressions.toStringExpression((String)string)));
    }

    public io.gatling.core.action.builder.ActionBuilder asScala() {
        return this.wrapped;
    }

    public static class Checkable
    implements ActionBuilder {
        private final PublishBuilder wrapped;

        private Checkable(PublishBuilder publishBuilder) {
            this.wrapped = publishBuilder;
        }

        public @NonNull PublishActionBuilder qosAtMostOnce() {
            return new PublishActionBuilder(this.wrapped.qosAtMostOnce());
        }

        public @NonNull PublishActionBuilder qosAtLeastOnce() {
            return new PublishActionBuilder(this.wrapped.qosAtLeastOnce());
        }

        public @NonNull PublishActionBuilder qosExactlyOnce() {
            return new PublishActionBuilder(this.wrapped.qosExactlyOnce());
        }

        public @NonNull Checkable check(CheckBuilder ... checkBuilderArray) {
            return this.check(List.of(checkBuilderArray));
        }

        public @NonNull Checkable check(@NonNull List<CheckBuilder> list) {
            return new Checkable(((CheckablePublishBuilder)this.wrapped).check(MqttChecks.toScalaChecks(list)));
        }

        public io.gatling.core.action.builder.ActionBuilder asScala() {
            return this.wrapped;
        }
    }

    public static final class Base {
        private final MqttActionPublishBase wrapped;

        Base(MqttActionPublishBase mqttActionPublishBase) {
            this.wrapped = mqttActionPublishBase;
        }

        public @NonNull PublishActionBuilder message(@NonNull Body body) {
            return new PublishActionBuilder(this.wrapped.message(body.asScala()));
        }
    }
}

