/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.component.RequestStatistics;
import io.gatling.charts.component.Stats;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.config.ChartsFiles$;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.GroupContainer$;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.GeneralStats;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.GroupStatsPath;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.stats.RequestStatsPath;
import io.gatling.charts.stats.StatsPath;
import io.gatling.charts.template.ConsoleTemplate;
import io.gatling.charts.template.StatsDotJsTemplate;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import io.gatling.shared.util.NumberHelper;
import io.gatling.shared.util.NumberHelper$;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u000513Qa\u0002\u0005\u0001\u0015AA\u0001b\b\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015!\u0005\u0001\"\u0011F\u0005Q\u0019F/\u0019;t%\u0016\u0004xN\u001d;HK:,'/\u0019;pe*\u0011\u0011BC\u0001\u0007e\u0016\u0004xN\u001d;\u000b\u0005-a\u0011AB2iCJ$8O\u0003\u0002\u000e\u001d\u00059q-\u0019;mS:<'\"A\b\u0002\u0005%|7c\u0001\u0001\u0012+A\u0011!cE\u0007\u0002\u0011%\u0011A\u0003\u0003\u0002\u0010%\u0016\u0004xN\u001d;HK:,'/\u0019;peB\u0011a#H\u0007\u0002/)\u0011\u0001$G\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u00035m\t\u0001\u0002^=qKN\fg-\u001a\u0006\u00029\u0005\u00191m\\7\n\u0005y9\"!D*ue&\u001cG\u000fT8hO&tw-A\fsKB|'\u000f^:HK:,'/\u0019;j_:Le\u000e];ug\u000e\u0001\u0001C\u0001\n#\u0013\t\u0019\u0003BA\fSKB|'\u000f^:HK:,'/\u0019;j_:Le\u000e];ug\u0006Y1\r[1siN4\u0015\u000e\\3t!\t1\u0013&D\u0001(\u0015\tA#\"\u0001\u0004d_:4\u0017nZ\u0005\u0003U\u001d\u00121b\u00115beR\u001ch)\u001b7fg\u000691\r[1sg\u0016$\bCA\u00174\u001b\u0005q#BA\u00160\u0015\t\u0001\u0014'A\u0002oS>T\u0011AM\u0001\u0005U\u00064\u0018-\u0003\u00025]\t91\t[1sg\u0016$\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u00028w5\t\u0001H\u0003\u0002)s)\u0011!\bD\u0001\u0005G>\u0014X-\u0003\u0002=q\t!\"+\u001a9peR\u001c8i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtD#B A\u0003\n\u001b\u0005C\u0001\n\u0001\u0011\u0015yR\u00011\u0001\"\u0011\u0015!S\u00011\u0001&\u0011\u0015YS\u00011\u0001-\u0011\u0015)T\u00011\u00017\u0003!9WM\\3sCR,G#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\tUs\u0017\u000e\u001e")
public class StatsReportGenerator
extends ReportGenerator
implements StrictLogging {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final Charset charset;
    private final ReportsConfiguration configuration;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void generate() {
        GroupContainer rootContainer = GroupContainer$.MODULE$.root(this.computeRequestStats$1(ChartsFiles$.MODULE$.AllRequestLineTitle(), (Option)None$.MODULE$, (Option)None$.MODULE$));
        List<StatsPath> statsPaths = this.reportsGenerationInputs.logFileData().statsPaths();
        Map groupsByHierarchy = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RequestStatsPath requestStatsPath;
                Option<Group> option;
                A1 A1 = x1;
                if (A1 instanceof GroupStatsPath) {
                    GroupStatsPath groupStatsPath = (GroupStatsPath)A1;
                    Group group = groupStatsPath.group();
                    return (B1)group;
                }
                if (A1 instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)A1).group()) instanceof Some) {
                    Some some = (Some)option;
                    Group group = (Group)some.value();
                    return (B1)group;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(StatsPath x1) {
                RequestStatsPath requestStatsPath;
                Option<Group> option;
                StatsPath statsPath = x1;
                if (statsPath instanceof GroupStatsPath) {
                    return true;
                }
                return statsPath instanceof RequestStatsPath && (option = (requestStatsPath = (RequestStatsPath)statsPath).group()) instanceof Some;
            }
        }).map((Function1 & Serializable)group -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group.hierarchy().reverse()), group)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HashSet seenGroups = HashSet$.MODULE$.empty();
        List requestStatsPaths = statsPaths.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends StatsPath, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof RequestStatsPath) {
                    RequestStatsPath requestStatsPath = (RequestStatsPath)A1;
                    return (B1)requestStatsPath;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(StatsPath x2) {
                StatsPath statsPath = x2;
                return statsPath instanceof RequestStatsPath;
            }
        });
        requestStatsPaths.foreach((Function1 & Serializable)x0$1 -> {
            StatsReportGenerator.$anonfun$generate$11(this, rootContainer, seenGroups, groupsByHierarchy, x0$1);
            return BoxedUnit.UNIT;
        });
        new TemplateWriter(this.chartsFiles.statsJsFile()).writeToFile(new StatsDotJsTemplate(rootContainer).getOutput(), this.charset);
        Predef$.MODULE$.println((Object)new ConsoleTemplate(rootContainer.stats(), this.reportsGenerationInputs.logFileData().errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)).getOutput());
    }

    private static final Stats percentiles$1(double rank, Function1 title, GeneralStats total, GeneralStats ok, GeneralStats ko) {
        return new Stats<Integer>((String)title.apply((Object)BoxesRunTime.boxToDouble((double)rank)) + " (ms)", BoxesRunTime.boxToInteger((int)total.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ok.percentile().apply$mcID$sp(rank)), BoxesRunTime.boxToInteger((int)ko.percentile().apply$mcID$sp(rank)), (Numeric<Integer>)Numeric.IntIsIntegral$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$generate$1(double rank) {
        return "response time " + NumberHelper.RichDouble$.MODULE$.toRank$extension(NumberHelper$.MODULE$.RichDouble(rank)) + " percentile";
    }

    private final RequestStatistics computeRequestStats$1(String name, Option requestName, Option group2) {
        String string;
        GeneralStats total = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)None$.MODULE$);
        GeneralStats ok = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)OK$.MODULE$));
        GeneralStats ko = this.reportsGenerationInputs.logFileData().requestGeneralStats((Option<String>)requestName, (Option<Group>)group2, (Option<Status>)new Some((Object)KO$.MODULE$));
        Function1 & Serializable percentilesTitle = (Function1 & Serializable)rank -> StatsReportGenerator.$anonfun$generate$1(BoxesRunTime.unboxToDouble((Object)rank));
        Option option = requestName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String n = (String)some.value();
            string = RequestPath$.MODULE$.path(n, (Option<Group>)group2);
        } else {
            string = (String)group2.map((Function1 & Serializable)group -> RequestPath$.MODULE$.path((Group)group)).getOrElse((Function0 & Serializable)() -> "");
        }
        String path = string;
        return new RequestStatistics(name, path, new Stats<Object>("request count", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$), new Stats<Object>("min response time (ms)", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("max response time (ms)", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("mean response time (ms)", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("response time std deviation (ms)", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile1(), percentilesTitle, total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile2(), percentilesTitle, total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile3(), percentilesTitle, total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile4(), percentilesTitle, total, ok, ko), this.reportsGenerationInputs.logFileData().numberOfRequestInResponseTimeRanges((Option<String>)requestName, (Option<Group>)group2), new Stats<Object>("mean throughput (rps)", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$));
    }

    private final Function2 groupStatsFunction$1() {
        BoxedUnit boxedUnit;
        if (this.configuration.useGroupDurationMetric()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Use group duration stats.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return (Function2 & Serializable)(group, status) -> $this.reportsGenerationInputs.logFileData().groupDurationGeneralStats((Group)group, (Option<Status>)status);
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Use group cumulated response time stats.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Function2 & Serializable)(group, status) -> $this.reportsGenerationInputs.logFileData().groupCumulatedResponseTimeGeneralStats((Group)group, (Option<Status>)status);
    }

    public static final /* synthetic */ String $anonfun$generate$6(double x$1) {
        return "percentiles1";
    }

    public static final /* synthetic */ String $anonfun$generate$7(double x$2) {
        return "percentiles2";
    }

    public static final /* synthetic */ String $anonfun$generate$8(double x$3) {
        return "percentiles3";
    }

    public static final /* synthetic */ String $anonfun$generate$9(double x$4) {
        return "percentiles4";
    }

    private final RequestStatistics computeGroupStats$1(String name, Group group) {
        GeneralStats total = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)None$.MODULE$);
        GeneralStats ok = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)OK$.MODULE$));
        GeneralStats ko = (GeneralStats)this.groupStatsFunction$1().apply((Object)group, (Object)new Some((Object)KO$.MODULE$));
        return new RequestStatistics(name, RequestPath$.MODULE$.path(group), new Stats<Object>("numberOfRequests", BoxesRunTime.boxToLong((long)total.count()), BoxesRunTime.boxToLong((long)ok.count()), BoxesRunTime.boxToLong((long)ko.count()), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$), new Stats<Object>("minResponseTime", BoxesRunTime.boxToInteger((int)total.min()), BoxesRunTime.boxToInteger((int)ok.min()), BoxesRunTime.boxToInteger((int)ko.min()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("maxResponseTime", BoxesRunTime.boxToInteger((int)total.max()), BoxesRunTime.boxToInteger((int)ok.max()), BoxesRunTime.boxToInteger((int)ko.max()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("meanResponseTime", BoxesRunTime.boxToInteger((int)total.mean()), BoxesRunTime.boxToInteger((int)ok.mean()), BoxesRunTime.boxToInteger((int)ko.mean()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), new Stats<Object>("stdDeviation", BoxesRunTime.boxToInteger((int)total.stdDev()), BoxesRunTime.boxToInteger((int)ok.stdDev()), BoxesRunTime.boxToInteger((int)ko.stdDev()), (Numeric<Object>)Numeric.IntIsIntegral$.MODULE$), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile1(), (Function1 & Serializable)x$1 -> StatsReportGenerator.$anonfun$generate$6(BoxesRunTime.unboxToDouble((Object)x$1)), total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile2(), (Function1 & Serializable)x$2 -> StatsReportGenerator.$anonfun$generate$7(BoxesRunTime.unboxToDouble((Object)x$2)), total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile3(), (Function1 & Serializable)x$3 -> StatsReportGenerator.$anonfun$generate$8(BoxesRunTime.unboxToDouble((Object)x$3)), total, ok, ko), StatsReportGenerator.percentiles$1(this.configuration.indicators().percentile4(), (Function1 & Serializable)x$4 -> StatsReportGenerator.$anonfun$generate$9(BoxesRunTime.unboxToDouble((Object)x$4)), total, ok, ko), this.reportsGenerationInputs.logFileData().numberOfRequestInResponseTimeRanges((Option<String>)None$.MODULE$, (Option<Group>)new Some((Object)group)), new Stats<Object>("meanNumberOfRequestsPerSecond", BoxesRunTime.boxToDouble((double)total.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ok.meanRequestsPerSec()), BoxesRunTime.boxToDouble((double)ko.meanRequestsPerSec()), (Numeric<Object>)Numeric.DoubleIsFractional$.MODULE$));
    }

    private final void addGroupsRec$1(List hierarchy, HashSet seenGroups$1, Map groupsByHierarchy$1, GroupContainer rootContainer$1) {
        if (!seenGroups$1.contains((Object)hierarchy)) {
            .colon.colon colon2;
            List tail;
            seenGroups$1.$plus$eq((Object)hierarchy);
            List list = hierarchy;
            if (list instanceof .colon.colon && (tail = (colon2 = (.colon.colon)list).next$access$1()).nonEmpty()) {
                this.addGroupsRec$1(tail, seenGroups$1, groupsByHierarchy$1, rootContainer$1);
            }
            Group group = (Group)groupsByHierarchy$1.apply((Object)hierarchy);
            RequestStatistics stats = this.computeGroupStats$1(group.name(), group);
            rootContainer$1.addGroup(group, stats);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$generate$11(StatsReportGenerator $this, GroupContainer rootContainer$1, HashSet seenGroups$1, Map groupsByHierarchy$1, RequestStatsPath x0$1) {
        RequestStatsPath requestStatsPath = x0$1;
        if (requestStatsPath != null) {
            String request = requestStatsPath.request();
            Option<Group> group2 = requestStatsPath.group();
            group2.foreach((Function1 & Serializable)group -> {
                $this.addGroupsRec$1(group.hierarchy().reverse(), seenGroups$1, groupsByHierarchy$1, rootContainer$1);
                return BoxedUnit.UNIT;
            });
            RequestStatistics stats = $this.computeRequestStats$1(request, (Option)new Some((Object)request), group2);
            rootContainer$1.addRequest(group2, request, stats);
            return;
        }
        throw new MatchError((Object)requestStatsPath);
    }

    public StatsReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, Charset charset, ReportsConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.charset = charset;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

