/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.wait;

import io.fluentlenium.core.FluentControl;
import io.fluentlenium.core.conditions.Conditions;
import io.fluentlenium.core.conditions.message.MessageProxy;
import io.fluentlenium.core.wait.FluentWait;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class BaseWaitConditions {
    protected Function<String, String> messageCustomizer() {
        return Function.identity();
    }

    protected void until(FluentWait wait, Predicate<FluentControl> present, String message) {
        if (wait.hasMessageDefined()) {
            wait.untilPredicate(present);
        } else {
            message = this.messageCustomizer().apply(message);
            ((FluentWait)wait.withMessage(message)).untilPredicate(present);
        }
    }

    protected void until(FluentWait wait, Predicate<FluentControl> present, Supplier<String> messageSupplier) {
        if (wait.hasMessageDefined()) {
            wait.untilPredicate(present);
        } else {
            Supplier<String> customMessageSupplier = () -> this.messageCustomizer().apply((String)messageSupplier.get());
            ((FluentWait)wait.withMessage((Supplier)customMessageSupplier)).untilPredicate(present);
        }
    }

    protected <T extends Conditions<?>> void until(FluentWait wait, T condition, T messageBuilder, Function<T, Boolean> conditionFunction) {
        Predicate<FluentControl> predicate = input -> (Boolean)conditionFunction.apply(condition);
        Supplier<String> messageSupplier = () -> {
            conditionFunction.apply(messageBuilder);
            return MessageProxy.message(messageBuilder);
        };
        this.until(wait, predicate, messageSupplier);
    }
}

