/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.inject;

import io.fluentlenium.core.components.ComponentsManager;
import io.fluentlenium.core.domain.FluentWebElement;
import io.fluentlenium.core.inject.FluentInjectException;
import io.fluentlenium.core.inject.InjectionAnnotationSupport;
import io.fluentlenium.utils.CollectionUtils;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Predicate;
import org.openqa.selenium.WebElement;

final class FluentElementInjectionSupportValidator {
    private final ComponentsManager componentsManager;

    FluentElementInjectionSupportValidator(ComponentsManager componentsManager) {
        this.componentsManager = Objects.requireNonNull(componentsManager);
    }

    boolean isSupported(Object container, Field field) {
        return !this.isInJdkModule(field) && FluentElementInjectionSupportValidator.isFieldExist(container, field) && !InjectionAnnotationSupport.isNoInject(field) && !Modifier.isFinal(field.getModifiers()) && (FluentElementInjectionSupportValidator.isListOfFluentWebElement(field) || this.isListOfComponent(field) || this.isComponent(field) || this.isComponentList(field) || FluentElementInjectionSupportValidator.isWebElement(field) || FluentElementInjectionSupportValidator.isListOfWebElement(field));
    }

    boolean isInJdkModule(Field field) {
        return field.getDeclaringClass().getName().startsWith("java.") || field.getDeclaringClass().getName().startsWith("jdk.");
    }

    private static boolean isFieldExist(Object container, Field field) {
        try {
            return ReflectionUtils.get(field, container) == null;
        }
        catch (IllegalAccessException e) {
            throw new FluentInjectException("Can't retrieve default value of field", e);
        }
    }

    boolean isListOfComponent(Field field) {
        return FluentElementInjectionSupportValidator.isFieldListOf(field, genericType -> this.componentsManager.isComponentClass((Class<?>)genericType));
    }

    boolean isComponent(Field field) {
        return this.componentsManager.isComponentClass(field.getType());
    }

    boolean isComponentList(Field field) {
        boolean componentListClass;
        if (CollectionUtils.isList(field) && (componentListClass = this.componentsManager.isComponentListClass(field.getType()))) {
            Class<?> genericType = ReflectionUtils.getFirstGenericType(field);
            return genericType != null && this.componentsManager.isComponentClass(genericType);
        }
        return false;
    }

    static boolean isListOfFluentWebElement(Field field) {
        return FluentElementInjectionSupportValidator.isFieldListOf(field, FluentWebElement.class::isAssignableFrom);
    }

    static boolean isWebElement(Field field) {
        return WebElement.class.isAssignableFrom(field.getType());
    }

    static boolean isListOfWebElement(Field field) {
        return FluentElementInjectionSupportValidator.isFieldListOf(field, WebElement.class::isAssignableFrom);
    }

    private static boolean isFieldListOf(Field field, Predicate<Class<?>> typePredicate) {
        if (CollectionUtils.isList(field)) {
            Class<?> genericType = ReflectionUtils.getFirstGenericType(field);
            return genericType != null && typePredicate.test(genericType);
        }
        return false;
    }
}

