/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.filter;

import io.fluentlenium.core.domain.FluentWebElement;
import io.fluentlenium.core.filter.AttributeFilterPredicate;
import io.fluentlenium.core.filter.matcher.AbstractMatcher;
import io.fluentlenium.core.filter.matcher.EqualMatcher;
import io.fluentlenium.core.search.SearchFilter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

public class AttributeFilter
implements SearchFilter {
    private final String attributeName;
    private final AbstractMatcher matcher;

    public AttributeFilter(String attributeName, String value) {
        this.attributeName = attributeName;
        this.matcher = new EqualMatcher(value);
    }

    public AttributeFilter(String customAttribute, AbstractMatcher matcher) {
        this.attributeName = customAttribute;
        this.matcher = matcher;
    }

    public String getAttribute() {
        return this.attributeName;
    }

    public AbstractMatcher getMatcher() {
        return this.matcher;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("with ").append(this.getAttribute());
        Optional.ofNullable(this.matcher).map(AbstractMatcher::toString).ifPresent(matcherRepr -> stringBuilder.append(' ').append((String)matcherRepr));
        return stringBuilder.append(' ').append('\"').append(this.matcher.getValue()).append('\"').toString();
    }

    @Override
    public String getCssFilter() {
        String matcherAttribute = Optional.ofNullable(this.matcher).map(AbstractMatcher::getMatcherSymbol).orElse("");
        return "[" + this.getAttribute() + matcherAttribute + "=\"" + this.matcher.getValue() + "\"]";
    }

    @Override
    public boolean isCssFilterSupported() {
        return this.matcher != null && this.matcher.isCssFilterSupported() && !"text".equalsIgnoreCase(this.getAttribute()) && !"textContent".equalsIgnoreCase(this.getAttribute());
    }

    @Override
    public Collection<FluentWebElement> applyFilter(Collection<FluentWebElement> elements) {
        return elements.stream().filter(new AttributeFilterPredicate(this)).collect(Collectors.toList());
    }
}

