/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.events;

import io.fluentlenium.core.domain.FluentWebElement;
import io.fluentlenium.core.events.AbstractAnnotationListener;
import io.fluentlenium.core.events.EventAnnotationsException;
import io.fluentlenium.core.events.FindByListener;
import io.fluentlenium.core.events.ListenerContext;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

class AnnotationFindByListener
extends AbstractAnnotationListener
implements FindByListener {
    private final Method method;
    private final String annotationName;
    private final WebElement targetElement;

    AnnotationFindByListener(ListenerContext listenerContext) {
        super(listenerContext.getContainer(), listenerContext.getPriority());
        this.method = listenerContext.getMethod();
        this.annotationName = listenerContext.getAnnotationName();
        this.targetElement = listenerContext.getTargetElement();
    }

    protected Function<Class<?>, Object> getArgsFunction(By by, FluentWebElement element, WebDriver driver) {
        return input -> {
            if (input.isAssignableFrom(FluentWebElement.class)) {
                return element;
            }
            if (input.isAssignableFrom(By.class)) {
                return by;
            }
            if (input.isAssignableFrom(WebDriver.class)) {
                return driver;
            }
            return null;
        };
    }

    @Override
    public void on(By by, FluentWebElement element, WebDriver driver) {
        if (!(this.targetElement == null || element != null && this.targetElement.equals((Object)element.getElement()))) {
            return;
        }
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(by, element, driver), parameterTypes);
        try {
            ReflectionUtils.invoke(this.method, this.getContainer(), args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + String.valueOf(this.method), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + String.valueOf(this.method), e);
        }
    }
}

