/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.route;

import akka.http.javadsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.StringUtils;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashSet;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MetadataUtil$
implements LazyLogging {
    public static MetadataUtil$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MetadataUtil$();
    }

    private Logger logger$lzycompute() {
        MetadataUtil$ metadataUtil$ = this;
        synchronized (metadataUtil$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectMetadata populateObjectMetadata(HttpRequest request) {
        void var2_2;
        block0: {
            ObjectMetadata metadata = new ObjectMetadata();
            HashSet<String> ignoredHeaders = new HashSet<String>();
            ignoredHeaders.add("Date");
            ignoredHeaders.add("Server");
            ignoredHeaders.add("x-amz-request-id");
            ignoredHeaders.add("x-amz-id-2");
            ignoredHeaders.add("X-Amz-Cf-Id");
            ignoredHeaders.add("Connection");
            Iterable headers = request.getHeaders();
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(headers).asScala()).foreach((Function1 & Serializable & scala.Serializable)header -> {
                MetadataUtil$.$anonfun$populateObjectMetadata$1(metadata, header);
                return BoxedUnit.UNIT;
            });
            if (metadata.getContentType() != null) break block0;
            metadata.setContentType(request.entity().getContentType().toString());
        }
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$populateObjectMetadata$1(ObjectMetadata metadata$1, HttpHeader header) {
        block21: {
            String key = header.name();
            if (StringUtils.beginsWithIgnoreCase((String)key, (String)"x-amz-meta-")) {
                key = key.substring("x-amz-meta-".length());
                metadata$1.addUserMetadata(key, header.value());
            } else if (key.equalsIgnoreCase("Last-Modified")) {
                try {
                    metadata$1.setHeader(key, (Object)ServiceUtils.parseRfc822Date((String)header.value()));
                }
                catch (Exception pe) {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isWarnEnabled()) {
                        MODULE$.logger().underlying().warn(new StringBuilder(36).append("Unable to parse last modified date: ").append(header.value()).toString(), (Throwable)pe);
                        boxedUnit = BoxedUnit.UNIT;
                        break block21;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (key.equalsIgnoreCase("Content-Length")) {
                    try {
                        metadata$1.setHeader(key, (Object)BoxesRunTime.boxToLong((long)Long.parseLong(header.value())));
                    }
                    catch (NumberFormatException nfe) {
                        throw new AmazonClientException(new StringBuilder(74).append("Unable to parse content length. Header 'Content-Length' has corrupted data").append(nfe.getMessage()).toString(), (Throwable)nfe);
                    }
                }
                if (key.equalsIgnoreCase("ETag")) {
                    metadata$1.setHeader(key, (Object)ServiceUtils.removeQuotes((String)header.value()));
                } else if (key.equalsIgnoreCase("Expires")) {
                    try {
                        metadata$1.setHttpExpiresDate(DateUtils.parseRFC822Date((String)header.value()));
                    }
                    catch (Exception pe) {
                        BoxedUnit boxedUnit;
                        if (MODULE$.logger().underlying().isWarnEnabled()) {
                            MODULE$.logger().underlying().warn(new StringBuilder(38).append("Unable to parse http expiration date: ").append(header.value()).toString(), (Throwable)pe);
                            boxedUnit = BoxedUnit.UNIT;
                            break block21;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else if (key.equalsIgnoreCase("x-amz-mp-parts-count")) {
                    try {
                        metadata$1.setHeader(key, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(header.value())).toInt()));
                    }
                    catch (NumberFormatException nfe) {
                        throw new AmazonClientException(new StringBuilder(74).append("Unable to parse part count. Header x-amz-mp-parts-count has corrupted data").append(nfe.getMessage()).toString(), (Throwable)nfe);
                    }
                } else {
                    metadata$1.setHeader(key, (Object)header.value());
                }
            }
        }
    }

    private MetadataUtil$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

