/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.provider;

import akka.http.scaladsl.model.DateTime;
import akka.http.scaladsl.model.DateTime$;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.error.NoSuchBucketException;
import io.findify.s3mock.error.NoSuchKeyException;
import io.findify.s3mock.provider.GetObjectData;
import io.findify.s3mock.provider.InMemoryProvider$BucketContents$;
import io.findify.s3mock.provider.InMemoryProvider$KeyContents$;
import io.findify.s3mock.provider.InMemoryProvider$MultipartChunk$;
import io.findify.s3mock.provider.Provider;
import io.findify.s3mock.provider.metadata.InMemoryMetadataStore;
import io.findify.s3mock.provider.metadata.MetadataStore;
import io.findify.s3mock.request.CompleteMultipartUpload;
import io.findify.s3mock.request.CreateBucketConfiguration;
import io.findify.s3mock.response.Bucket;
import io.findify.s3mock.response.CompleteMultipartUploadResult;
import io.findify.s3mock.response.Content;
import io.findify.s3mock.response.CopyObjectResult;
import io.findify.s3mock.response.CreateBucket;
import io.findify.s3mock.response.InitiateMultipartUploadResult;
import io.findify.s3mock.response.ListAllMyBuckets;
import io.findify.s3mock.response.ListBucket;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.TreeSet;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r}h\u0001B/_\u0001\u001dDQ\u0001 \u0001\u0005\u0002uD\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011\u0011\u0003\u0001C\u0002\u0013%\u00111\u0003\u0005\t\u0005g\u0001\u0001\u0015!\u0003\u0002\u0016!I!Q\u0007\u0001C\u0002\u0013%!q\u0007\u0005\t\u0005\u0003\u0003\u0001\u0015!\u0003\u0003:\u00191\u0011q\b\u0001E\u0003\u0003B!\"a\u0014\t\u0005+\u0007I\u0011AA)\u0011)\tY\u0007\u0003B\tB\u0003%\u00111\u000b\u0005\u000b\u0003[B!Q3A\u0005\u0002\u0005=\u0004B\u0003B\u000b\u0011\tE\t\u0015!\u0003\u0002r!1A\u0010\u0003C\u0001\u0005/A\u0011\"a(\t\u0003\u0003%\tA!\b\t\u0013\u0005\u001d\u0006\"%A\u0005\u0002\u0005%\u0006\"CA`\u0011E\u0005I\u0011\u0001B\u0012\u0011%\t)\rCA\u0001\n\u0003\n9\rC\u0005\u0002X\"\t\t\u0011\"\u0001\u0002Z\"I\u0011\u0011\u001d\u0005\u0002\u0002\u0013\u0005!q\u0005\u0005\n\u0003_D\u0011\u0011!C!\u0003cD\u0011\"a?\t\u0003\u0003%\tAa\u000b\t\u0013\t\u001d\u0001\"!A\u0005B\t%\u0001\"\u0003B\u0006\u0011\u0005\u0005I\u0011\tB\u0007\u0011%\u0011y\u0001CA\u0001\n\u0003\u0012ycB\u0005\u0003\u0004\u0002\t\t\u0011#\u0003\u0003\u0006\u001aI\u0011q\b\u0001\u0002\u0002#%!q\u0011\u0005\u0007yj!\tA!&\t\u0013\t-!$!A\u0005F\t5\u0001\"\u0003BL5\u0005\u0005I\u0011\u0011BM\u0011%\u0011yJGA\u0001\n\u0003\u0013\tK\u0002\u0004\u0002\u0000\u0001!\u0015\u0011\u0011\u0005\u000b\u0003\u0007{\"Q3A\u0005\u0002\u0005E\u0003BCAC?\tE\t\u0015!\u0003\u0002T!Q\u0011qQ\u0010\u0003\u0016\u0004%\t!!#\t\u0015\u0005]uD!E!\u0002\u0013\tY\t\u0003\u0004}?\u0011\u0005\u0011\u0011\u0014\u0005\n\u0003?{\u0012\u0011!C\u0001\u0003CC\u0011\"a* #\u0003%\t!!+\t\u0013\u0005}v$%A\u0005\u0002\u0005\u0005\u0007\"CAc?\u0005\u0005I\u0011IAd\u0011%\t9nHA\u0001\n\u0003\tI\u000eC\u0005\u0002b~\t\t\u0011\"\u0001\u0002d\"I\u0011q^\u0010\u0002\u0002\u0013\u0005\u0013\u0011\u001f\u0005\n\u0003w|\u0012\u0011!C\u0001\u0003{D\u0011Ba\u0002 \u0003\u0003%\tE!\u0003\t\u0013\t-q$!A\u0005B\t5\u0001\"\u0003B\b?\u0005\u0005I\u0011\tB\t\u000f%\u0011\u0019\fAA\u0001\u0012\u0013\u0011)LB\u0005\u0002\u0000\u0001\t\t\u0011#\u0003\u00038\"1A0\rC\u0001\u0005wC\u0011Ba\u00032\u0003\u0003%)E!\u0004\t\u0013\t]\u0015'!A\u0005\u0002\nu\u0006\"\u0003BPc\u0005\u0005I\u0011\u0011Bb\r\u0019\u0011\u0019\u0005\u0001#\u0003F!Q!\u0011\f\u001c\u0003\u0016\u0004%\t!!7\t\u0015\tmcG!E!\u0002\u0013\tY\u000e\u0003\u0006\u0002\bZ\u0012)\u001a!C\u0001\u0003\u0013C!\"a&7\u0005#\u0005\u000b\u0011BAF\u0011\u0019ah\u0007\"\u0001\u0003^!9!1\r\u001c\u0005B\t\u0015\u0004\"CAPm\u0005\u0005I\u0011\u0001B6\u0011%\t9KNI\u0001\n\u0003\u0011\t\bC\u0005\u0002@Z\n\n\u0011\"\u0001\u0002B\"I\u0011Q\u0019\u001c\u0002\u0002\u0013\u0005\u0013q\u0019\u0005\n\u0003/4\u0014\u0011!C\u0001\u00033D\u0011\"!97\u0003\u0003%\tA!\u001e\t\u0013\u0005=h'!A\u0005B\u0005E\b\"CA~m\u0005\u0005I\u0011\u0001B=\u0011%\u00119ANA\u0001\n\u0003\u0012I\u0001C\u0005\u0003\fY\n\t\u0011\"\u0011\u0003\u000e!I!q\u0002\u001c\u0002\u0002\u0013\u0005#QP\u0004\n\u0005\u0017\u0004\u0011\u0011!E\u0005\u0005\u001b4\u0011Ba\u0011\u0001\u0003\u0003EIAa4\t\rqLE\u0011\u0001Bj\u0011%\u0011Y!SA\u0001\n\u000b\u0012i\u0001C\u0005\u0003\u0018&\u000b\t\u0011\"!\u0003V\"I!qT%\u0002\u0002\u0013\u0005%1\u001c\u0005\b\u0005G\u0004A\u0011\tBs\u0011\u001d\u0011i\u000f\u0001C!\u0005_DqA!@\u0001\t\u0003\u0012y\u0010C\u0004\u0004\u001c\u0001!\te!\b\t\u000f\re\u0002\u0001\"\u0011\u0004<!91Q\r\u0001\u0005B\r\u001d\u0004\"CBK\u0001E\u0005I\u0011ABL\u0011\u001d\u0019Y\n\u0001C!\u0007;Cqa!+\u0001\t\u0003\u001aY\u000bC\u0004\u0004:\u0002!\tea/\t\u000f\r%\u0007\u0001\"\u0011\u0004L\"91\u0011\u001d\u0001\u0005B\r\r\b\"CBx\u0001E\u0005I\u0011ABL\u0011\u001d\u0019\t\u0010\u0001C!\u0007gDqa!?\u0001\t\u0003\u001aYP\u0001\tJ]6+Wn\u001c:z!J|g/\u001b3fe*\u0011q\fY\u0001\taJ|g/\u001b3fe*\u0011\u0011MY\u0001\u0007gNjwnY6\u000b\u0005\r$\u0017a\u00024j]\u0012Lg-\u001f\u0006\u0002K\u0006\u0011\u0011n\\\u0002\u0001'\u0011\u0001\u0001N\u001c:\u0011\u0005%dW\"\u00016\u000b\u0003-\fQa]2bY\u0006L!!\u001c6\u0003\r\u0005s\u0017PU3g!\ty\u0007/D\u0001_\u0013\t\thL\u0001\u0005Qe>4\u0018\u000eZ3s!\t\u0019(0D\u0001u\u0015\t)h/\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002xq\u0006AA/\u001f9fg\u00064WMC\u0001z\u0003\r\u0019w.\\\u0005\u0003wR\u00141\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012A \t\u0003_\u0002\tq!\u001c3Ti>\u0014X-\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\ny\u000b\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003\u001b\t9AA\u000bJ]6+Wn\u001c:z\u001b\u0016$\u0018\rZ1uCN#xN]3\u0002\u00115$7\u000b^8sK\u0002\nqBY;dW\u0016$H)\u0019;b'R|'/Z\u000b\u0003\u0003+\u0001\u0002\"a\u0006\u0002\"\u0005\u0015\u00121H\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005}!.\u0001\u0006d_2dWm\u0019;j_:LA!a\t\u0002\u001a\t9AK]5f\u001b\u0006\u0004\b\u0003BA\u0014\u0003kqA!!\u000b\u00022A\u0019\u00111\u00066\u000e\u0005\u00055\"bAA\u0018M\u00061AH]8pizJ1!a\rk\u0003\u0019\u0001&/\u001a3fM&!\u0011qGA\u001d\u0005\u0019\u0019FO]5oO*\u0019\u00111\u00076\u0011\u0007\u0005u\u0002\"D\u0001\u0001\u00059\u0011UoY6fi\u000e{g\u000e^3oiN\u001cb\u0001\u00035\u0002D\u0005%\u0003cA5\u0002F%\u0019\u0011q\t6\u0003\u000fA\u0013x\u000eZ;diB\u0019\u0011.a\u0013\n\u0007\u00055#N\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0007de\u0016\fG/[8o)&lW-\u0006\u0002\u0002TA!\u0011QKA4\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013!B7pI\u0016d'\u0002BA/\u0003?\n\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0005\u0003C\n\u0019'\u0001\u0003iiR\u0004(BAA3\u0003\u0011\t7n[1\n\t\u0005%\u0014q\u000b\u0002\t\t\u0006$X\rV5nK\u0006i1M]3bi&|g\u000eV5nK\u0002\nAb[3zg&s')^2lKR,\"!!\u001d\u0011\u0011\u0005M\u0014\u0011PA\u0013\u0003{j!!!\u001e\u000b\t\u0005]\u0014QD\u0001\b[V$\u0018M\u00197f\u0013\u0011\tY(!\u001e\u0003\u00075\u000b\u0007\u000fE\u0002\u0002>}\u00111bS3z\u0007>tG/\u001a8ugN1q\u0004[A\"\u0003\u0013\nA\u0003\\1ti6{G-\u001b4jG\u0006$\u0018n\u001c8US6,\u0017!\u00067bgRlu\u000eZ5gS\u000e\fG/[8o)&lW\rI\u0001\u0005I\u0006$\u0018-\u0006\u0002\u0002\fB)\u0011.!$\u0002\u0012&\u0019\u0011q\u00126\u0003\u000b\u0005\u0013(/Y=\u0011\u0007%\f\u0019*C\u0002\u0002\u0016*\u0014AAQ=uK\u0006)A-\u0019;bAQ1\u0011QPAN\u0003;Cq!a!%\u0001\u0004\t\u0019\u0006C\u0004\u0002\b\u0012\u0002\r!a#\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003{\n\u0019+!*\t\u0013\u0005\rU\u0005%AA\u0002\u0005M\u0003\"CADKA\u0005\t\u0019AAF\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a++\t\u0005M\u0013QV\u0016\u0003\u0003_\u0003B!!-\u0002<6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u00186\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0006M&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAbU\u0011\tY)!,\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\r\u0005\u0003\u0002L\u0006UWBAAg\u0015\u0011\ty-!5\u0002\t1\fgn\u001a\u0006\u0003\u0003'\fAA[1wC&!\u0011qGAg\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u000eE\u0002j\u0003;L1!a8k\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)/a;\u0011\u0007%\f9/C\u0002\u0002j*\u00141!\u00118z\u0011%\tiOKA\u0001\u0002\u0004\tY.A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003g\u0004b!!>\u0002x\u0006\u0015XBAA\u000f\u0013\u0011\tI0!\b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u007f\u0014)\u0001E\u0002j\u0005\u0003I1Aa\u0001k\u0005\u001d\u0011un\u001c7fC:D\u0011\"!<-\u0003\u0003\u0005\r!!:\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a7\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!3\u0002\r\u0015\fX/\u00197t)\u0011\tyPa\u0005\t\u0013\u00055x&!AA\u0002\u0005\u0015\u0018!D6fsNLeNQ;dW\u0016$\b\u0005\u0006\u0004\u0002<\te!1\u0004\u0005\b\u0003\u001fj\u0001\u0019AA*\u0011\u001d\ti'\u0004a\u0001\u0003c\"b!a\u000f\u0003 \t\u0005\u0002\"CA(\u001dA\u0005\t\u0019AA*\u0011%\tiG\u0004I\u0001\u0002\u0004\t\t(\u0006\u0002\u0003&)\"\u0011\u0011OAW)\u0011\t)O!\u000b\t\u0013\u000558#!AA\u0002\u0005mG\u0003BA\u0000\u0005[A\u0011\"!<\u0016\u0003\u0003\u0005\r!!:\u0015\t\u0005}(\u0011\u0007\u0005\n\u0003[D\u0012\u0011!a\u0001\u0003K\f\u0001CY;dW\u0016$H)\u0019;b'R|'/\u001a\u0011\u0002%5,H\u000e^5qCJ$H+Z7q'R|'/Z\u000b\u0003\u0005s\u0001\u0002\"a\u0006\u0002\"\u0005\u0015\"1\b\t\u0007\u0003g\u0012iD!\u0011\n\t\t}\u0012Q\u000f\u0002\n'>\u0014H/\u001a3TKR\u00042!!\u00107\u00059iU\u000f\u001c;ja\u0006\u0014Ho\u00115v].\u001c\u0002B\u000e5\u0003H\u0005\r\u0013\u0011\n\t\u0007\u0005\u0013\u0012\u0019F!\u0011\u000f\t\t-#q\n\b\u0005\u0003W\u0011i%C\u0001l\u0013\r\u0011\tF[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Fa\u0016\u0003\u000f=\u0013H-\u001a:fI*\u0019!\u0011\u000b6\u0002\rA\f'\u000f\u001e(p\u0003\u001d\u0001\u0018M\u001d;O_\u0002\"bA!\u0011\u0003`\t\u0005\u0004b\u0002B-w\u0001\u0007\u00111\u001c\u0005\b\u0003\u000f[\u0004\u0019AAF\u0003\u001d\u0019w.\u001c9be\u0016$B!a7\u0003h!9!\u0011\u000e\u001fA\u0002\t\u0005\u0013\u0001\u0002;iCR$bA!\u0011\u0003n\t=\u0004\"\u0003B-{A\u0005\t\u0019AAn\u0011%\t9)\u0010I\u0001\u0002\u0004\tY)\u0006\u0002\u0003t)\"\u00111\\AW)\u0011\t)Oa\u001e\t\u0013\u00055()!AA\u0002\u0005mG\u0003BA\u0000\u0005wB\u0011\"!<E\u0003\u0003\u0005\r!!:\u0015\t\u0005}(q\u0010\u0005\n\u0003[<\u0015\u0011!a\u0001\u0003K\f1#\\;mi&\u0004\u0018M\u001d;UK6\u00048\u000b^8sK\u0002\naBQ;dW\u0016$8i\u001c8uK:$8\u000fE\u0002\u0002>i\u0019RA\u0007BE\u0003\u0013\u0002\"Ba#\u0003\u0012\u0006M\u0013\u0011OA\u001e\u001b\t\u0011iIC\u0002\u0003\u0010*\fqA];oi&lW-\u0003\u0003\u0003\u0014\n5%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!QQ\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003w\u0011YJ!(\t\u000f\u0005=S\u00041\u0001\u0002T!9\u0011QN\u000fA\u0002\u0005E\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005G\u0013y\u000bE\u0003j\u0005K\u0013I+C\u0002\u0003(*\u0014aa\u00149uS>t\u0007cB5\u0003,\u0006M\u0013\u0011O\u0005\u0004\u0005[S'A\u0002+va2,'\u0007C\u0005\u00032z\t\t\u00111\u0001\u0002<\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017-+\u0017pQ8oi\u0016tGo\u001d\t\u0004\u0003{\t4#B\u0019\u0003:\u0006%\u0003C\u0003BF\u0005#\u000b\u0019&a#\u0002~Q\u0011!Q\u0017\u000b\u0007\u0003{\u0012yL!1\t\u000f\u0005\rE\u00071\u0001\u0002T!9\u0011q\u0011\u001bA\u0002\u0005-E\u0003\u0002Bc\u0005\u0013\u0004R!\u001bBS\u0005\u000f\u0004r!\u001bBV\u0003'\nY\tC\u0005\u00032V\n\t\u00111\u0001\u0002~\u0005qQ*\u001e7uSB\f'\u000f^\"ik:\\\u0007cAA\u001f\u0013N)\u0011J!5\u0002JAQ!1\u0012BI\u00037\fYI!\u0011\u0015\u0005\t5GC\u0002B!\u0005/\u0014I\u000eC\u0004\u0003Z1\u0003\r!a7\t\u000f\u0005\u001dE\n1\u0001\u0002\fR!!Q\u001cBq!\u0015I'Q\u0015Bp!\u001dI'1VAn\u0003\u0017C\u0011B!-N\u0003\u0003\u0005\rA!\u0011\u0002\u001b5,G/\u00193bi\u0006\u001cFo\u001c:f+\t\u00119\u000f\u0005\u0003\u0002\u0006\t%\u0018\u0002\u0002Bv\u0003\u000f\u0011Q\"T3uC\u0012\fG/Y*u_J,\u0017a\u00037jgR\u0014UoY6fiN,\"A!=\u0011\t\tM(\u0011`\u0007\u0003\u0005kT1Aa>a\u0003!\u0011Xm\u001d9p]N,\u0017\u0002\u0002B~\u0005k\u0014\u0001\u0003T5ti\u0006cG.T=Ck\u000e\\W\r^:\u0002\u00151L7\u000f\u001e\"vG.,G\u000f\u0006\u0006\u0004\u0002\r\u001d11BB\t\u0007+\u0001BAa=\u0004\u0004%!1Q\u0001B{\u0005)a\u0015n\u001d;Ck\u000e\\W\r\u001e\u0005\b\u0007\u0013\u0001\u0006\u0019AA\u0013\u0003\u0019\u0011WoY6fi\"91Q\u0002)A\u0002\r=\u0011A\u00029sK\u001aL\u0007\u0010E\u0003j\u0005K\u000b)\u0003C\u0004\u0004\u0014A\u0003\raa\u0004\u0002\u0013\u0011,G.[7ji\u0016\u0014\bbBB\f!\u0002\u00071\u0011D\u0001\b[\u0006D8.Z=t!\u0015I'QUAn\u00031\u0019'/Z1uK\n+8m[3u)\u0019\u0019yb!\n\u0004*A!!1_B\u0011\u0013\u0011\u0019\u0019C!>\u0003\u0019\r\u0013X-\u0019;f\u0005V\u001c7.\u001a;\t\u000f\r\u001d\u0012\u000b1\u0001\u0002&\u0005!a.Y7f\u0011\u001d\u0019Y#\u0015a\u0001\u0007[\tABY;dW\u0016$8i\u001c8gS\u001e\u0004Baa\f\u000465\u00111\u0011\u0007\u0006\u0004\u0007g\u0001\u0017a\u0002:fcV,7\u000f^\u0005\u0005\u0007o\u0019\tDA\rDe\u0016\fG/\u001a\"vG.,GoQ8oM&<WO]1uS>t\u0017!\u00039vi>\u0013'.Z2u))\u0019ida\u0011\u0004F\r%31\n\t\u0004S\u000e}\u0012bAB!U\n!QK\\5u\u0011\u001d\u0019IA\u0015a\u0001\u0003KAqaa\u0012S\u0001\u0004\t)#A\u0002lKfDq!a\"S\u0001\u0004\tY\tC\u0004\u0004NI\u0003\raa\u0014\u0002\u001d=\u0014'.Z2u\u001b\u0016$\u0018\rZ1uCB!1\u0011KB1\u001b\t\u0019\u0019F\u0003\u0003\u0002Z\rU#\u0002BB,\u00073\n!a]\u001a\u000b\t\rm3QL\u0001\tg\u0016\u0014h/[2fg*\u00191q\f=\u0002\u0013\u0005l\u0017M_8oC^\u001c\u0018\u0002BB2\u0007'\u0012ab\u00142kK\u000e$X*\u001a;bI\u0006$\u0018-A\nd_BLxJ\u00196fGRlU\u000f\u001c;ja\u0006\u0014H\u000f\u0006\u000b\u0004j\r=41OB<\u0007w\u001ayha!\u0004\b\u000e-5q\u0012\t\u0005\u0005g\u001cY'\u0003\u0003\u0004n\tU(\u0001E\"paf|%M[3diJ+7/\u001e7u\u0011\u001d\u0019\th\u0015a\u0001\u0003K\tAb]8ve\u000e,')^2lKRDqa!\u001eT\u0001\u0004\t)#A\u0005t_V\u00148-Z&fs\"91\u0011P*A\u0002\u0005\u0015\u0012A\u00033fgR\u0014UoY6fi\"91QP*A\u0002\u0005\u0015\u0012a\u00023fgR\\U-\u001f\u0005\b\u0007\u0003\u001b\u0006\u0019AAn\u0003\u0011\u0001\u0018M\u001d;\t\u000f\r\u00155\u000b1\u0001\u0002&\u0005AQ\u000f\u001d7pC\u0012LE\rC\u0004\u0004\nN\u0003\r!a7\u0002\u0011\u0019\u0014x.\u001c\"zi\u0016Dqa!$T\u0001\u0004\tY.\u0001\u0004u_\nKH/\u001a\u0005\n\u0007#\u001b\u0006\u0013!a\u0001\u0007'\u000bqA\\3x\u001b\u0016$\u0018\rE\u0003j\u0005K\u001by%A\u000fd_BLxJ\u00196fGRlU\u000f\u001c;ja\u0006\u0014H\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0019IJ\u000b\u0003\u0004\u0014\u00065\u0016!C4fi>\u0013'.Z2u)\u0019\u0019yj!*\u0004(B\u0019qn!)\n\u0007\r\rfLA\u0007HKR|%M[3di\u0012\u000bG/\u0019\u0005\b\u0007\u0013)\u0006\u0019AA\u0013\u0011\u001d\u00199%\u0016a\u0001\u0003K\tq\u0003];u\u001f\nTWm\u0019;Nk2$\u0018\u000e]1siN#\u0018M\u001d;\u0015\u0011\r561WB[\u0007o\u0003BAa=\u00040&!1\u0011\u0017B{\u0005uIe.\u001b;jCR,W*\u001e7uSB\f'\u000f^+qY>\fGMU3tk2$\bbBB\u0005-\u0002\u0007\u0011Q\u0005\u0005\b\u0007\u000f2\u0006\u0019AA\u0013\u0011\u001d\tIA\u0016a\u0001\u0007\u001f\na\u0003];u\u001f\nTWm\u0019;Nk2$\u0018\u000e]1siB\u000b'\u000f\u001e\u000b\r\u0007{\u0019ila0\u0004B\u000e\u00157q\u0019\u0005\b\u0007\u00139\u0006\u0019AA\u0013\u0011\u001d\u00199e\u0016a\u0001\u0003KAqaa1X\u0001\u0004\tY.\u0001\u0006qCJ$h*^7cKJDqa!\"X\u0001\u0004\t)\u0003C\u0004\u0002\b^\u0003\r!a#\u00025A,Ho\u00142kK\u000e$X*\u001e7uSB\f'\u000f^\"p[BdW\r^3\u0015\u0015\r571[Bk\u0007/\u001cI\u000e\u0005\u0003\u0003t\u000e=\u0017\u0002BBi\u0005k\u0014QdQ8na2,G/Z'vYRL\u0007/\u0019:u+Bdw.\u00193SKN,H\u000e\u001e\u0005\b\u0007\u0013A\u0006\u0019AA\u0013\u0011\u001d\u00199\u0005\u0017a\u0001\u0003KAqa!\"Y\u0001\u0004\t)\u0003C\u0004\u00044a\u0003\raa7\u0011\t\r=2Q\\\u0005\u0005\u0007?\u001c\tDA\fD_6\u0004H.\u001a;f\u001bVdG/\u001b9beR,\u0006\u000f\\8bI\u0006Q1m\u001c9z\u001f\nTWm\u0019;\u0015\u0019\r%4Q]Bt\u0007S\u001cYo!<\t\u000f\rE\u0014\f1\u0001\u0002&!91QO-A\u0002\u0005\u0015\u0002bBB=3\u0002\u0007\u0011Q\u0005\u0005\b\u0007{J\u0006\u0019AA\u0013\u0011%\u0019\t*\u0017I\u0001\u0002\u0004\u0019\u0019*\u0001\u000bd_BLxJ\u00196fGR$C-\u001a4bk2$H%N\u0001\rI\u0016dW\r^3PE*,7\r\u001e\u000b\u0007\u0007{\u0019)pa>\t\u000f\r%1\f1\u0001\u0002&!91qI.A\u0002\u0005\u0015\u0012\u0001\u00043fY\u0016$XMQ;dW\u0016$H\u0003BB\u001f\u0007{Dqa!\u0003]\u0001\u0004\t)\u0003")
public class InMemoryProvider
implements Provider,
LazyLogging {
    private volatile InMemoryProvider$BucketContents$ BucketContents$module;
    private volatile InMemoryProvider$KeyContents$ KeyContents$module;
    private volatile InMemoryProvider$MultipartChunk$ MultipartChunk$module;
    private final InMemoryMetadataStore mdStore;
    private final TrieMap<String, BucketContents> bucketDataStore;
    private final TrieMap<String, SortedSet<MultipartChunk>> multipartTempStore;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Option<String> normalizeDelimiter(Option<String> delimiter) {
        return Provider.normalizeDelimiter$(this, delimiter);
    }

    private InMemoryProvider$BucketContents$ BucketContents() {
        if (this.BucketContents$module == null) {
            this.BucketContents$lzycompute$1();
        }
        return this.BucketContents$module;
    }

    private InMemoryProvider$KeyContents$ KeyContents() {
        if (this.KeyContents$module == null) {
            this.KeyContents$lzycompute$1();
        }
        return this.KeyContents$module;
    }

    private InMemoryProvider$MultipartChunk$ MultipartChunk() {
        if (this.MultipartChunk$module == null) {
            this.MultipartChunk$lzycompute$1();
        }
        return this.MultipartChunk$module;
    }

    private Logger logger$lzycompute() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private InMemoryMetadataStore mdStore() {
        return this.mdStore;
    }

    private TrieMap<String, BucketContents> bucketDataStore() {
        return this.bucketDataStore;
    }

    private TrieMap<String, SortedSet<MultipartChunk>> multipartTempStore() {
        return this.multipartTempStore;
    }

    @Override
    public MetadataStore metadataStore() {
        return this.mdStore();
    }

    @Override
    public ListAllMyBuckets listBuckets() {
        BoxedUnit boxedUnit;
        scala.collection.mutable.Iterable buckets = (scala.collection.mutable.Iterable)this.bucketDataStore().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            BucketContents data = (BucketContents)tuple2._2();
            Bucket bucket = new Bucket(name, data.creationTime());
            return bucket;
        }, Iterable$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("listing buckets: {}", new Object[]{buckets.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Iterable$.MODULE$.canBuildFrom())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ListAllMyBuckets("root", UUID.randomUUID().toString(), (List<Bucket>)buckets.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ListBucket listBucket(String bucket, Option<String> prefix, Option<String> delimiter, Option<Object> maxkeys) {
        String prefix2 = (String)prefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            Nil$ nil$;
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            Map matchingKeys = bucketContent.keysInBucket().filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith(prefix2)));
            Iterable matchResults = (Iterable)matchingKeys.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                KeyContents content = (KeyContents)tuple2._2();
                Content content2 = new Content(name, content.lastModificationTime(), DigestUtils.md5Hex((byte[])content.data()), content.data().length, "STANDARD");
                return content2;
            }, scala.collection.Iterable$.MODULE$.canBuildFrom());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("listing bucket contents: {}", new Object[]{matchResults.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.key(), scala.collection.Iterable$.MODULE$.canBuildFrom())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<String> option2 = this.normalizeDelimiter(delimiter);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String del = (String)some2.value();
                nil$ = (List)((SeqLike)((TraversableOnce)matchResults.flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(InMemoryProvider.commonPrefix$1(f.key(), prefix2, del)), scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).distinct();
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                nil$ = Nil$.MODULE$;
            }
            Nil$ commonPrefixes = nil$;
            List filteredFiles = ((TraversableOnce)matchResults.filterNot(arg_0 -> InMemoryProvider.$anonfun$listBucket$6$adapted((List)commonPrefixes, arg_0))).toList();
            int count = BoxesRunTime.unboxToInt((Object)maxkeys.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
            List result = (List)filteredFiles.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.key(), (Ordering)Ordering.String$.MODULE$);
            return new ListBucket(bucket, prefix, delimiter, (List<String>)commonPrefixes, (List<Content>)result.take(count).take(count), result.size() > count);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        throw new NoSuchBucketException(bucket);
    }

    @Override
    public CreateBucket createBucket(String name, CreateBucketConfiguration bucketConfig) {
        BoxedUnit boxedUnit;
        this.bucketDataStore().putIfAbsent((Object)name, (Object)new BucketContents(this, DateTime$.MODULE$.now(), (scala.collection.mutable.Map<String, KeyContents>)new TrieMap()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("creating bucket {}", new Object[]{name});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CreateBucket(name);
    }

    @Override
    public void putObject(String bucket, String key, byte[] data, ObjectMetadata objectMetadata) {
        BucketContents bucketContent;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            bucketContent = (BucketContents)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("putting object for s3://{}/{}, bytes = {}", new Object[]{bucket, key, BoxesRunTime.boxToInteger((int)data.length)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        bucketContent.keysInBucket().put((Object)key, (Object)new KeyContents(this, DateTime$.MODULE$.now(), data));
        objectMetadata.setLastModified(org.joda.time.DateTime.now().toDate());
        this.metadataStore().put(bucket, key, objectMetadata);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public CopyObjectResult copyObjectMultipart(String sourceBucket, String sourceKey, String destBucket, String destKey, int part, String uploadId, int fromByte, int toByte, Option<ObjectMetadata> newMeta) {
        byte[] data = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.getObject(sourceBucket, sourceKey).bytes())).slice(fromByte, toByte + 1);
        this.putObjectMultipartPart(destBucket, destKey, part, uploadId, data);
        return new CopyObjectResult(DateTime$.MODULE$.now(), DigestUtils.md5Hex((byte[])data));
    }

    @Override
    public GetObjectData getObject(String bucket, String key) {
        GetObjectData getObjectData;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            KeyContents keyContent;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            Option option2 = bucketContent.keysInBucket().get((Object)key);
            if (option2 instanceof Some) {
                BoxedUnit boxedUnit;
                Some some2 = (Some)option2;
                keyContent = (KeyContents)some2.value();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("reading object for s://{}/{}", (Object[])new String[]{bucket, key});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new NoSuchKeyException(bucket, key);
                }
                throw new MatchError((Object)option2);
            }
            Option<ObjectMetadata> meta = this.metadataStore().get(bucket, key);
            getObjectData = new GetObjectData(keyContent.data(), meta);
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        GetObjectData getObjectData2 = getObjectData;
        return getObjectData2;
    }

    @Override
    public InitiateMultipartUploadResult putObjectMultipartStart(String bucket, String key, ObjectMetadata metadata) {
        String id;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            id = ((Object)BoxesRunTime.boxToLong((long)Math.abs(Random$.MODULE$.nextLong()))).toString();
            this.multipartTempStore().putIfAbsent((Object)id, (Object)new TreeSet(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
            this.metadataStore().put(bucket, key, metadata);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("starting multipart upload for s3://{}/{}", (Object[])new String[]{bucket, key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        InitiateMultipartUploadResult initiateMultipartUploadResult = new InitiateMultipartUploadResult(bucket, key, id);
        return initiateMultipartUploadResult;
    }

    @Override
    public void putObjectMultipartPart(String bucket, String key, int partNumber, String uploadId, byte[] data) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("uploading multipart chunk {} for s3://{}/{}", new Object[]{BoxesRunTime.boxToInteger((int)partNumber), bucket, key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        ((SetLike)this.multipartTempStore().getOrElseUpdate((Object)uploadId, (Function0 & Serializable & scala.Serializable)() -> new TreeSet(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).add((Object)new MultipartChunk(this, partNumber, data));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public CompleteMultipartUploadResult putObjectMultipartComplete(String bucket, String key, String uploadId, CompleteMultipartUpload request) {
        byte[] completeBytes;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            completeBytes = (byte[])((TraversableOnce)((SetLike)this.multipartTempStore().apply((Object)uploadId)).toSeq().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.data(), Seq$.MODULE$.canBuildFrom())).fold(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$6)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
            bucketContent.keysInBucket().put((Object)key, (Object)new KeyContents(this, DateTime$.MODULE$.now(), completeBytes));
            this.multipartTempStore().remove((Object)uploadId);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("completed multipart upload for s3://{}/{}", (Object[])new String[]{bucket, key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        String hash = DigestUtils.md5Hex((byte[])completeBytes);
        this.metadataStore().get(bucket, key).foreach((Function1 & Serializable & scala.Serializable)m -> {
            InMemoryProvider.$anonfun$putObjectMultipartComplete$3(hash, m);
            return BoxedUnit.UNIT;
        });
        CompleteMultipartUploadResult completeMultipartUploadResult = new CompleteMultipartUploadResult(bucket, key, hash);
        return completeMultipartUploadResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CopyObjectResult copyObject(String sourceBucket, String sourceKey, String destBucket, String destKey, Option<ObjectMetadata> newMeta) {
        Tuple2 tuple2 = new Tuple2((Object)this.bucketDataStore().get((Object)sourceBucket), (Object)this.bucketDataStore().get((Object)destBucket));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                BucketContents srcBucketContent = (BucketContents)some.value();
                if (option2 instanceof Some) {
                    DateTime destFileModTime;
                    KeyContents srcKeyContent;
                    Some some2 = (Some)option2;
                    BucketContents dstBucketContent = (BucketContents)some2.value();
                    Option option3 = srcBucketContent.keysInBucket().get((Object)sourceKey);
                    if (option3 instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some3 = (Some)option3;
                        srcKeyContent = (KeyContents)some3.value();
                        destFileModTime = DateTime$.MODULE$.now();
                        dstBucketContent.keysInBucket().put((Object)destKey, (Object)new KeyContents(this, destFileModTime, (byte[])srcKeyContent.data().clone()));
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Copied s3://{}/{} to s3://{}/{}", new Object[]{sourceBucket, sourceKey, destBucket, destKey});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                        throw new NoSuchKeyException(sourceBucket, sourceKey);
                    }
                    Option sourceMeta = newMeta.orElse((Function0 & Serializable & scala.Serializable)() -> this.metadataStore().get(sourceBucket, sourceKey));
                    sourceMeta.foreach((Function1 & Serializable & scala.Serializable)meta -> {
                        InMemoryProvider.$anonfun$copyObject$2(this, destBucket, destKey, meta);
                        return BoxedUnit.UNIT;
                    });
                    CopyObjectResult copyObjectResult = new CopyObjectResult(destFileModTime, DigestUtils.md5Hex((byte[])srcKeyContent.data()));
                    return copyObjectResult;
                }
            }
        }
        if (tuple2 == null) throw new NoSuchBucketException(destBucket);
        Option option = (Option)tuple2._1();
        if (!None$.MODULE$.equals(option)) throw new NoSuchBucketException(destBucket);
        throw new NoSuchBucketException(sourceBucket);
    }

    @Override
    public Option<ObjectMetadata> copyObjectMultipart$default$9() {
        return None$.MODULE$;
    }

    @Override
    public Option<ObjectMetadata> copyObject$default$5() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteObject(String bucket, String key) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            Option option2 = bucketContent.keysInBucket().get((Object)key);
            if (option2 instanceof Some) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("deleting object s://{}/{}", (Object[])new String[]{bucket, key});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bucketContent.keysInBucket().remove((Object)key);
                this.metadataStore().delete(bucket, key);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                Option option3 = bucketContent.keysInBucket().keys().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith(key)));
                if (option3 instanceof Some) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("recursive delete by prefix is not supported by S3");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    BoxedUnit boxedUnit;
                    if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("key does not exist");
                        boxedUnit = BoxedUnit.UNIT;
                        throw new NoSuchKeyException(bucket, key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new NoSuchKeyException(bucket, key);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            }
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            throw new NoSuchBucketException(bucket);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public void deleteBucket(String bucket) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("deleting bucket s://{}", new Object[]{bucket});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        this.bucketDataStore().remove((Object)bucket);
        this.metadataStore().remove(bucket);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void BucketContents$lzycompute$1() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.BucketContents$module == null) {
                this.BucketContents$module = new InMemoryProvider$BucketContents$(this);
            }
        }
    }

    private final void KeyContents$lzycompute$1() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.KeyContents$module == null) {
                this.KeyContents$module = new InMemoryProvider$KeyContents$(this);
            }
        }
    }

    private final void MultipartChunk$lzycompute$1() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.MultipartChunk$module == null) {
                this.MultipartChunk$module = new InMemoryProvider$MultipartChunk$(this);
            }
        }
    }

    private static final Option commonPrefix$1(String dir, String p, String d) {
        None$ none$;
        int n = dir.indexOf(d, p.length());
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                none$ = new Some((Object)new StringBuilder(0).append(p).append(dir.substring(p.length(), n)).append(d).toString());
                break;
            }
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$7(Content f$1, String p) {
        return f$1.key().startsWith(p);
    }

    public static final /* synthetic */ void $anonfun$putObjectMultipartComplete$3(String hash$1, ObjectMetadata m) {
        m.setContentMD5(hash$1);
        m.setLastModified(org.joda.time.DateTime.now().toDate());
    }

    public static final /* synthetic */ void $anonfun$copyObject$2(InMemoryProvider $this, String destBucket$1, String destKey$1, ObjectMetadata meta) {
        $this.metadataStore().put(destBucket$1, destKey$1, meta);
    }

    public InMemoryProvider() {
        Provider.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.mdStore = new InMemoryMetadataStore();
        this.bucketDataStore = new TrieMap();
        this.multipartTempStore = new TrieMap();
    }

    public static final /* synthetic */ Object $anonfun$listBucket$6$adapted(List commonPrefixes$1, Content f) {
        return BoxesRunTime.boxToBoolean((boolean)commonPrefixes$1.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)InMemoryProvider.$anonfun$listBucket$7(f, p))));
    }

    public class BucketContents
    implements Product,
    scala.Serializable {
        private final DateTime creationTime;
        private final scala.collection.mutable.Map<String, KeyContents> keysInBucket;
        public final /* synthetic */ InMemoryProvider $outer;

        public DateTime creationTime() {
            return this.creationTime;
        }

        public scala.collection.mutable.Map<String, KeyContents> keysInBucket() {
            return this.keysInBucket;
        }

        public BucketContents copy(DateTime creationTime, scala.collection.mutable.Map<String, KeyContents> keysInBucket) {
            return new BucketContents(this.io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer(), creationTime, keysInBucket);
        }

        public DateTime copy$default$1() {
            return this.creationTime();
        }

        public scala.collection.mutable.Map<String, KeyContents> copy$default$2() {
            return this.keysInBucket();
        }

        public String productPrefix() {
            return "BucketContents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            scala.collection.mutable.Map<String, KeyContents> map;
            int n = x$1;
            switch (n) {
                case 0: {
                    map = this.creationTime();
                    break;
                }
                case 1: {
                    map = this.keysInBucket();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return map;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BucketContents;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof BucketContents)) return false;
            if (((BucketContents)object).io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer() != this.io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            BucketContents bucketContents = (BucketContents)x$1;
            DateTime dateTime = this.creationTime();
            DateTime dateTime2 = bucketContents.creationTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            scala.collection.mutable.Map<String, KeyContents> map = this.keysInBucket();
            scala.collection.mutable.Map<String, KeyContents> map2 = bucketContents.keysInBucket();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!bucketContents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer() {
            return this.$outer;
        }

        public BucketContents(InMemoryProvider $outer, DateTime creationTime, scala.collection.mutable.Map<String, KeyContents> keysInBucket) {
            this.creationTime = creationTime;
            this.keysInBucket = keysInBucket;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class KeyContents
    implements Product,
    scala.Serializable {
        private final DateTime lastModificationTime;
        private final byte[] data;
        public final /* synthetic */ InMemoryProvider $outer;

        public DateTime lastModificationTime() {
            return this.lastModificationTime;
        }

        public byte[] data() {
            return this.data;
        }

        public KeyContents copy(DateTime lastModificationTime, byte[] data) {
            return new KeyContents(this.io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer(), lastModificationTime, data);
        }

        public DateTime copy$default$1() {
            return this.lastModificationTime();
        }

        public byte[] copy$default$2() {
            return this.data();
        }

        public String productPrefix() {
            return "KeyContents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.lastModificationTime();
                    break;
                }
                case 1: {
                    object = this.data();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyContents;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof KeyContents)) return false;
            if (((KeyContents)object).io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer() != this.io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            KeyContents keyContents = (KeyContents)x$1;
            DateTime dateTime = this.lastModificationTime();
            DateTime dateTime2 = keyContents.lastModificationTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            if (this.data() != keyContents.data()) return false;
            if (!keyContents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer() {
            return this.$outer;
        }

        public KeyContents(InMemoryProvider $outer, DateTime lastModificationTime, byte[] data) {
            this.lastModificationTime = lastModificationTime;
            this.data = data;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class MultipartChunk
    implements Ordered<MultipartChunk>,
    Product,
    scala.Serializable {
        private final int partNo;
        private final byte[] data;
        public final /* synthetic */ InMemoryProvider $outer;

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public int partNo() {
            return this.partNo;
        }

        public byte[] data() {
            return this.data;
        }

        public int compare(MultipartChunk that) {
            return Predef$.MODULE$.int2Integer(this.partNo()).compareTo(Predef$.MODULE$.int2Integer(that.partNo()));
        }

        public MultipartChunk copy(int partNo, byte[] data) {
            return new MultipartChunk(this.io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer(), partNo, data);
        }

        public int copy$default$1() {
            return this.partNo();
        }

        public byte[] copy$default$2() {
            return this.data();
        }

        public String productPrefix() {
            return "MultipartChunk";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.partNo());
                    break;
                }
                case 1: {
                    object = this.data();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MultipartChunk;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.partNo());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.data()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MultipartChunk)) return false;
            if (((MultipartChunk)object).io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer() != this.io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MultipartChunk multipartChunk = (MultipartChunk)x$1;
            if (this.partNo() != multipartChunk.partNo()) return false;
            if (this.data() != multipartChunk.data()) return false;
            if (!multipartChunk.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer() {
            return this.$outer;
        }

        public MultipartChunk(InMemoryProvider $outer, int partNo, byte[] data) {
            this.partNo = partNo;
            this.data = data;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

