package io.fabric8.tekton.triggers.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TriggerSpecTemplateFluent<A extends TriggerSpecTemplateFluent<A>> extends BaseFluent<A>{
  public TriggerSpecTemplateFluent() {
  }
  
  public TriggerSpecTemplateFluent(TriggerSpecTemplate instance) {
    this.copyInstance(instance);
  }
  private String apiversion;
  private String ref;
  private TriggerTemplateSpecBuilder spec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TriggerSpecTemplate instance) {
    instance = (instance != null ? instance : new TriggerSpecTemplate());
    if (instance != null) {
          this.withApiversion(instance.getApiversion());
          this.withRef(instance.getRef());
          this.withSpec(instance.getSpec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiversion() {
    return this.apiversion;
  }
  
  public A withApiversion(String apiversion) {
    this.apiversion = apiversion;
    return (A) this;
  }
  
  public boolean hasApiversion() {
    return this.apiversion != null;
  }
  
  public String getRef() {
    return this.ref;
  }
  
  public A withRef(String ref) {
    this.ref = ref;
    return (A) this;
  }
  
  public boolean hasRef() {
    return this.ref != null;
  }
  
  public TriggerTemplateSpec buildSpec() {
    return this.spec != null ? this.spec.build() : null;
  }
  
  public A withSpec(TriggerTemplateSpec spec) {
    this._visitables.remove("spec");
    if (spec != null) {
        this.spec = new TriggerTemplateSpecBuilder(spec);
        this._visitables.get("spec").add(this.spec);
    } else {
        this.spec = null;
        this._visitables.get("spec").remove(this.spec);
    }
    return (A) this;
  }
  
  public boolean hasSpec() {
    return this.spec != null;
  }
  
  public SpecNested<A> withNewSpec() {
    return new SpecNested(null);
  }
  
  public SpecNested<A> withNewSpecLike(TriggerTemplateSpec item) {
    return new SpecNested(item);
  }
  
  public SpecNested<A> editSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(null));
  }
  
  public SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(new TriggerTemplateSpecBuilder().build()));
  }
  
  public SpecNested<A> editOrNewSpecLike(TriggerTemplateSpec item) {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TriggerSpecTemplateFluent that = (TriggerSpecTemplateFluent) o;
    if (!java.util.Objects.equals(apiversion, that.apiversion)) return false;
    if (!java.util.Objects.equals(ref, that.ref)) return false;
    if (!java.util.Objects.equals(spec, that.spec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiversion,  ref,  spec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiversion != null) { sb.append("apiversion:"); sb.append(apiversion + ","); }
    if (ref != null) { sb.append("ref:"); sb.append(ref + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SpecNested<N> extends TriggerTemplateSpecFluent<SpecNested<N>> implements Nested<N>{
    SpecNested(TriggerTemplateSpec item) {
      this.builder = new TriggerTemplateSpecBuilder(this, item);
    }
    TriggerTemplateSpecBuilder builder;
    
    public N and() {
      return (N) TriggerSpecTemplateFluent.this.withSpec(builder.build());
    }
    
    public N endSpec() {
      return and();
    }
    
  
  }

}